/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DiscoveredPathInfo
implements IDiscoveredPathManager.IDiscoveredPathInfo {
    private final IProject project;
    private LinkedHashMap discoveredPaths;
    private LinkedHashMap discoveredSymbols;
    private List activePaths;
    private Map activeSymbols;

    public DiscoveredPathInfo(IProject iProject) {
        this.project = iProject;
    }

    public IProject getProject() {
        return this.project;
    }

    public synchronized Map getSymbols() {
        if (this.activeSymbols == null) {
            this.createSymbolsMap();
        }
        Map map = ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols);
        return map;
    }

    public synchronized IPath[] getIncludePaths() {
        if (this.activePaths == null) {
            this.createPathLists();
        }
        return this.activePaths.toArray(new IPath[this.activePaths.size()]);
    }

    public LinkedHashMap getIncludeMap() {
        if (this.discoveredPaths == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredPaths);
    }

    public synchronized void setIncludeMap(LinkedHashMap linkedHashMap) {
        this.discoveredPaths = new LinkedHashMap(linkedHashMap);
        this.activePaths = null;
    }

    private void createPathLists() {
        List list = this.getActivePathList();
        list.clear();
        Iterator iterator = this.discoveredPaths.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Boolean bl = (Boolean)this.discoveredPaths.get(string);
            if (bl != null && bl.booleanValue()) continue;
            list.add(new Path(string));
        }
    }

    public LinkedHashMap getSymbolMap() {
        if (this.discoveredSymbols == null) {
            return new LinkedHashMap();
        }
        return new LinkedHashMap(this.discoveredSymbols);
    }

    public synchronized void setSymbolMap(LinkedHashMap linkedHashMap) {
        this.discoveredSymbols = new LinkedHashMap(linkedHashMap);
        this.activeSymbols = null;
    }

    private void createSymbolsMap() {
        Map map = this.getActiveSymbolsMap();
        map.clear();
        map.putAll(ScannerConfigUtil.scSymbolEntryMap2Map(this.discoveredSymbols));
    }

    private List getActivePathList() {
        if (this.activePaths == null) {
            this.activePaths = new ArrayList();
        }
        return this.activePaths;
    }

    private Map getActiveSymbolsMap() {
        if (this.activeSymbols == null) {
            this.activeSymbols = new HashMap();
        }
        return this.activeSymbols;
    }
}

