/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathContainer;
import org.eclipse.cdt.make.internal.core.scannerconfig.DiscoveredPathInfo;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.SymbolEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DiscoveredPathManager
implements IDiscoveredPathManager,
IResourceChangeListener {
    private static final String CDESCRIPTOR_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".discoveredScannerInfo";
    public static final String INCLUDE_PATH = "includePath";
    public static final String PATH = "path";
    public static final String DEFINED_SYMBOL = "definedSymbol";
    public static final String SYMBOL = "symbol";
    public static final String REMOVED = "removed";
    private Map fDiscoveredMap = new HashMap();
    private List listeners = Collections.synchronizedList(new ArrayList());
    private static final int INFO_CHANGED = 1;
    private static final int INFO_REMOVED = 2;

    public void startup() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getSource() instanceof IWorkspace) {
            IResource iResource = iResourceChangeEvent.getResource();
            switch (iResourceChangeEvent.getType()) {
                case 2: 
                case 4: {
                    if (iResource.getType() != 4) break;
                    this.fDiscoveredMap.remove(iResource);
                }
            }
        }
    }

    public IDiscoveredPathManager.IDiscoveredPathInfo getDiscoveredInfo(IProject iProject) throws CoreException {
        DiscoveredPathInfo discoveredPathInfo = (DiscoveredPathInfo)this.fDiscoveredMap.get(iProject);
        if (discoveredPathInfo == null) {
            discoveredPathInfo = this.loadPathInfo(iProject);
            this.fDiscoveredMap.put(iProject, discoveredPathInfo);
        }
        return discoveredPathInfo;
    }

    private DiscoveredPathInfo loadPathInfo(IProject iProject) throws CoreException {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        this.loadDiscoveredScannerInfoFromState(iProject, linkedHashMap, linkedHashMap2);
        DiscoveredPathInfo discoveredPathInfo = new DiscoveredPathInfo(iProject);
        discoveredPathInfo.setIncludeMap(linkedHashMap);
        discoveredPathInfo.setSymbolMap(linkedHashMap2);
        return discoveredPathInfo;
    }

    public void removeDiscoveredInfo(IProject iProject) {
        ScannerConfigUtil.getDiscoveredScannerConfigStore(iProject, true);
        DiscoveredPathInfo discoveredPathInfo = (DiscoveredPathInfo)this.fDiscoveredMap.remove(iProject);
        if (discoveredPathInfo != null) {
            this.fireUpdate(2, discoveredPathInfo);
        }
    }

    public void updateDiscoveredInfo(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) throws CoreException {
        if (this.fDiscoveredMap.get(iDiscoveredPathInfo.getProject()) != null) {
            DiscoveredPathManager.saveDiscoveredScannerInfoToState((DiscoveredPathInfo)iDiscoveredPathInfo);
            this.fireUpdate(1, iDiscoveredPathInfo);
            ICProject iCProject = CoreModel.getDefault().create(iDiscoveredPathInfo.getProject());
            if (iCProject != null) {
                CoreModel.getDefault().setPathEntryContainer(new ICProject[]{iCProject}, (IPathEntryContainer)new DiscoveredPathContainer(iDiscoveredPathInfo.getProject()), null);
            }
        }
    }

    private void loadDiscoveredScannerInfoFromState(IProject iProject, LinkedHashMap linkedHashMap, LinkedHashMap linkedHashMap2) throws CoreException {
        IPath iPath = ScannerConfigUtil.getDiscoveredScannerConfigStore(iProject, false);
        if (iPath.toFile().exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(iPath.toFile());
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(fileInputStream);
                Node node = document.getFirstChild();
                if (node.getNodeName().equals("scannerInfo")) {
                    Node node2 = node.getFirstChild();
                    this.loadDiscoveredScannerInfo(linkedHashMap, linkedHashMap2, node2);
                }
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)iOException));
            }
            catch (ParserConfigurationException parserConfigurationException) {
                MakeCorePlugin.log(parserConfigurationException);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)parserConfigurationException));
            }
            catch (SAXException sAXException) {
                MakeCorePlugin.log(sAXException);
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)sAXException));
            }
        }
    }

    private void loadDiscoveredScannerInfo(LinkedHashMap linkedHashMap, LinkedHashMap linkedHashMap2, Node node) {
        while (node != null) {
            if (node.getNodeName().equals(INCLUDE_PATH)) {
                linkedHashMap.put(((Element)node).getAttribute(PATH), Boolean.valueOf(((Element)node).getAttribute(REMOVED)));
            } else if (node.getNodeName().equals(DEFINED_SYMBOL)) {
                String string = ((Element)node).getAttribute(SYMBOL);
                String string2 = ((Element)node).getAttribute(REMOVED);
                boolean bl = string2 != null && string2.equals("true");
                ScannerConfigUtil.scAddSymbolString2SymbolEntryMap(linkedHashMap2, string, !bl);
            }
            node = node.getNextSibling();
        }
    }

    private static void saveDiscoveredScannerInfo(DiscoveredPathInfo discoveredPathInfo, Element element, Document document) {
        if (discoveredPathInfo != null) {
            Object object;
            String string;
            Object object2;
            LinkedHashMap linkedHashMap = discoveredPathInfo.getIncludeMap();
            Iterator iterator = linkedHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = document.createElement(INCLUDE_PATH);
                string = (String)iterator.next();
                object2.setAttribute(PATH, string);
                object = (Boolean)linkedHashMap.get(string);
                if (object != null && ((Boolean)object).booleanValue()) {
                    object2.setAttribute(REMOVED, "true");
                }
                element.appendChild((Node)object2);
            }
            object2 = discoveredPathInfo.getSymbolMap();
            iterator = object2.keySet().iterator();
            while (iterator.hasNext()) {
                Element element2;
                String string2;
                string = (String)iterator.next();
                object = (SymbolEntry)object2.get(string);
                Iterator iterator2 = ((SymbolEntry)object).getActiveRaw().iterator();
                while (iterator2.hasNext()) {
                    string2 = (String)iterator2.next();
                    element2 = document.createElement(DEFINED_SYMBOL);
                    element2.setAttribute(SYMBOL, string2);
                    element.appendChild(element2);
                }
                iterator2 = ((SymbolEntry)object).getRemovedRaw().iterator();
                while (iterator2.hasNext()) {
                    string2 = (String)iterator2.next();
                    element2 = document.createElement(DEFINED_SYMBOL);
                    element2.setAttribute(SYMBOL, string2);
                    element2.setAttribute(REMOVED, "true");
                    element.appendChild(element2);
                }
            }
        }
    }

    private static void saveDiscoveredScannerInfoToState(DiscoveredPathInfo discoveredPathInfo) throws CoreException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("scannerInfo");
            element.setAttribute("id", CDESCRIPTOR_ID);
            document.appendChild(element);
            DiscoveredPathManager.saveDiscoveredScannerInfo(discoveredPathInfo, element, document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            transformer.transform(dOMSource, streamResult);
            try {
                IPath iPath = ScannerConfigUtil.getDiscoveredScannerConfigStore(discoveredPathInfo.getProject(), false);
                FileOutputStream fileOutputStream = new FileOutputStream(iPath.toFile());
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)iOException));
            }
            byteArrayOutputStream.close();
        }
        catch (TransformerException transformerException) {
            MakeCorePlugin.log(transformerException);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)transformerException));
        }
        catch (IOException iOException) {
            MakeCorePlugin.log(iOException);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)iOException));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            MakeCorePlugin.log(parserConfigurationException);
            throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, MakeMessages.getString("DiscoveredPathManager.File_Error_Message"), (Throwable)parserConfigurationException));
        }
    }

    private void fireUpdate(final int n, final IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) {
        Object[] objectArray = this.listeners.toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            final IDiscoveredPathManager.IDiscoveredInfoListener iDiscoveredInfoListener = (IDiscoveredPathManager.IDiscoveredInfoListener)objectArray[n2];
            if (iDiscoveredInfoListener != null) {
                Platform.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable throwable) {
                        Status status = new Status(4, "org.eclipse.cdt.core", -1, CCorePlugin.getResourceString((String)"CDescriptorManager.exception.listenerError"), throwable);
                        CCorePlugin.log((IStatus)status);
                    }

                    public void run() throws Exception {
                        switch (n) {
                            case 1: {
                                iDiscoveredInfoListener.infoChanged(iDiscoveredPathInfo);
                                break;
                            }
                            case 2: {
                                iDiscoveredInfoListener.infoRemoved(iDiscoveredPathInfo.getProject());
                            }
                        }
                    }
                });
            }
            ++n2;
        }
    }

    public void addDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener iDiscoveredInfoListener) {
        this.listeners.add(iDiscoveredInfoListener);
    }

    public void removeDiscoveredInfoListener(IDiscoveredPathManager.IDiscoveredInfoListener iDiscoveredInfoListener) {
        this.listeners.remove(iDiscoveredInfoListener);
    }
}

