/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigNature;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class ScannerConfigInfoFactory {
    private static final String PREFIX = MakeCorePlugin.getUniqueIdentifier();
    static final String BUILD_SCANNER_CONFIG_ENABLED = String.valueOf(PREFIX) + ".ScannerConfigDiscoveryEnabled";
    static final String MAKE_BUILDER_PARSER_ENABLED = String.valueOf(PREFIX) + ".makeBuilderParserEnabled";
    static final String MAKE_BUILDER_PARSER_ID = String.valueOf(PREFIX) + ".makeBuilderParserId";
    static final String ESI_PROVIDER_COMMAND_ENABLED = String.valueOf(PREFIX) + ".esiProviderCommandEnabled";
    static final String USE_DEFAULT_ESI_PROVIDER_CMD = String.valueOf(PREFIX) + ".useDefaultESIProviderCmd";
    static final String ESI_PROVIDER_COMMAND = String.valueOf(PREFIX) + ".esiProviderCommand";
    static final String ESI_PROVIDER_ARGUMENTS = String.valueOf(PREFIX) + ".esiProviderArguments";
    static final String ESI_PROVIDER_PARSER_ID = String.valueOf(PREFIX) + ".esiProviderParserId";
    static final String SI_PROBLEM_GENERATION_ENABLED = String.valueOf(PREFIX) + ".siProblemGenerationEnabled";

    public static IScannerConfigBuilderInfo create(Preferences preferences, String string, boolean bl) {
        return new Preference(preferences, string, bl);
    }

    public static IScannerConfigBuilderInfo create(IProject iProject, String string) throws CoreException {
        return new BuildProperty(iProject, string);
    }

    public static IScannerConfigBuilderInfo create(Map map, String string) {
        return new BuildArguments(map, string);
    }

    private static abstract class Store
    implements IScannerConfigBuilderInfo {
        Store() {
        }

        public boolean isAutoDiscoveryEnabled() {
            return this.getBoolean(BUILD_SCANNER_CONFIG_ENABLED);
        }

        public void setAutoDiscoveryEnabled(boolean bl) throws CoreException {
            this.putString(BUILD_SCANNER_CONFIG_ENABLED, Boolean.toString(bl));
        }

        public boolean isMakeBuilderConsoleParserEnabled() {
            if (this.getString(MAKE_BUILDER_PARSER_ENABLED) == null || this.getString(MAKE_BUILDER_PARSER_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(MAKE_BUILDER_PARSER_ENABLED);
        }

        public void setMakeBuilderConsoleParserEnabled(boolean bl) throws CoreException {
            this.putString(MAKE_BUILDER_PARSER_ENABLED, Boolean.toString(bl));
        }

        public String getMakeBuilderConsoleParserId() {
            String string = this.getString(MAKE_BUILDER_PARSER_ID);
            if (string == null || string.length() == 0) {
                String[] stringArray = MakeCorePlugin.getDefault().getScannerInfoConsoleParserIds("makeBuilder");
                string = stringArray[0];
            }
            return string;
        }

        public void setMakeBuilderConsoleParserId(String string) throws CoreException {
            this.putString(MAKE_BUILDER_PARSER_ID, string);
        }

        public boolean isESIProviderCommandEnabled() {
            if (this.getString(ESI_PROVIDER_COMMAND_ENABLED) == null || this.getString(ESI_PROVIDER_COMMAND_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(ESI_PROVIDER_COMMAND_ENABLED);
        }

        public void setESIProviderCommandEnabled(boolean bl) throws CoreException {
            this.putString(ESI_PROVIDER_COMMAND_ENABLED, Boolean.toString(bl));
        }

        public boolean isDefaultESIProviderCmd() {
            if (this.getString(USE_DEFAULT_ESI_PROVIDER_CMD) == null || this.getString(USE_DEFAULT_ESI_PROVIDER_CMD).length() == 0) {
                return true;
            }
            return this.getBoolean(USE_DEFAULT_ESI_PROVIDER_CMD);
        }

        public void setUseDefaultESIProviderCmd(boolean bl) throws CoreException {
            this.putString(USE_DEFAULT_ESI_PROVIDER_CMD, Boolean.toString(bl));
        }

        public IPath getESIProviderCommand() {
            if (this.isDefaultESIProviderCmd()) {
                String string = this.getESIProviderParameter("defaultCommand");
                if (string == null) {
                    return new Path("gcc");
                }
                return new Path(string);
            }
            return new Path(this.getString(ESI_PROVIDER_COMMAND));
        }

        public void setESIProviderCommand(IPath iPath) throws CoreException {
            this.putString(ESI_PROVIDER_COMMAND, iPath.toString());
        }

        public String getESIProviderArguments() {
            if (this.isDefaultESIProviderCmd()) {
                String string = this.getESIProviderParameter("defaultAttributes");
                if (string == null) {
                    string = "-E -P -v ${plugin_state_location}/{specs_file}";
                }
                return string;
            }
            return this.getString(ESI_PROVIDER_ARGUMENTS);
        }

        public void setESIProviderArguments(String string) throws CoreException {
            this.putString(ESI_PROVIDER_ARGUMENTS, string);
        }

        public String getESIProviderConsoleParserId() {
            String string = this.getString(ESI_PROVIDER_PARSER_ID);
            if (string == null || string.length() == 0) {
                String[] stringArray = MakeCorePlugin.getDefault().getScannerInfoConsoleParserIds("externalScannerInfoProvider");
                string = stringArray[0];
            }
            return string;
        }

        public void setESIProviderConsoleParserId(String string) throws CoreException {
            this.putString(ESI_PROVIDER_PARSER_ID, string);
        }

        public boolean isSIProblemGenerationEnabled() {
            if (this.getString(SI_PROBLEM_GENERATION_ENABLED) == null || this.getString(SI_PROBLEM_GENERATION_ENABLED).length() == 0) {
                return true;
            }
            return this.getBoolean(SI_PROBLEM_GENERATION_ENABLED);
        }

        public void setSIProblemGenerationEnabled(boolean bl) throws CoreException {
            this.putString(SI_PROBLEM_GENERATION_ENABLED, Boolean.toString(bl));
        }

        protected boolean getBoolean(String string) {
            return Boolean.valueOf(this.getString(string));
        }

        protected abstract String getBuilderID();

        protected abstract String getString(String var1);

        protected abstract void putString(String var1, String var2) throws CoreException;

        protected String getESIProviderParameter(String string) {
            IExtension iExtension = Platform.getExtensionRegistry().getExtension(MakeCorePlugin.getUniqueIdentifier(), "ExternalScannerInfoProvider", MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
            if (iExtension == null) {
                return null;
            }
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray.length == 0) {
                return null;
            }
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[0].getChildren("run");
            IConfigurationElement[] iConfigurationElementArray3 = iConfigurationElementArray2[0].getChildren("parameter");
            int n = 0;
            while (n < iConfigurationElementArray3.length) {
                if (iConfigurationElementArray3[n].getAttribute("name").equals(string)) {
                    return iConfigurationElementArray3[n].getAttribute("value");
                }
                ++n;
            }
            return null;
        }
    }

    private static class Preference
    extends Store {
        private Preferences prefs;
        private String builderID;
        private boolean useDefaults;

        Preference(Preferences preferences, String string, boolean bl) {
            this.prefs = preferences;
            this.builderID = string;
            this.useDefaults = bl;
        }

        protected void putString(String string, String string2) {
            if (this.useDefaults) {
                this.prefs.setDefault(string, string2);
            } else {
                this.prefs.setValue(string, string2);
            }
        }

        protected String getString(String string) {
            if (this.useDefaults) {
                return this.prefs.getDefaultString(string);
            }
            return this.prefs.getString(string);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildProperty
    extends Store {
        private IProject project;
        private String builderID;
        private Map args;

        BuildProperty(IProject iProject, String string) throws CoreException {
            this.project = iProject;
            this.builderID = string;
            ICommand iCommand = ScannerConfigNature.getBuildSpec(iProject.getDescription(), string);
            if (iCommand == null) {
                throw new CoreException((IStatus)new Status(4, MakeCorePlugin.getUniqueIdentifier(), -1, String.valueOf(MakeMessages.getString("ScannerConfigInfoFactory.Missing_Builder")) + string, null));
            }
            this.args = iCommand.getArguments();
        }

        protected void putString(String string, String string2) throws CoreException {
            String string3 = (String)this.args.get(string);
            if (string3 != null && string3.equals(string2)) {
                return;
            }
            IProjectDescription iProjectDescription = this.project.getDescription();
            ICommand iCommand = ScannerConfigNature.getBuildSpec(iProjectDescription, this.builderID);
            this.args.put(string, string2);
            iCommand.setArguments(this.args);
            MakeProjectNature.setBuildSpec(iProjectDescription, iCommand);
            this.project.setDescription(iProjectDescription, null);
        }

        protected String getString(String string) {
            String string2 = (String)this.args.get(string);
            return string2 == null ? "" : string2;
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }

    private static class BuildArguments
    extends Store {
        private Map args;
        private String builderID;

        BuildArguments(Map map, String string) {
            this.args = map;
            this.builderID = string;
        }

        protected void putString(String string, String string2) {
            this.args.put(string, string2);
        }

        protected String getString(String string) {
            return (String)this.args.get(string);
        }

        protected String getBuilderID() {
            return this.builderID;
        }
    }
}

