/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.MakeProjectNature;
import org.eclipse.cdt.make.core.scannerconfig.IDiscoveredPathManager;
import org.eclipse.cdt.make.core.scannerconfig.IExternalScannerInfoProvider;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigBuilder;
import org.eclipse.cdt.make.core.scannerconfig.ScannerConfigUtil;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CygpathTranslator;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ScannerInfoCollector
implements IScannerInfoCollector {
    private static ScannerInfoCollector instance = new ScannerInfoCollector();
    private Map discoveredIncludes = new HashMap();
    private Map discoveredSymbols = new HashMap();
    private Map discoveredTSO = new HashMap();
    private Map sumDiscoveredIncludes = new HashMap();
    private Map sumDiscoveredSymbols = new HashMap();
    private IProject currentProject;

    private ScannerInfoCollector() {
    }

    public static ScannerInfoCollector getInstance() {
        return instance;
    }

    public void contributeToScannerConfig(IResource iResource, List list, List list2, Map map) {
        IProject iProject;
        if (iResource == null || (iProject = iResource.getProject()) == null) {
            TraceUtil.outputError("IScannerInfoCollector.contributeToScannerConfig : ", "resource or project is null");
            return;
        }
        try {
            if (iProject.hasNature(MakeProjectNature.NATURE_ID) && (iProject.hasNature("org.eclipse.cdt.core.cnature") || iProject.hasNature("org.eclipse.cdt.core.ccnature"))) {
                String string = iProject.getName();
                this.contribute(string, this.discoveredIncludes, list, true);
                this.contribute(string, this.discoveredSymbols, list2, false);
                this.contribute(string, this.discoveredTSO, map == null ? null : (List)map.get(IScannerInfoCollector.TARGET_SPECIFIC_OPTION), false);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    private boolean contribute(String string, Map map, List list, boolean bl) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)map.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList(list);
            map.put(string, arrayList);
            return true;
        }
        return this.addItemsWithOrder(list, arrayList, bl);
    }

    private boolean addItemsWithOrder(List list, List list2, boolean bl) {
        boolean bl2 = false;
        int n = list2.size() - 1;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!list2.contains(string)) {
                list2.add(n + 1, string);
                bl2 = true;
            }
            int n2 = n = bl ? list2.indexOf(string) : list2.size() - 1;
        }
        return bl2;
    }

    private void updateScannerConfig(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo = MakeCorePlugin.getDefault().getDiscoveryManager().getDiscoveredInfo(iProject);
        iProgressMonitor.beginTask(MakeMessages.getString("ScannerInfoCollector.Processing"), 100);
        if (iDiscoveredPathInfo != null) {
            String string = iProject.getName();
            iProgressMonitor.subTask(MakeMessages.getString("ScannerInfoCollector.Processing"));
            if (this.scannerConfigNeedsUpdate(iDiscoveredPathInfo)) {
                iProgressMonitor.worked(50);
                iProgressMonitor.subTask(String.valueOf(MakeMessages.getString("ScannerInfoCollector.Updating")) + string);
                try {
                    MakeCorePlugin.getDefault().getDiscoveryManager().updateDiscoveredInfo(iDiscoveredPathInfo);
                    iProgressMonitor.worked(50);
                }
                catch (CoreException coreException) {
                    MakeCorePlugin.log(coreException);
                }
            }
        }
        iProgressMonitor.done();
    }

    private boolean scannerConfigNeedsUpdate(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo) {
        List list = (List)this.discoveredIncludes.get(iDiscoveredPathInfo.getProject().getName());
        List list2 = (List)this.discoveredSymbols.get(iDiscoveredPathInfo.getProject().getName());
        boolean bl = this.includePathsNeedUpdate(iDiscoveredPathInfo, list);
        boolean bl2 = this.definedSymbolsNeedUpdate(iDiscoveredPathInfo, list2);
        return bl | bl2;
    }

    private boolean includePathsNeedUpdate(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo, List list) {
        boolean bl = false;
        String string = iDiscoveredPathInfo.getProject().getName();
        if (list != null) {
            LinkedHashMap linkedHashMap;
            ArrayList arrayList = (ArrayList)this.sumDiscoveredIncludes.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList(list);
                this.sumDiscoveredIncludes.put(string, arrayList);
                bl = true;
            } else {
                bl = this.addItemsWithOrder(list, arrayList, true);
            }
            List list2 = this.translateIncludePaths(arrayList);
            LinkedHashMap linkedHashMap2 = iDiscoveredPathInfo.getIncludeMap();
            ArrayList arrayList2 = new ArrayList(linkedHashMap2.keySet());
            bl = this.addItemsWithOrder(list2, arrayList2, true);
            if (bl) {
                linkedHashMap = new LinkedHashMap(arrayList2.size());
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (linkedHashMap2.containsKey(string2)) {
                        linkedHashMap.put(string2, linkedHashMap2.get(string2));
                        continue;
                    }
                    linkedHashMap.put(string2, new Path(string2).toFile().exists() ? Boolean.FALSE : Boolean.TRUE);
                }
            } else {
                linkedHashMap = linkedHashMap2;
            }
            iDiscoveredPathInfo.setIncludeMap(linkedHashMap);
            this.discoveredIncludes.put(string, null);
        }
        return bl;
    }

    private boolean definedSymbolsNeedUpdate(IDiscoveredPathManager.IDiscoveredPathInfo iDiscoveredPathInfo, List list) {
        boolean bl = false;
        String string = iDiscoveredPathInfo.getProject().getName();
        if (list != null) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)this.sumDiscoveredSymbols.get(string);
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap();
                this.sumDiscoveredSymbols.put(string, linkedHashMap);
            }
            bl = ScannerConfigUtil.scAddSymbolsList2SymbolEntryMap(linkedHashMap, list, false);
            LinkedHashMap linkedHashMap2 = iDiscoveredPathInfo.getSymbolMap();
            LinkedHashMap linkedHashMap3 = new LinkedHashMap(linkedHashMap2);
            bl |= ScannerConfigUtil.scAddSymbolEntryMap2SymbolEntryMap(linkedHashMap3, linkedHashMap);
            iDiscoveredPathInfo.setSymbolMap(linkedHashMap3);
            this.discoveredSymbols.put(string, null);
        }
        return bl;
    }

    private List translateIncludePaths(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Path path = new Path(string);
            if (!path.toFile().exists()) {
                String string2 = string;
                if (Platform.getOS().equals("win32")) {
                    string2 = new CygpathTranslator(this.currentProject, string).run();
                }
                if (string2 != null) {
                    if (!string2.equals(string)) {
                        Path path2 = new Path(string2);
                        if (path2.toFile().exists()) {
                            arrayList.add(string2);
                            continue;
                        }
                        arrayList.add(string2);
                        continue;
                    }
                    arrayList.add(string2);
                    continue;
                }
                TraceUtil.outputError("CygpathTranslator unable to translate path: ", string);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    private void getProviderScannerInfo(final IProject iProject, final List list, final IProgressMonitor iProgressMonitor) {
        IScannerConfigBuilderInfo iScannerConfigBuilderInfo;
        try {
            iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo(iProject, ScannerConfigBuilder.BUILDER_ID);
        }
        catch (CoreException coreException) {
            iScannerConfigBuilderInfo = MakeCorePlugin.createScannerConfigBuildInfo(MakeCorePlugin.getDefault().getPluginPreferences(), ScannerConfigBuilder.BUILDER_ID, false);
        }
        if (iScannerConfigBuilderInfo.isESIProviderCommandEnabled()) {
            final IScannerConfigBuilderInfo iScannerConfigBuilderInfo2 = iScannerConfigBuilderInfo;
            final IExternalScannerInfoProvider iExternalScannerInfoProvider = MakeCorePlugin.getDefault().getExternalScannerInfoProvider(MakeCorePlugin.DEFAULT_EXTERNAL_SI_PROVIDER_ID);
            if (iExternalScannerInfoProvider != null) {
                ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                    public void run() {
                        iExternalScannerInfoProvider.invokeProvider(iProgressMonitor, iProject, iScannerConfigBuilderInfo2, null, null, list, ScannerInfoCollector.getInstance());
                    }

                    public void handleException(Throwable throwable) {
                        MakeCorePlugin.log(throwable);
                    }
                };
                Platform.run((ISafeRunnable)iSafeRunnable);
            }
        }
    }

    public synchronized void updateScannerConfiguration(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        this.currentProject = iProject;
        String string = iProject.getName();
        iProgressMonitor.beginTask("", 100);
        this.getProviderScannerInfo(iProject, (List)this.discoveredTSO.get(string), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 60));
        this.updateScannerConfig(iProject, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 40));
        this.discoveredIncludes.put(string, null);
        this.discoveredSymbols.put(string, null);
        this.discoveredTSO.put(string, null);
    }

    public void deleteAllPaths(IProject iProject) {
        if (iProject != null) {
            this.sumDiscoveredIncludes.put(iProject.getName(), null);
        }
    }

    public void deleteAllSymbols(IProject iProject) {
        if (iProject != null) {
            this.sumDiscoveredSymbols.put(iProject.getName(), null);
        }
    }

    public void deletePath(IProject iProject, String string) {
        List list;
        if (iProject != null && (list = (List)this.sumDiscoveredIncludes.get(iProject.getName())) != null) {
            list.remove(string);
        }
    }

    public void deleteSymbol(IProject iProject, String string) {
        Map map;
        if (iProject != null && (map = (Map)this.sumDiscoveredSymbols.get(iProject.getName())) != null) {
            ScannerConfigUtil.removeSymbolEntryValue(string, map);
        }
    }

    public String getESIProviderArguments() {
        return null;
    }

    public IPath getESIProviderCommand() {
        return null;
    }
}

