/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GCCScannerInfoConsoleParser
implements IScannerInfoConsoleParser {
    private static final String SINGLE_QUOTE_STRING = "'";
    private static final String DOUBLE_QUOTE_STRING = "\"";
    private IProject fProject = null;
    private IScannerInfoConsoleParserUtility fUtil = null;
    private IScannerInfoCollector fCollector = null;
    private boolean bMultiline = false;
    private String sMultiline = "";

    public void startup(IProject iProject, IScannerInfoConsoleParserUtility iScannerInfoConsoleParserUtility, IScannerInfoCollector iScannerInfoCollector) {
        this.fProject = iProject;
        this.fUtil = iScannerInfoConsoleParserUtility;
        this.fCollector = iScannerInfoCollector;
    }

    public boolean processLine(String string) {
        ArrayList<String> arrayList;
        Iterator<String> iterator;
        boolean bl = false;
        if (string.endsWith("\\")) {
            this.sMultiline = String.valueOf(this.sMultiline) + string.substring(0, string.length() - 1);
            this.bMultiline = true;
            return bl;
        }
        if (this.bMultiline) {
            string = String.valueOf(this.sMultiline) + string;
            this.bMultiline = false;
            this.sMultiline = "";
        }
        TraceUtil.outputTrace("GCCScannerInfoConsoleParser parsing line:", TraceUtil.EOL, string);
        int n = string.indexOf(58);
        String string2 = string.substring(0, n + 1);
        if (n != -1 && string2.indexOf("make") != -1) {
            boolean bl2 = false;
            iterator = string.substring(n + 1).trim();
            bl2 = ((String)((Object)iterator)).startsWith("Entering directory");
            if (bl2 || ((String)((Object)iterator)).startsWith("Leaving directory")) {
                int n2 = ((String)((Object)iterator)).indexOf(96);
                int n3 = ((String)((Object)iterator)).indexOf(39);
                if (n2 != -1 && n3 != -1) {
                    String string3 = ((String)((Object)iterator)).substring(n2 + 1, n3);
                    if (this.fUtil != null) {
                        this.fUtil.changeMakeDirectory(string3, this.getDirectoryLevel(string), bl2);
                    }
                    return bl;
                }
            }
        }
        if ((arrayList = new ArrayList<String>(Arrays.asList(string.split("\\s")))).size() <= 1) {
            return false;
        }
        iterator = arrayList.iterator();
        String string4 = ((String)iterator.next()).toLowerCase();
        if (string4.indexOf("gcc") != -1 || string4.indexOf("g++") != -1 || string4.indexOf("gcc") != -1) {
            Object object;
            Object object2;
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            bl = true;
            String string5 = null;
            this.parseLineForIncludePaths(string, arrayList2);
            this.parseLineForSymbolDefinitions(string, arrayList3);
            while (iterator.hasNext()) {
                string4 = (String)iterator.next();
                if (string4.equals("-mwin32") || string4.equals("-mno-win32") || string4.equals("-mno-cygwin") || string4.equals("-ansi") || string4.equals("-nostdinc") || string4.equals("-posix") || string4.equals("-pthread")) {
                    if (arrayList4.contains(string4)) continue;
                    arrayList4.add(string4);
                    continue;
                }
                object2 = string4.toLowerCase();
                if (!((String)object2).startsWith("..") && !((String)object2).startsWith(".") && !((String)object2).startsWith("/") && !((String)object2).endsWith(".c") && !((String)object2).endsWith(".cpp") && !((String)object2).endsWith(".cc") && !((String)object2).endsWith(".cxx") && !((String)object2).endsWith(".C") && !((String)object2).endsWith(".CC")) continue;
                string5 = string4;
            }
            object2 = this.fProject;
            IFile iFile = null;
            List list = arrayList2;
            if (arrayList2.size() > 0) {
                if (string5 != null) {
                    if (this.fUtil != null && (iFile = this.fUtil.findFile(string5)) != null) {
                        object2 = iFile.getProject();
                        list = this.fUtil.translateRelativePaths(iFile, string5, arrayList2);
                    }
                } else {
                    object = MakeMessages.getString("ConsoleParser.Filename_Missing_Error_Message");
                    TraceUtil.outputError((String)object, string);
                    if (this.fUtil != null) {
                        this.fUtil.generateMarker((IResource)this.fProject, -1, String.valueOf(object) + string, 1, null);
                    }
                }
                if (iFile == null && this.fUtil != null) {
                    list.clear();
                }
            }
            if (list.size() > 0 || arrayList3.size() > 0) {
                object = new HashMap();
                object.put(IScannerInfoCollector.TARGET_SPECIFIC_OPTION, arrayList4);
                this.fCollector.contributeToScannerConfig((IResource)object2, list, arrayList3, (Map)object);
                TraceUtil.outputTrace("Discovered scanner info for file '" + string5 + '\'', "Include paths", arrayList2, list, "Defined symbols", arrayList3);
            }
        }
        return bl;
    }

    private void parseLineForIncludePaths(String string, List list) {
        int n = 0;
        int n2 = string.indexOf("-I", n);
        while (n2 != -1) {
            String string2;
            String string3 = "\\s";
            if (string.charAt(n2 - 1) == '\'' || string.charAt(n2 - 1) == '\"') {
                string3 = String.valueOf(string.charAt(n2 - 1));
            }
            if ((string2 = string.substring(n2 + 2).trim()).charAt(0) != '-') {
                String string4;
                String[] stringArray;
                if (string2.startsWith(SINGLE_QUOTE_STRING) || string2.startsWith(DOUBLE_QUOTE_STRING)) {
                    string3 = string2.substring(0, 1);
                }
                int n3 = (stringArray = string2.split(string3)).length > 1 && stringArray[0].length() == 0 ? 1 : 0;
                String string5 = string4 = stringArray[n3];
                ++n3;
                while (string5.endsWith("\\") && n3 < stringArray.length && stringArray[n3].length() > 0 && !stringArray[n3].startsWith("-")) {
                    int n4 = string2.indexOf(string5) + string5.length();
                    int n5 = string2.indexOf(stringArray[n3]) + stringArray[n3].length();
                    string4 = String.valueOf(string4.substring(0, string4.length() - 1)) + string2.substring(n4, n5);
                    string5 = String.valueOf(string5) + string2.substring(n4, n5);
                    ++n3;
                }
                String string6 = string4;
                if (this.fUtil != null) {
                    string6 = this.fUtil.normalizePath(string4);
                }
                if (!list.contains(string6)) {
                    list.add(string6);
                }
            }
            n = n2 + 2;
            n2 = string.indexOf("-I", n);
        }
    }

    private void parseLineForSymbolDefinitions(String string, List list) {
        int n = 0;
        int n2 = string.indexOf("-D", n);
        while (n2 != -1) {
            block12: {
                int n3;
                int n4;
                String string2;
                int n5;
                String string3;
                block14: {
                    block13: {
                        string3 = "\\s";
                        n5 = 2;
                        string2 = string.substring(n2 + 2).trim();
                        if (string2.charAt(0) == '-') break block12;
                        if (string.charAt(n2 - 1) != '\'' && string.charAt(n2 - 1) != '\"') break block13;
                        string3 = String.valueOf(string.charAt(n2 - 1));
                        n5 = 1;
                        break block14;
                    }
                    String[] stringArray = string2.split(string3, 2);
                    if (stringArray.length <= 0 || stringArray[0].length() <= 0) break block12;
                    n4 = stringArray[0].indexOf(SINGLE_QUOTE_STRING);
                    n3 = stringArray[0].indexOf(DOUBLE_QUOTE_STRING);
                    if (n4 == -1 && n3 == -1) {
                        if (!list.contains(stringArray[0])) {
                            list.add(stringArray[0]);
                        }
                    } else {
                        string3 = n4 != -1 && (n3 == -1 || n4 < n3) ? SINGLE_QUOTE_STRING : DOUBLE_QUOTE_STRING;
                    }
                }
                int n6 = -1;
                n4 = -1;
                do {
                    if ((n6 = string2.indexOf(string3, n6 + 1)) != 0 && (n6 <= 0 || string2.charAt(n6 - 1) == '\\') || --n5 <= 0) continue;
                    n4 = n6;
                } while (n5 > 0 && n6 != -1);
                if (n5 <= 0) {
                    n3 = string2.startsWith(string3) ? 1 : 0;
                    String string4 = string2.substring(n3 != 0 ? 1 : 0, n6);
                    if (n3 == 0 && n4 != -1) {
                        string4 = String.valueOf(string4.substring(0, n4)) + string4.substring(n4 + 1);
                    }
                    if (string3.equals(DOUBLE_QUOTE_STRING)) {
                        string4 = string4.replaceAll("\\\\\"", DOUBLE_QUOTE_STRING);
                    }
                    if (!list.contains(string4)) {
                        list.add(string4);
                    }
                }
            }
            n = n2 + 2;
            n2 = string.indexOf("-D", n);
        }
    }

    public void shutdown() {
        if (this.fUtil != null) {
            this.fUtil.reportProblems();
        }
    }

    private int getDirectoryLevel(String string) {
        int n = string.indexOf(91);
        int n2 = 0;
        if (n != -1) {
            int n3 = string.indexOf(93);
            String string2 = string.substring(n + 1, n3).trim();
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return n2;
    }
}

