/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.gnu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class GCCSpecsConsoleParser
implements IScannerInfoConsoleParser {
    private final int STATE_BEGIN = 0;
    private final int STATE_SPECS_STARTED = 1;
    private final int STATE_INCLUDES_STARTED = 2;
    private IProject fProject = null;
    private IScannerInfoConsoleParserUtility fUtil = null;
    private IScannerInfoCollector fCollector = null;
    private int state = 0;
    private List symbols = new ArrayList();
    private List includes = new ArrayList();

    public void startup(IProject iProject, IScannerInfoConsoleParserUtility iScannerInfoConsoleParserUtility, IScannerInfoCollector iScannerInfoCollector) {
        this.fProject = iProject;
        this.fUtil = iScannerInfoConsoleParserUtility;
        this.fCollector = iScannerInfoCollector;
    }

    public boolean processLine(String string) {
        boolean bl = false;
        TraceUtil.outputTrace("GCCSpecsConsoleParser parsing line:", TraceUtil.EOL, string);
        switch (this.state) {
            case 0: {
                if (string.startsWith("Reading specs from")) {
                    this.state = 1;
                }
                return bl;
            }
            case 1: {
                if (string.indexOf("-D") != -1) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    if (stringTokenizer.countTokens() <= 1) {
                        return bl;
                    }
                    String string2 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3;
                        if (string2.startsWith("-D") && !this.symbols.contains(string3 = string2.substring(2))) {
                            this.symbols.add(string3);
                        }
                        string2 = stringTokenizer.nextToken();
                    }
                }
                if (string.startsWith("#include") && string.endsWith("search starts here:")) {
                    this.state = 2;
                }
                return bl;
            }
            case 2: {
                if (string.startsWith("#include") && string.endsWith("search starts here:")) {
                    this.state = 2;
                } else {
                    if (string.startsWith("End of search list.")) {
                        this.state = 0;
                        break;
                    }
                    if (!this.includes.contains(string)) {
                        this.includes.add(string);
                    }
                }
                return bl;
            }
        }
        this.fCollector.contributeToScannerConfig((IResource)this.fProject, this.includes, this.symbols, new HashMap());
        TraceUtil.outputTrace("Scanner info from 'specs' file", "Include paths", this.includes, new ArrayList(), "Defined symbols", this.symbols);
        return bl;
    }

    public void shutdown() {
        if (this.fUtil != null) {
            this.fUtil.reportProblems();
        }
    }
}

