/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class CygpathTranslator {
    IProject project;
    private String orgPath;
    private String transPath;

    public CygpathTranslator(IProject iProject, String string) {
        this.project = iProject;
        this.orgPath = string;
    }

    public String run() {
        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

            public void run() throws Exception {
                CygpathTranslator.this.transPath = CygpathTranslator.this.platformRun();
                if (CygpathTranslator.this.transPath.startsWith("cygpath:")) {
                    CygpathTranslator.this.transPath = null;
                }
            }

            public void handleException(Throwable throwable) {
                CygpathTranslator.this.transPath = CygpathTranslator.this.orgPath;
                MakeCorePlugin.log(throwable);
            }
        };
        Platform.run((ISafeRunnable)iSafeRunnable);
        return this.transPath;
    }

    private String platformRun() {
        CommandLauncher commandLauncher = new CommandLauncher();
        commandLauncher.showCommand(false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Process process = commandLauncher.execute((IPath)new Path("cygpath"), new String[]{"-m", this.orgPath}, new String[0], this.project.getLocation());
        if (process != null) {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (commandLauncher.waitAndRead((OutputStream)byteArrayOutputStream, (OutputStream)byteArrayOutputStream) == 0) {
                return ((Object)byteArrayOutputStream).toString().trim();
            }
        }
        return this.orgPath;
    }

    private String[] setEnvironment(CommandLauncher commandLauncher, String string) {
        Path path = new Path(string);
        Properties properties = commandLauncher.getEnvironment();
        properties.put("CWD", path.toOSString());
        properties.put("PWD", path.toOSString());
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = properties.propertyNames();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                arrayList.add(String.valueOf(string2) + "=" + properties.getProperty(string2));
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }
}

