/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.core.scannerconfig.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParserUtility;
import org.eclipse.cdt.make.internal.core.MakeMessages;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ScannerInfoConsoleParserUtility
implements IScannerInfoConsoleParserUtility {
    private IProject fProject;
    private IPath fBaseDirectory;
    private IMarkerGenerator fMarkerGenerator;
    private ArrayList fErrors;
    private Map fFilesInProject;
    private List fCollectedFiles;
    private List fNameConflicts;
    private Vector fDirectoryStack;

    public ScannerInfoConsoleParserUtility(IProject iProject, IPath iPath, IMarkerGenerator iMarkerGenerator) {
        this.fProject = iProject;
        this.fMarkerGenerator = iMarkerGenerator;
        this.fBaseDirectory = this.fProject.getLocation();
        this.fErrors = new ArrayList();
        this.fFilesInProject = new HashMap();
        this.fCollectedFiles = new ArrayList();
        this.fNameConflicts = new ArrayList();
        this.fDirectoryStack = new Vector();
        this.collectFiles((IContainer)this.fProject, this.fCollectedFiles);
        int n = 0;
        while (n < this.fCollectedFiles.size()) {
            IFile iFile = (IFile)this.fCollectedFiles.get(n);
            IFile iFile2 = this.fFilesInProject.put(iFile.getName(), iFile);
            if (iFile2 != null) {
                this.fNameConflicts.add(iFile.getName());
            }
            ++n;
        }
        if (iPath != null) {
            this.pushDirectory(iPath);
        }
    }

    public boolean reportProblems() {
        boolean bl = false;
        Iterator iterator = this.fErrors.iterator();
        while (iterator.hasNext()) {
            Problem problem = (Problem)iterator.next();
            if (problem.severity == 3) {
                bl = true;
            }
            if (problem.file == null) {
                this.fMarkerGenerator.addMarker((IResource)this.fProject, problem.lineNumber, problem.description, problem.severity, problem.variableName);
                continue;
            }
            this.fMarkerGenerator.addMarker(problem.file, problem.lineNumber, problem.description, problem.severity, problem.variableName);
        }
        this.fErrors.clear();
        return bl;
    }

    public void generateMarker(IResource iResource, int n, String string, int n2, String string2) {
        if (this.fMarkerGenerator != null) {
            Problem problem = new Problem(iResource, n, string, n2, string2);
            this.fErrors.add(problem);
        }
    }

    public IFile findFile(String string) {
        IFile iFile = this.findFilePath(string);
        if (iFile == null && (iFile = this.findFileName(string)) != null && this.isConflictingName(string)) {
            iFile = null;
            String string2 = MakeMessages.getString("ConsoleParser.Ambiguous_Filepath_Error_Message");
            TraceUtil.outputError(string2, string);
            this.generateMarker((IResource)this.fProject, -1, String.valueOf(string2) + string, 1, null);
        }
        return iFile;
    }

    protected IFile findFilePath(String string) {
        IPath iPath = null;
        Path path = new Path(string);
        if (path.isAbsolute()) {
            if (this.fBaseDirectory.isPrefixOf((IPath)path)) {
                int n = this.fBaseDirectory.matchingFirstSegments((IPath)path);
                iPath = path.removeFirstSegments(n);
            } else {
                iPath = path;
            }
        } else {
            iPath = this.getWorkingDirectory().append(string);
        }
        IFile iFile = null;
        try {
            iFile = this.findFileInWorkspace(iPath);
        }
        catch (Exception exception) {}
        if (iFile == null || !iFile.exists()) {
            File file = iPath.toFile();
            try {
                String string2 = file.getCanonicalPath();
                iPath = new Path(string2);
                iFile = this.findFileInWorkspace(iPath);
            }
            catch (IOException iOException) {}
        }
        return iFile != null && iFile.exists() ? iFile : null;
    }

    protected IFile findFileName(String string) {
        Path path = new Path(string);
        return (IFile)this.fFilesInProject.get(path.lastSegment());
    }

    protected IFile findFileInWorkspace(IPath iPath) {
        IFile iFile = null;
        if (iPath.isAbsolute()) {
            IWorkspaceRoot iWorkspaceRoot = this.fProject.getWorkspace().getRoot();
            iFile = iWorkspaceRoot.getFileForLocation(iPath);
            if (iFile == null) {
                IFile[] iFileArray = iWorkspaceRoot.findFilesForLocation(iPath);
                int n = 0;
                while (n < iFileArray.length) {
                    if (iFileArray[n].getProject().equals((Object)this.fProject)) {
                        iFile = iFileArray[n];
                        break;
                    }
                    ++n;
                }
            }
        } else {
            iFile = this.fProject.getFile(iPath);
        }
        return iFile;
    }

    protected void collectFiles(IContainer iContainer, List list) {
        try {
            IResource[] iResourceArray = iContainer.members();
            int n = 0;
            while (n < iResourceArray.length) {
                IResource iResource = iResourceArray[n];
                if (iResource instanceof IFile) {
                    list.add(iResource);
                } else if (iResource instanceof IContainer) {
                    this.collectFiles((IContainer)iResource, list);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            MakeCorePlugin.log(coreException.getStatus());
        }
    }

    protected boolean isConflictingName(String string) {
        Path path = new Path(string);
        return this.fNameConflicts.contains(path.lastSegment());
    }

    protected IPath getWorkingDirectory() {
        if (this.fDirectoryStack.size() != 0) {
            return (IPath)this.fDirectoryStack.lastElement();
        }
        return this.fBaseDirectory;
    }

    protected void pushDirectory(IPath iPath) {
        if (iPath != null) {
            IPath iPath2 = null;
            if (this.fBaseDirectory.isPrefixOf(iPath)) {
                iPath2 = iPath.removeFirstSegments(this.fBaseDirectory.segmentCount());
            } else if (iPath.toString().startsWith("/cygdrive/")) {
                char c = iPath.toString().charAt(10);
                c = Character.isLowerCase(c) ? Character.toUpperCase(c) : c;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(c);
                stringBuffer.append(':');
                String string = stringBuffer.toString();
                iPath2 = iPath.removeFirstSegments(2);
                iPath2 = iPath2.setDevice(string);
                iPath2 = iPath2.makeAbsolute();
            } else {
                iPath2 = iPath;
            }
            this.fDirectoryStack.addElement(iPath2);
        }
    }

    protected IPath popDirectory() {
        int n = this.getDirectoryLevel();
        if (n != 0) {
            IPath iPath = (IPath)this.fDirectoryStack.lastElement();
            this.fDirectoryStack.removeElementAt(n - 1);
            return iPath;
        }
        return new Path("");
    }

    protected int getDirectoryLevel() {
        return this.fDirectoryStack.size();
    }

    public void changeMakeDirectory(String string, int n, boolean bl) {
        if (bl) {
            int n2 = this.getDirectoryLevel();
            while (n < n2) {
                this.popDirectory();
                n2 = this.getDirectoryLevel();
            }
            this.pushDirectory((IPath)new Path(string));
        } else {
            this.popDirectory();
        }
    }

    public List translateRelativePaths(IFile iFile, String string, List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Path path = new Path(string2);
            if (!path.isAbsolute() && !path.isUNC()) {
                File file;
                Object object;
                IPath iPath;
                IPath iPath2 = this.getWorkingDirectory();
                if (!iPath2.isAbsolute()) {
                    iPath2 = this.fProject.getLocation().append(iPath2);
                }
                if (!(iPath = iPath2.append(string)).toString().equalsIgnoreCase(iFile.getLocation().toString())) {
                    if (string.startsWith("..")) {
                        object = MakeMessages.getString("ConsoleParser.Working_Directory_Error_Message");
                        TraceUtil.outputError((String)object, string);
                        this.generateMarker((IResource)iFile, -1, (String)object, 1, string);
                        break;
                    }
                    object = new Path(string);
                    if (string.startsWith(".")) {
                        object = object.removeFirstSegments(1);
                    }
                    if ((file = (iPath = iFile.getLocation()).removeFirstSegments(iPath.segmentCount() - object.segmentCount())).matchingFirstSegments((IPath)object) == object.segmentCount()) {
                        iPath2 = iPath.removeLastSegments(object.segmentCount());
                    }
                }
                object = iPath2.append((IPath)path);
                file = object.toFile();
                string2 = object.toString();
                if (!file.exists()) {
                    String string3 = MakeMessages.getString("ConsoleParser.Nonexistent_Include_Path_Error_Message");
                    TraceUtil.outputError(string3, string2);
                }
            }
            arrayList.add(string2);
        }
        return arrayList;
    }

    public String normalizePath(String string) {
        int n;
        char c;
        int n2 = string.indexOf(58);
        if (n2 > 0 && Character.isLowerCase(c = string.charAt(n2 - 1))) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n2 - 1 > 0) {
                stringBuffer.append(string.substring(0, n2 - 1));
            }
            stringBuffer.append(Character.toUpperCase(c));
            stringBuffer.append(string.substring(n2));
            string = stringBuffer.toString();
        }
        if (string.indexOf(46) == -1 || string.equals(".")) {
            return new Path(string).toString();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n3 = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.length());
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3 && (n = stringBuffer.indexOf(".", n5)) != -1) {
            boolean bl = false;
            int n6 = stringBuffer.indexOf("..", n5);
            if (n < n6 || n6 == -1) {
                stringBuffer2.append(stringBuffer.substring(n4, n));
                n5 = n + 1;
                if (n5 >= n3) continue;
                if (n == 0 || stringBuffer.charAt(n - 1) == '/' || stringBuffer.charAt(n - 1) == '\\') {
                    bl = true;
                }
                char c2 = stringBuffer.charAt(n5);
                if (bl && c2 == '/') {
                    n4 = ++n5;
                    continue;
                }
                if (bl && c2 == '\\') {
                    if (++n5 >= n3 - 1 || stringBuffer.charAt(n5) == '\\') {
                        // empty if block
                    }
                    n4 = ++n5;
                    continue;
                }
                n4 = n5 - 1;
                continue;
            }
            if (n != n6) continue;
            n5 = n + 2;
        }
        stringBuffer2.append(stringBuffer.substring(n4, n3));
        Path path = new Path(stringBuffer2.toString());
        return path.toString();
    }

    protected class Problem {
        protected IResource file;
        protected int lineNumber;
        protected String description;
        protected int severity;
        protected String variableName;

        public Problem(IResource iResource, int n, String string, int n2, String string2) {
            this.file = iResource;
            this.lineNumber = n;
            this.description = string;
            this.severity = n2;
            this.variableName = string2;
        }
    }
}

