/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch;

import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.spawner.EnvironmentReader;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;

public abstract class AbstractCLaunchDelegate
extends LaunchConfigurationDelegate {
    private IProject project;
    private List orderedProjects;

    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String[] getEnvironmentArray(ILaunchConfiguration iLaunchConfiguration) {
        Map map = null;
        try {
            map = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {}
        if (map == null) {
            return new String[0];
        }
        String[] stringArray = new String[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext() && n < stringArray.length) {
            Map.Entry entry = iterator.next();
            stringArray[n] = String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue();
            ++n;
        }
        return stringArray;
    }

    protected Properties getEnvironmentProperty(ILaunchConfiguration iLaunchConfiguration) {
        Properties properties = new Properties();
        Map map = null;
        try {
            map = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        }
        catch (CoreException coreException) {}
        if (map == null) {
            return properties;
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }

    protected Properties getDefaultEnvironment() {
        return EnvironmentReader.getEnvVars();
    }

    protected Properties expandEnvironment(ILaunchConfiguration iLaunchConfiguration) {
        return this.expandEnvironment(this.getEnvironmentProperty(iLaunchConfiguration));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Properties expandEnvironment(Properties properties) {
        block13: {
            Enumeration<?> enumeration = properties.propertyNames();
            if (enumeration == null) break block13;
            while (enumeration.hasMoreElements()) {
                int n;
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string2 == null || string2.indexOf(36) == -1) continue;
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                int n2 = n = 10;
                boolean bl = false;
                boolean bl2 = false;
                int n3 = 0;
                while (n3 < string2.length()) {
                    block14: {
                        n2 = string2.charAt(n3);
                        switch (n2) {
                            case 39: {
                                if (n == 92) break;
                                bl2 = !bl2;
                                break;
                            }
                            case 36: {
                                char c;
                                if (bl2 || n == 92 || n3 >= string2.length() || string2.indexOf(125, n3) <= 0 || (c = string2.charAt(n3 + 1)) != '{') break;
                                stringBuffer2.setLength(0);
                                bl = true;
                                n = n2;
                                break block14;
                            }
                            case 125: {
                                Properties properties2;
                                if (!bl) break;
                                bl = false;
                                String string3 = null;
                                String string4 = stringBuffer2.toString();
                                if (!string4.equals(string)) {
                                    string3 = properties.getProperty(string4);
                                }
                                if (string3 == null && (properties2 = this.getDefaultEnvironment()) != null) {
                                    string3 = properties2.getProperty(string4);
                                }
                                if (string3 != null) {
                                    stringBuffer.append(string3);
                                }
                                stringBuffer2.setLength(0);
                                n = n2;
                                break block14;
                            }
                        }
                        if (!bl) {
                            stringBuffer.append((char)n2);
                        } else if (n2 != 123 || n != 36) {
                            stringBuffer2.append((char)n2);
                        }
                        n = n2 == 92 && n == 92 ? 10 : n2;
                    }
                    ++n3;
                }
                properties.setProperty(string, stringBuffer.toString());
            }
        }
        return properties;
    }

    public File getWorkingDir(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return this.getWorkingDirectory(iLaunchConfiguration);
    }

    public File getWorkingDirectory(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return this.verifyWorkingDirectory(iLaunchConfiguration);
    }

    protected IPath getWorkingDirectoryPath(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
        if (string != null) {
            return new Path(string);
        }
        return null;
    }

    protected void abort(String string, Throwable throwable, int n) throws CoreException {
        MultiStatus multiStatus = new MultiStatus(this.getPluginID(), n, string, throwable);
        multiStatus.add((IStatus)new Status(4, this.getPluginID(), n, throwable == null ? "" : throwable.getLocalizedMessage(), throwable));
        throw new CoreException((IStatus)multiStatus);
    }

    protected void cancel(String string, int n) throws CoreException {
        throw new CoreException((IStatus)new Status(0, this.getPluginID(), n, string, null));
    }

    protected abstract String getPluginID();

    public static ICProject getCProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        String string = AbstractCLaunchDelegate.getProjectName(iLaunchConfiguration);
        if (string != null && (string = string.trim()).length() > 0) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            ICProject iCProject = CCorePlugin.getDefault().getCoreModel().create(iProject);
            if (iCProject != null && iCProject.exists()) {
                return iCProject;
            }
        }
        return null;
    }

    public static String getProjectName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
    }

    public static String getProgramName(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", null);
    }

    protected void setSourceLocator(ILaunch iLaunch, ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (iLaunch.getSourceLocator() == null) {
            IPersistableSourceLocator iPersistableSourceLocator;
            String string = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
            if (string == null) {
                ICProject iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration);
                if (iCProject == null) {
                    this.abort(LaunchUIPlugin.getResourceString("Launch.common.Project_does_not_exist"), null, 103);
                }
                iPersistableSourceLocator = CDebugUIPlugin.createDefaultSourceLocator();
                iPersistableSourceLocator.initializeDefaults(iLaunchConfiguration);
            } else {
                iPersistableSourceLocator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(string);
                String string2 = iLaunchConfiguration.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
                if (string2 == null) {
                    iPersistableSourceLocator.initializeDefaults(iLaunchConfiguration);
                } else {
                    iPersistableSourceLocator.initializeFromMemento(string2);
                }
            }
            iLaunch.setSourceLocator((ISourceLocator)iPersistableSourceLocator);
        }
    }

    public String getProgramArguments(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
    }

    public String[] getProgramArgumentsArray(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return AbstractCLaunchDelegate.parseArguments(this.getProgramArguments(iLaunchConfiguration));
    }

    private static String[] parseArguments(String string) {
        if (string == null) {
            return new String[0];
        }
        ArgumentParser argumentParser = new ArgumentParser(string);
        String[] stringArray = argumentParser.parseArguments();
        return stringArray;
    }

    protected ICDebugConfiguration getDebugConfig(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ICDebugConfiguration iCDebugConfiguration = null;
        try {
            iCDebugConfiguration = CDebugCorePlugin.getDefault().getDebugConfiguration(iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", ""));
        }
        catch (CoreException coreException) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 106, LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Debugger_not_installed"), (Throwable)coreException);
            IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (iStatusHandler != null) {
                Object object = iStatusHandler.handleStatus((IStatus)status, (Object)this);
                boolean cfr_ignored_0 = object instanceof String;
            }
            throw coreException;
        }
        return iCDebugConfiguration;
    }

    protected String renderTargetLabel(ICDebugConfiguration iCDebugConfiguration) {
        String string = "{0} ({1})";
        String string2 = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(string, iCDebugConfiguration.getName(), string2);
    }

    protected String renderProcessLabel(String string) {
        String string2 = "{0} ({1})";
        String string3 = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(string2, string, string3);
    }

    protected String renderDebuggerProcessLabel() {
        String string = "{0} ({1})";
        String string2 = DateFormat.getInstance().format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(string, LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Debugger_Process"), string2);
    }

    protected ICProject verifyCProject(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        ICProject iCProject;
        String string = AbstractCLaunchDelegate.getProjectName(iLaunchConfiguration);
        if (string == null) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.C_Project_not_specified"), null, 102);
        }
        if ((iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration)) == null) {
            IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            if (!iProject.exists()) {
                this.abort(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.Project_NAME_does_not_exist", string), null, 103);
            } else if (!iProject.isOpen()) {
                this.abort(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.Project_NAME_is_closed", string), null, 103);
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Not_a_C_CPP_project"), null, 103);
        }
        return iCProject;
    }

    protected IFile getProgramFile(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IFile iFile;
        ICProject iCProject = this.verifyCProject(iLaunchConfiguration);
        String string = AbstractCLaunchDelegate.getProgramName(iLaunchConfiguration);
        if (string == null) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Program_file_not_specified"), null, 105);
        }
        if ((iFile = ((IProject)iCProject.getResource()).getFile(string)) == null || !iFile.exists() || !iFile.getLocation().toFile().exists()) {
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Program_file_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", iFile.getLocation().toOSString())), 104);
        }
        return iFile;
    }

    protected IPath verifyProgramFile(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        return this.getProgramFile(iLaunchConfiguration).getLocation();
    }

    public File verifyWorkingDirectory(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        IPath iPath = this.getWorkingDirectoryPath(iLaunchConfiguration);
        if (iPath == null) {
            ICProject iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration);
            if (iCProject != null) {
                IProject iProject = iCProject.getProject();
                return iProject.getLocation().toFile();
            }
        } else if (iPath.isAbsolute()) {
            File file = new File(iPath.toOSString());
            if (file.isDirectory()) {
                return file;
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_not_found", iPath.toOSString())), 101);
        } else {
            IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(iPath);
            if (iResource instanceof IContainer && iResource.exists()) {
                return iResource.getLocation().toFile();
            }
            this.abort(LaunchUIPlugin.getResourceString("AbstractCLaunchDelegate.Working_directory_does_not_exist"), new FileNotFoundException(LaunchUIPlugin.getFormattedResourceString("AbstractCLaunchDelegate.PROGRAM_PATH_does_not_exist", iPath.toOSString())), 101);
        }
        return null;
    }

    private void getReferencedProjectSet(IProject iProject, HashSet hashSet) throws CoreException {
        IProject[] iProjectArray = iProject.getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject2 = iProjectArray[n];
            if (iProject2.exists() && !hashSet.contains(iProject2)) {
                hashSet.add(iProject2);
                this.getReferencedProjectSet(iProject2, hashSet);
            }
            ++n;
        }
    }

    private List getBuildOrder(List list) {
        String[] stringArray = ResourcesPlugin.getWorkspace().getDescription().getBuildOrder();
        if (stringArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
            ArrayList arrayList2 = new ArrayList(list.size());
            arrayList2.addAll(list);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                int n2 = 0;
                while (n2 < list.size()) {
                    IProject iProject = (IProject)list.get(n2);
                    if (iProject.getName().equals(string)) {
                        arrayList.add(iProject);
                        arrayList2.remove(iProject);
                        break;
                    }
                    ++n2;
                }
                ++n;
            }
            arrayList.addAll(arrayList2);
            return arrayList;
        }
        IProject[] iProjectArray = new IProject[list.size()];
        iProjectArray = list.toArray(iProjectArray);
        IWorkspace.ProjectOrder projectOrder = ResourcesPlugin.getWorkspace().computeProjectOrder(iProjectArray);
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        arrayList.addAll(Arrays.asList(projectOrder.projects));
        return arrayList;
    }

    public boolean buildForLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.orderedProjects != null) {
            iProgressMonitor.beginTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.building_projects"), this.orderedProjects.size() + 1);
            Iterator iterator = this.orderedProjects.iterator();
            while (iterator.hasNext()) {
                IProject iProject = (IProject)iterator.next();
                iProgressMonitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.building")) + iProject.getName());
                iProject.build(10, iProgressMonitor);
            }
            iProgressMonitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractLaunchConfigurationDelegate.building")) + this.project.getName());
            this.project.build(10, iProgressMonitor);
        }
        iProgressMonitor.done();
        return false;
    }

    public boolean finalLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl;
        try {
            boolean bl2 = true;
            if (this.orderedProjects != null) {
                iProgressMonitor.beginTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors"), this.orderedProjects.size() + 1);
                boolean bl3 = false;
                IStatusHandler iStatusHandler = this.orderedProjects.iterator();
                while (iStatusHandler.hasNext()) {
                    IProject iProject = (IProject)iStatusHandler.next();
                    iProgressMonitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors_in")) + iProject.getName());
                    bl3 = this.existsErrors(iProject);
                    if (bl3) break;
                }
                if (!bl3) {
                    iProgressMonitor.subTask(String.valueOf(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.searching_for_errors_in")) + this.project.getName());
                    bl3 = this.existsErrors(this.project);
                }
                if (bl3 && (iStatusHandler = DebugPlugin.getDefault().getStatusHandler(LaunchConfigurationDelegate.promptStatus)) != null) {
                    bl2 = (Boolean)iStatusHandler.handleStatus(LaunchConfigurationDelegate.complileErrorPromptStatus, null);
                }
            }
            bl = bl2;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return bl;
    }

    private boolean existsErrors(IProject iProject) throws CoreException {
        IMarker[] iMarkerArray = iProject.findMarkers("org.eclipse.cdt.core.problem", true, 2);
        if (iMarkerArray.length > 0) {
            int n = 0;
            while (n < iMarkerArray.length) {
                if ((Integer)iMarkerArray[n].getAttribute("severity") == 2) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean preLaunchCheck(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor != null) {
            iProgressMonitor.subTask(LaunchUIPlugin.getResourceString("AbstractCLaunchConfigurationDelegate.20"));
        }
        this.orderedProjects = null;
        ICProject iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration);
        if (iCProject != null) {
            this.project = iCProject.getProject();
            HashSet hashSet = new HashSet();
            this.getReferencedProjectSet(this.project, hashSet);
            this.orderedProjects = this.getBuildOrder(new ArrayList(hashSet));
        }
        return super.preLaunchCheck(iLaunchConfiguration, string, iProgressMonitor);
    }

    private static class ArgumentParser {
        private String fArgs;
        private int fIndex = 0;
        private int ch = -1;

        public ArgumentParser(String string) {
            this.fArgs = string;
        }

        /*
         * Unable to fully structure code
         */
        public String[] parseArguments() {
            var1_1 = new ArrayList<String>();
            this.ch = this.getNext();
            ** GOTO lbl13
            {
                this.ch = this.getNext();
                do {
                    if (Character.isWhitespace((char)this.ch)) continue block0;
                    if (this.ch == 34) {
                        var1_1.add(this.parseString());
                        continue;
                    }
                    var1_1.add(this.parseToken());
lbl13:
                    // 3 sources

                } while (this.ch > 0);
            }
            var2_2 = new String[var1_1.size()];
            var1_1.toArray(var2_2);
            return var2_2;
        }

        private int getNext() {
            if (this.fIndex < this.fArgs.length()) {
                return this.fArgs.charAt(this.fIndex++);
            }
            return -1;
        }

        private String parseString() {
            StringBuffer stringBuffer = new StringBuffer();
            this.ch = this.getNext();
            while (this.ch > 0 && this.ch != 34) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch != 34) {
                        stringBuffer.append('\\');
                    }
                }
                if (this.ch <= 0) continue;
                stringBuffer.append((char)this.ch);
                this.ch = this.getNext();
            }
            this.ch = this.getNext();
            return stringBuffer.toString();
        }

        private String parseToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.ch > 0 && !Character.isWhitespace((char)this.ch)) {
                if (this.ch == 92) {
                    this.ch = this.getNext();
                    if (this.ch > 0) {
                        if (this.ch != 34) {
                            stringBuffer.append('\\');
                        }
                        stringBuffer.append((char)this.ch);
                        this.ch = this.getNext();
                        continue;
                    }
                    if (this.ch != -1) continue;
                    stringBuffer.append('\\');
                    continue;
                }
                if (this.ch == 34) {
                    stringBuffer.append(this.parseString());
                    continue;
                }
                stringBuffer.append((char)this.ch);
                this.ch = this.getNext();
            }
            return stringBuffer.toString();
        }
    }
}

