/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class CApplicationLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(IEditorPart iEditorPart, String string) {
        this.searchAndLaunch(new Object[]{iEditorPart.getEditorInput()}, string);
    }

    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            this.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string);
        }
    }

    public void launch(IBinary iBinary, String string) {
        try {
            ILaunchConfiguration iLaunchConfiguration = this.findLaunchConfiguration(iBinary, string);
            if (iLaunchConfiguration != null) {
                DebugUITools.saveAndBuildBeforeLaunch();
                iLaunchConfiguration.launch(string, null);
            }
        }
        catch (CoreException coreException) {
            LaunchUIPlugin.errorDialog(LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.LaunchFailed"), coreException.getStatus());
        }
    }

    protected ILaunchConfiguration findLaunchConfiguration(IBinary iBinary, String string) {
        String string2;
        Object object;
        Object object2;
        Object object3;
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationType iLaunchConfigurationType = this.getCLaunchConfigType();
        ArrayList<ILaunchConfiguration> arrayList = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            arrayList = new ArrayList<ILaunchConfiguration>(iLaunchConfigurationArray.length);
            int n = 0;
            while (n < iLaunchConfigurationArray.length) {
                object3 = iLaunchConfigurationArray[n];
                object2 = AbstractCLaunchDelegate.getProgramName(object3);
                object = AbstractCLaunchDelegate.getProjectName(object3);
                string2 = iBinary.getResource().getProjectRelativePath().toString();
                if (object2 != null && ((String)object2).equals(string2) && object != null && ((String)object).equals(iBinary.getCProject().getProject().getName())) {
                    arrayList.add((ILaunchConfiguration)object3);
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log((Throwable)coreException);
        }
        int n = arrayList.size();
        if (n < 1) {
            String string3 = iBinary.getCPU();
            object3 = null;
            object2 = CDebugCorePlugin.getDefault().getDebugConfigurations();
            object = new ArrayList(((ICDebugConfiguration[])object2).length);
            string2 = Platform.getOS();
            int n2 = 0;
            while (n2 < ((ICDebugConfiguration[])object2).length) {
                String string4 = object2[n2].getPlatform();
                if (object2[n2].supportsMode("run") && (string4.equals("*") || string4.equals(string2)) && object2[n2].supportsCPU(string3)) {
                    object.add(object2[n2]);
                }
                ++n2;
            }
            object2 = object.toArray(new ICDebugConfiguration[0]);
            if (((Object)object2).length == 1) {
                object3 = object2[0];
            } else if (((Object)object2).length > 1) {
                object3 = this.chooseDebugConfig((ICDebugConfiguration[])object2, string);
            }
            if (object3 != null) {
                iLaunchConfiguration = this.createConfiguration(iBinary, (ICDebugConfiguration)object3);
            }
        } else {
            iLaunchConfiguration = n == 1 ? (ILaunchConfiguration)arrayList.get(0) : this.chooseConfiguration(arrayList, string);
        }
        return iLaunchConfiguration;
    }

    private ILaunchConfiguration createConfiguration(IBinary iBinary, ICDebugConfiguration iCDebugConfiguration) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            String string = iBinary.getResource().getProjectRelativePath().toString();
            ILaunchConfigurationType iLaunchConfigurationType = this.getCLaunchConfigType();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(iBinary.getElementName()));
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", string);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", iBinary.getCProject().getElementName());
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", iCDebugConfiguration.getID());
            iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CDebugUIPlugin.log((Throwable)coreException);
        }
        return iLaunchConfiguration;
    }

    protected ILaunchConfigurationType getCLaunchConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType("org.eclipse.cdt.launch.localCLaunch");
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected Shell getShell() {
        return CDebugUIPlugin.getActiveWorkbenchShell();
    }

    private ICDebugConfiguration chooseDebugConfig(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object == null) {
                    return "";
                }
                if (object instanceof ICDebugConfiguration) {
                    return ((ICDebugConfiguration)object).getName();
                }
                return object.toString();
            }
        };
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        elementListSelectionDialog.setElements((Object[])iCDebugConfigurationArray);
        elementListSelectionDialog.setTitle(this.getDebugConfigDialogTitleString(iCDebugConfigurationArray, string));
        elementListSelectionDialog.setMessage(this.getDebugConfigDialogMessageString(iCDebugConfigurationArray, string));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        labelProvider.dispose();
        if (n == 0) {
            return (ICDebugConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected String getDebugConfigDialogTitleString(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.LaunchDebugConfigSelection");
    }

    protected String getDebugConfigDialogMessageString(ICDebugConfiguration[] iCDebugConfigurationArray, String string) {
        if (string.equals("debug")) {
            return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseConfigToDebug");
        }
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseConfigToRun");
    }

    protected ILaunchConfiguration chooseConfiguration(List list, String string) {
        IDebugModelPresentation iDebugModelPresentation = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)iDebugModelPresentation);
        elementListSelectionDialog.setElements(list.toArray());
        elementListSelectionDialog.setTitle(this.getLaunchSelectionDialogTitleString(list, string));
        elementListSelectionDialog.setMessage(this.getLaunchSelectionDialogMessageString(list, string));
        elementListSelectionDialog.setMultipleSelection(false);
        int n = elementListSelectionDialog.open();
        iDebugModelPresentation.dispose();
        if (n == 0) {
            return (ILaunchConfiguration)elementListSelectionDialog.getFirstResult();
        }
        return null;
    }

    protected String getLaunchSelectionDialogTitleString(List list, String string) {
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.LaunchConfigSelection");
    }

    protected String getLaunchSelectionDialogMessageString(List list, String string) {
        if (string.equals("debug")) {
            return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseLaunchConfigToDebug");
        }
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseLaunchConfigToRun");
    }

    protected IBinary chooseBinary(List list, String string) {
        CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(iBinary.getPath().lastSegment());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        CElementLabelProvider cElementLabelProvider2 = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.valueOf(iBinary.getCPU()) + (iBinary.isLittleEndian() ? "le" : "be"));
                    stringBuffer.append(" - ");
                    stringBuffer.append(iBinary.getPath().toString());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)cElementLabelProvider, (ILabelProvider)cElementLabelProvider2);
        twoPaneElementSelector.setElements(list.toArray());
        twoPaneElementSelector.setTitle(this.getBinarySelectionDialogTitleString(list, string));
        twoPaneElementSelector.setMessage(this.getBinarySelectionDialogMessageString(list, string));
        twoPaneElementSelector.setUpperListLabel(LaunchUIPlugin.getResourceString("Launch.common.BinariesColon"));
        twoPaneElementSelector.setLowerListLabel(LaunchUIPlugin.getResourceString("Launch.common.QualifierColon"));
        twoPaneElementSelector.setMultipleSelection(false);
        if (twoPaneElementSelector.open() == 0) {
            return (IBinary)twoPaneElementSelector.getFirstResult();
        }
        return null;
    }

    protected String getBinarySelectionDialogTitleString(List list, String string) {
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.CLocalApplication");
    }

    protected String getBinarySelectionDialogMessageString(List list, String string) {
        if (string.equals("debug")) {
            return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseLocalAppToDebug");
        }
        return LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.ChooseLocalAppToRun");
    }

    private void searchAndLaunch(final Object[] objectArray, String string) {
        if (objectArray != null && objectArray.length > 0) {
            IBinary iBinary = null;
            if (objectArray.length == 1 && objectArray[0] instanceof IBinary) {
                iBinary = (IBinary)objectArray[0];
            } else {
                final ArrayList arrayList = new ArrayList();
                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
                IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor iProgressMonitor) throws InterruptedException {
                        int n = objectArray.length;
                        iProgressMonitor.beginTask("Looking for executables", n);
                        try {
                            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                            int n2 = 0;
                            while (n2 < n) {
                                if (objectArray[n2] instanceof IAdaptable) {
                                    ICProject iCProject;
                                    IResource iResource;
                                    IAdaptable iAdaptable = (IAdaptable)objectArray[n2];
                                    Class<?> clazz = class$0;
                                    if (clazz == null) {
                                        try {
                                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                        }
                                    }
                                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null && (iCProject = CoreModel.getDefault().create(iResource.getProject())) != null) {
                                        try {
                                            IBinary[] iBinaryArray = iCProject.getBinaryContainer().getBinaries();
                                            int n3 = 0;
                                            while (n3 < iBinaryArray.length) {
                                                if (iBinaryArray[n3].isExecutable()) {
                                                    arrayList.add(iBinaryArray[n3]);
                                                }
                                                ++n3;
                                            }
                                        }
                                        catch (CModelException cModelException) {}
                                    }
                                }
                                if (iProgressMonitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                subProgressMonitor.done();
                                ++n2;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        {
                            Object var9_11 = null;
                        }
                        iProgressMonitor.done();
                    }
                };
                try {
                    progressMonitorDialog.run(true, true, iRunnableWithProgress);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)invocationTargetException.getMessage());
                    return;
                }
                int n = arrayList.size();
                if (n == 0) {
                    MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Launch_failed_no_binaries"));
                } else {
                    iBinary = n > 1 ? this.chooseBinary(arrayList, string) : (IBinary)arrayList.get(0);
                }
            }
            if (iBinary != null) {
                this.launch(iBinary, string);
            }
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Application_Launcher"), (String)LaunchUIPlugin.getResourceString("CApplicationLaunchShortcut.Launch_failed_no_project_selected"));
        }
    }
}

