/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class CoreFileLaunchDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(LaunchUIPlugin.getResourceString("CoreFileLaunchDelegate.Launching_postmortem_debugger"), -1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        IFile iFile = this.getProgramFile(iLaunchConfiguration);
        ICDebugConfiguration iCDebugConfiguration = this.getDebugConfig(iLaunchConfiguration);
        ICDISession iCDISession = null;
        ICProject iCProject = AbstractCLaunchDelegate.getCProject(iLaunchConfiguration);
        IPath iPath = this.getCoreFilePath((IProject)iCProject.getResource());
        if (iPath == null) {
            this.cancel(LaunchUIPlugin.getResourceString("CoreFileLaunchDelegate.No_Corefile_selected"), 108);
        }
        Process process = null;
        IProcess iProcess = null;
        try {
            iCDISession = iCDebugConfiguration.getDebugger().createCoreSession(iLaunchConfiguration, iFile, iPath);
            process = iCDISession.getSessionProcess();
        }
        catch (CDIException cDIException) {
            if (iCDISession != null) {
                try {
                    iCDISession.terminate();
                }
                catch (CDIException cDIException2) {}
            }
            this.abort(LaunchUIPlugin.getResourceString("CoreFileLaunchDelegate.Failed_Launching_CDI_Debugger"), cDIException, 150);
        }
        if (process != null) {
            iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)this.renderDebuggerProcessLabel());
        }
        this.setSourceLocator(iLaunch, iLaunchConfiguration);
        CDebugModel.newCoreFileDebugTarget((ILaunch)iLaunch, (ICDITarget)iCDISession.getCurrentTarget(), (String)this.renderTargetLabel(iCDebugConfiguration), (IProcess)iProcess, (IFile)iFile);
        iProgressMonitor.done();
    }

    protected IPath getCoreFilePath(final IProject iProject) throws CoreException {
        final Shell shell = LaunchUIPlugin.getShell();
        final String[] stringArray = new String[1];
        if (shell == null) {
            this.abort(LaunchUIPlugin.getResourceString("CoreFileLaunchDelegate.No_Shell_available_in_Launch"), null, 150);
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                FileDialog fileDialog = new FileDialog(shell);
                fileDialog.setText(LaunchUIPlugin.getResourceString("CoreFileLaunchDelegate.Select_Corefile"));
                String string = null;
                try {
                    string = iProject.getPersistentProperty(new QualifiedName(LaunchUIPlugin.getUniqueIdentifier(), "SavePath"));
                }
                catch (CoreException coreException) {}
                if (string == null || string.equals("")) {
                    string = iProject.getLocation().toString();
                }
                fileDialog.setFilterPath(string);
                stringArray[0] = fileDialog.open();
            }
        });
        if (stringArray[0] != null) {
            return new Path(stringArray[0]);
        }
        return null;
    }

    public String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

