/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProcessInfo;
import org.eclipse.cdt.core.IProcessList;
import org.eclipse.cdt.debug.core.CDebugModel;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIRuntimeOptions;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class LocalCLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Launching_Local_C_Application"), -1);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        IFile iFile = this.getProgramFile(iLaunchConfiguration);
        String[] stringArray = this.getProgramArgumentsArray(iLaunchConfiguration);
        ArrayList<String> arrayList = new ArrayList<String>(1 + stringArray.length);
        arrayList.add(iFile.getLocation().toOSString());
        arrayList.addAll(Arrays.asList(stringArray));
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        this.setSourceLocator(iLaunch, iLaunchConfiguration);
        if (string.equals("debug")) {
            IProcess iProcess = null;
            ICDebugConfiguration iCDebugConfiguration = this.getDebugConfig(iLaunchConfiguration);
            ICDISession iCDISession = null;
            try {
                String string2 = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "run");
                if (string2.equals("run")) {
                    iCDISession = iCDebugConfiguration.getDebugger().createLaunchSession(iLaunchConfiguration, iFile);
                    ICDIRuntimeOptions iCDIRuntimeOptions = iCDISession.getRuntimeOptions();
                    iCDIRuntimeOptions.setArguments(this.getProgramArgumentsArray(iLaunchConfiguration));
                    File file = this.getWorkingDirectory(iLaunchConfiguration);
                    if (file != null) {
                        iCDIRuntimeOptions.setWorkingDirectory(file.getAbsolutePath());
                    }
                    iCDIRuntimeOptions.setEnvironment(this.expandEnvironment(iLaunchConfiguration));
                    ICDITarget iCDITarget = iCDISession.getTargets()[0];
                    Process process = iCDITarget.getProcess();
                    IProcess iProcess2 = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)this.renderProcessLabel(stringArray2[0]));
                    Process process2 = iCDISession.getSessionProcess();
                    if (process2 != null) {
                        iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process2, (String)this.renderDebuggerProcessLabel());
                    }
                    boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
                    CDebugModel.newDebugTarget((ILaunch)iLaunch, (ICDITarget)iCDISession.getCurrentTarget(), (String)this.renderTargetLabel(iCDebugConfiguration), (IProcess)iProcess2, (IProcess)iProcess, (IFile)iFile, (boolean)true, (boolean)false, (boolean)bl);
                } else if (string2.equals("attach")) {
                    Process process;
                    int n = this.getProcessID();
                    if (n == -1) {
                        this.cancel(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.No_Process_ID_selected"), 107);
                    }
                    if ((process = (iCDISession = iCDebugConfiguration.getDebugger().createAttachSession(iLaunchConfiguration, iFile, n)).getSessionProcess()) != null) {
                        iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)this.renderDebuggerProcessLabel());
                        iLaunch.removeProcess(iProcess);
                    }
                    CDebugModel.newAttachDebugTarget((ILaunch)iLaunch, (ICDITarget)iCDISession.getCurrentTarget(), (String)this.renderTargetLabel(iCDebugConfiguration), (IProcess)iProcess, (IFile)iFile);
                }
            }
            catch (CDIException cDIException) {
                if (iCDISession != null) {
                    try {
                        iCDISession.terminate();
                    }
                    catch (CDIException cDIException2) {}
                }
                this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Failed_Launching_CDI_Debugger"), cDIException, 150);
            }
        } else {
            File file = this.getWorkingDirectory(iLaunchConfiguration);
            if (file == null) {
                file = new File(System.getProperty("user.home", "."));
            }
            Process process = this.exec(stringArray2, this.getEnvironmentProperty(iLaunchConfiguration), file);
            DebugPlugin.newProcess((ILaunch)iLaunch, (Process)process, (String)this.renderProcessLabel(stringArray2[0]));
        }
        iProgressMonitor.done();
    }

    private int getProcessID() throws CoreException {
        final Shell shell = LaunchUIPlugin.getShell();
        final int[] nArray = new int[]{-1};
        if (shell == null) {
            this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.No_Shell_available_in_Launch"), null, 150);
        }
        Display display = shell.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                IProcessInfo iProcessInfo;
                LabelProvider labelProvider = new LabelProvider(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getText(Object object) {
                        IProcessInfo iProcessInfo = (IProcessInfo)object;
                        Path path = new Path(iProcessInfo.getName());
                        return String.valueOf(path.lastSegment()) + " - " + iProcessInfo.getPid();
                    }

                    public Image getImage(Object object) {
                        return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                    }
                };
                LabelProvider labelProvider2 = new LabelProvider(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public String getText(Object object) {
                        IProcessInfo iProcessInfo = (IProcessInfo)object;
                        return iProcessInfo.getName();
                    }

                    public Image getImage(Object object) {
                        return LaunchImages.get(LaunchImages.IMG_OBJS_EXEC);
                    }
                };
                TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(shell, (ILabelProvider)labelProvider, (ILabelProvider)labelProvider2);
                twoPaneElementSelector.setTitle(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Select_Process"));
                twoPaneElementSelector.setMessage(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Select_Process_to_attach_debugger_to"));
                IProcessList iProcessList = null;
                try {
                    iProcessList = CCorePlugin.getDefault().getProcessList();
                }
                catch (CoreException coreException) {
                    LaunchUIPlugin.errorDialog(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.CDT_Launch_Error"), coreException.getStatus());
                }
                if (iProcessList == null) {
                    MessageDialog.openError((Shell)shell, (String)LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.CDT_Launch_Error"), (String)LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Platform_cannot_list_processes"));
                    return;
                }
                twoPaneElementSelector.setElements((Object[])iProcessList.getProcessList());
                if (twoPaneElementSelector.open() == 0 && (iProcessInfo = (IProcessInfo)twoPaneElementSelector.getFirstResult()) != null) {
                    nArray[0] = iProcessInfo.getPid();
                }
            }
        });
        return nArray[0];
    }

    protected Process exec(String[] stringArray, Properties properties, File file) throws CoreException {
        Process process;
        block6: {
            process = null;
            Properties properties2 = this.getDefaultEnvironment();
            properties2.putAll((Map<?, ?>)this.expandEnvironment(properties));
            String[] stringArray2 = null;
            ArrayList<String> arrayList = new ArrayList<String>();
            Enumeration<?> enumeration = properties2.propertyNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    arrayList.add(String.valueOf(string) + "=" + properties2.getProperty(string));
                }
                stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            }
            try {
                process = file == null ? ProcessFactory.getFactory().exec(stringArray, stringArray2) : ProcessFactory.getFactory().exec(stringArray, stringArray2, file);
            }
            catch (IOException iOException) {
                if (process != null) {
                    process.destroy();
                }
                this.abort(LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Error_starting_process"), iOException, 150);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Object object;
                Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 100, LaunchUIPlugin.getResourceString("LocalCLaunchConfigurationDelegate.Does_not_support_working_dir"), (Throwable)noSuchMethodError);
                IStatusHandler iStatusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                if (iStatusHandler == null || !((object = iStatusHandler.handleStatus((IStatus)status, (Object)this)) instanceof Boolean) || !((Boolean)object).booleanValue()) break block6;
                process = this.exec(stringArray, properties, null);
            }
        }
        return process;
    }

    protected String getPluginID() {
        return LaunchUIPlugin.getUniqueIdentifier();
    }
}

