/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCDebuggerTab
extends CLaunchConfigurationTab {
    protected ILaunchConfiguration fLaunchConfiguration;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ICDebugConfiguration fCurrentDebugConfig;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    private boolean fInitDefaults;

    protected void setDebugConfig(ICDebugConfiguration iCDebugConfiguration) {
        this.fCurrentDebugConfig = iCDebugConfiguration;
    }

    protected ICDebugConfiguration getDebugConfig() {
        return this.fCurrentDebugConfig;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    protected void setDynamicTab(ILaunchConfigurationTab iLaunchConfigurationTab) {
        this.fDynamicTab = iLaunchConfigurationTab;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTabHolder(Composite composite) {
        this.fDynamicTabHolder = composite;
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration iLaunchConfiguration) {
        this.fLaunchConfiguration = iLaunchConfiguration;
        this.setLaunchConfigurationWorkingCopy(null);
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.fWorkingCopy = iLaunchConfigurationWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
        if (super.getErrorMessage() != null || iLaunchConfigurationTab == null) {
            return super.getErrorMessage();
        }
        return iLaunchConfigurationTab.getErrorMessage();
    }

    protected void handleDebuggerChanged() {
        this.loadDynamicDebugArea();
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (iLaunchConfigurationWorkingCopy == null && this.getLaunchConfiguration().isWorkingCopy()) {
                iLaunchConfigurationWorkingCopy = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (iLaunchConfigurationWorkingCopy != null) {
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", null);
            }
        } else {
            if (iLaunchConfigurationWorkingCopy == null) {
                try {
                    if (this.getLaunchConfiguration().isWorkingCopy()) {
                        this.setLaunchConfigurationWorkingCopy((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration());
                    } else {
                        this.setLaunchConfigurationWorkingCopy(this.getLaunchConfiguration().getWorkingCopy());
                    }
                    iLaunchConfigurationWorkingCopy = this.getLaunchConfigurationWorkingCopy();
                }
                catch (CoreException coreException) {
                    return;
                }
            }
            if (this.initDefaults()) {
                this.getDynamicTab().setDefaults(iLaunchConfigurationWorkingCopy);
            }
            this.setInitializeDefault(false);
            this.getDynamicTab().initializeFrom((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void loadDynamicDebugArea() {
        Control[] controlArray = this.getDynamicTabHolder().getChildren();
        int n = 0;
        while (n < controlArray.length) {
            controlArray[n].dispose();
            ++n;
        }
        ICDebugConfiguration iCDebugConfiguration = this.getConfigForCurrentDebugger();
        if (iCDebugConfiguration == null) {
            this.setDynamicTab(null);
        } else {
            this.setDynamicTab(CDebugUIPlugin.getDefault().getDebuggerPage(iCDebugConfiguration.getID()));
            ICDebugConfiguration iCDebugConfiguration2 = this.getDebugConfig();
            if (iCDebugConfiguration2 != null && iCDebugConfiguration2 != iCDebugConfiguration) {
                this.setInitializeDefault(true);
            }
        }
        this.setDebugConfig(iCDebugConfiguration);
        if (this.getDynamicTab() == null) {
            return;
        }
        this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
        this.getDynamicTab().createControl(this.getDynamicTabHolder());
        this.getDynamicTab().getControl().setVisible(true);
        this.getDynamicTabHolder().layout(true);
    }

    protected abstract ICDebugConfiguration getConfigForCurrentDebugger();

    public abstract void createControl(Composite var1);

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
        if (iLaunchConfigurationTab != null) {
            iLaunchConfigurationTab.activated(iLaunchConfigurationWorkingCopy);
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.setLaunchConfiguration(iLaunchConfiguration);
        ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
        if (iLaunchConfigurationTab != null) {
            iLaunchConfigurationTab.initializeFrom(iLaunchConfiguration);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        if (this.getDebugConfig() != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", this.getDebugConfig().getID());
            ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
            if (iLaunchConfigurationTab == null) {
                iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_SPECIFIC_ATTRS_MAP", null);
            } else {
                iLaunchConfigurationTab.performApply(iLaunchConfigurationWorkingCopy);
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.setLaunchConfigurationWorkingCopy(iLaunchConfigurationWorkingCopy);
        ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
        if (iLaunchConfigurationTab != null) {
            iLaunchConfigurationTab.setDefaults(iLaunchConfigurationWorkingCopy);
            this.setInitializeDefault(false);
        }
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.getDebugConfig() == null) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("AbstractCDebuggerTab.No_debugger_available"));
            return false;
        }
        ILaunchConfigurationTab iLaunchConfigurationTab = this.getDynamicTab();
        if (iLaunchConfigurationTab != null) {
            return iLaunchConfigurationTab.isValid(iLaunchConfiguration);
        }
        return true;
    }

    protected void setInitializeDefault(boolean bl) {
        this.fInitDefaults = bl;
    }

    protected boolean initDefaults() {
        return this.fInitDefaults;
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_DEBUGGER_TAB);
    }

    public String getName() {
        return LaunchUIPlugin.getResourceString("AbstractCDebuggerTab.Debugger");
    }
}

