/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LaunchUIPlugin
extends AbstractUIPlugin
implements IDebugEventSetListener {
    public static final String PLUGIN_ID = "org.eclipse.cdt.launch";
    private static final String BUNDLE_NAME = "org.eclipse.cdt.launch.internal.ui.LaunchUIPluginResources";
    private static ResourceBundle resourceBundle = null;
    private static LaunchUIPlugin fgPlugin;
    private static Shell debugDialogShell;

    static {
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                resourceBundle = null;
            }
        }
    }

    public LaunchUIPlugin() {
        LaunchUIPlugin.setDefault(this);
    }

    private static void setDefault(LaunchUIPlugin launchUIPlugin) {
        fgPlugin = launchUIPlugin;
    }

    public static LaunchUIPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getShell() {
        if (LaunchUIPlugin.getActiveWorkbenchShell() != null) {
            return LaunchUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = LaunchUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return iWorkbenchWindowArray[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (LaunchUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LaunchUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus iStatus) {
        LaunchUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void logErrorMessage(String string) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, string, null));
    }

    public static void log(Throwable throwable) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, throwable.getMessage(), throwable));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LaunchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static void errorDialog(String string, IStatus iStatus) {
        LaunchUIPlugin.log(iStatus);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)LaunchUIPlugin.getResourceString("LaunchUIPlugin.Error"), (String)string, (IStatus)iStatus);
        }
    }

    public static void errorDialog(String string, Throwable throwable) {
        LaunchUIPlugin.log(throwable);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, throwable.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)LaunchUIPlugin.getResourceString("LaunchUIPlugin.Error"), (String)string, (IStatus)status);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.stop(bundleContext);
    }

    public void handleDebugEvents(DebugEvent[] debugEventArray) {
        int n = 0;
        while (n < debugEventArray.length) {
            Object object;
            if (debugEventArray[n].getKind() == 8 && (object = debugEventArray[n].getSource()) instanceof IProcess) {
                IProcess iProcess = (IProcess)object;
                ICProject iCProject = null;
                try {
                    iCProject = AbstractCLaunchDelegate.getCProject(iProcess.getLaunch().getLaunchConfiguration());
                }
                catch (CoreException coreException) {}
                if (iCProject != null) {
                    try {
                        iCProject.getProject().refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++n;
        }
    }

    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    public static String getResourceString(String string) {
        ResourceBundle resourceBundle = LaunchUIPlugin.getDefault().getResourceBundle();
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return "!" + string + "!";
            }
            catch (NullPointerException nullPointerException) {
                return "#" + string + "#";
            }
        }
        return "#" + string + "#";
    }

    public static String getFormattedResourceString(String string, String string2) {
        return MessageFormat.format(LaunchUIPlugin.getResourceString(string), string2);
    }

    public static String getFormattedResourceString(String string, String[] stringArray) {
        return MessageFormat.format(LaunchUIPlugin.getResourceString(string), stringArray);
    }
}

