/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class CEnvironmentTab
extends CLaunchConfigurationTab {
    protected Properties fElements;
    protected TableViewer fVariableList;
    protected Button fBtnNew;
    protected Button fBtnEdit;
    protected Button fBtnRemove;
    protected Button fBtnImport;

    public void createControl(Composite composite) {
        this.fElements = new Properties();
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_environment_tab");
        GridLayout gridLayout = new GridLayout(2, false);
        this.createVerticalSpacer(composite2, 2);
        composite2.setLayout((Layout)gridLayout);
        this.createVariableList(composite2);
        this.createButtons(composite2);
        this.fVariableList.setInput((Object)this.fElements);
        this.fVariableList.getTable().setFocus();
    }

    public void set(String string) {
        this.fElements.clear();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        try {
            this.fElements.load(byteArrayInputStream);
        }
        catch (IOException iOException) {}
        this.fVariableList.refresh();
        this.fVariableList.getTable().setFocus();
        if (this.fVariableList.getTable().getItemCount() > 0) {
            this.fVariableList.getTable().setSelection(0);
        }
    }

    public String get() {
        String string = new String();
        Object[] objectArray = this.fElements.entrySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            string = String.valueOf(string) + objectArray[n].toString() + '\n';
            ++n;
        }
        return string;
    }

    public Properties getProperties() {
        return this.fElements;
    }

    public Object[] toArray() {
        return this.fElements.entrySet().toArray();
    }

    private void createVariableList(Composite composite) {
        this.fVariableList = new TableViewer(composite, 2818);
        this.fVariableList.setContentProvider((IContentProvider)new ElementsContentProvider());
        this.fVariableList.setLabelProvider((IBaseLabelProvider)new ElementsLabelProvider());
        this.fVariableList.setSorter((ViewerSorter)new SimpleSorter());
        Table table = this.fVariableList.getTable();
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        GridData gridData = new GridData(272);
        gridData.grabExcessVerticalSpace = true;
        gridData.grabExcessHorizontalSpace = true;
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Name"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Value"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30));
        this.fVariableList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                CEnvironmentTab.this.elementDoubleClicked((IStructuredSelection)doubleClickEvent.getSelection());
            }
        });
        this.fVariableList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                CEnvironmentTab.this.updateButtons();
            }
        });
    }

    private void createButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(2));
        composite2.setLayout((Layout)new GridLayout(1, true));
        this.fBtnNew = new Button(composite2, 0);
        this.fBtnNew.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.New..."));
        this.fBtnNew.setLayoutData((Object)new GridData(1808));
        this.fBtnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CEnvironmentTab.this.newEntry();
            }
        });
        this.fBtnImport = new Button(composite2, 0);
        this.fBtnImport.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Import..."));
        this.fBtnImport.setLayoutData((Object)new GridData(1808));
        this.fBtnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CEnvironmentTab.this.importEntries();
            }
        });
        this.fBtnEdit = new Button(composite2, 0);
        this.fBtnEdit.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Edit..."));
        this.fBtnEdit.setLayoutData((Object)new GridData(1808));
        this.fBtnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CEnvironmentTab.this.edit();
            }
        });
        this.fBtnRemove = new Button(composite2, 0);
        this.fBtnRemove.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.Remove"));
        this.fBtnRemove.setLayoutData((Object)new GridData(1808));
        this.fBtnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CEnvironmentTab.this.remove();
            }
        });
    }

    protected void updateButtons() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fVariableList.getSelection();
        this.fBtnEdit.setEnabled(iStructuredSelection.size() == 1);
        this.fBtnRemove.setEnabled(iStructuredSelection.size() > 0);
    }

    protected void elementDoubleClicked(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.size() != 1) {
            return;
        }
        this.doEdit((Map.Entry)iStructuredSelection.getFirstElement());
    }

    protected void newEntry() {
        EntryDialog entryDialog = new EntryDialog(new String(), new String(), false);
        if (entryDialog.open() == 0) {
            this.fElements.setProperty(entryDialog.getName(), entryDialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void importEntries() {
        FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
        String string = fileDialog.open();
        if (string == null) {
            return;
        }
        this.parseImportFile(string);
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void parseImportFile(String string) {
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                boolean bl;
                String string3;
                String string4;
                if ((string2 = string2.trim()).length() == 0) continue;
                int n = string2.indexOf("=");
                if (n == -1) {
                    string4 = string2;
                    string3 = "";
                } else {
                    string4 = string2.substring(0, n);
                    string3 = string2.substring(n + 1, string2.length());
                }
                if (this.fElements.getProperty(string4) != null && !(bl = MessageDialog.openQuestion((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CEnvironmentTab.Existing_Environment_Variable"), (String)LaunchUIPlugin.getFormattedResourceString("CEnvironmentTab.Environment_variable_NAME_exists", string4)))) continue;
                this.fElements.setProperty(string4, string3);
            }
        }
        catch (Exception exception) {}
        this.fVariableList.refresh();
    }

    protected void edit() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fVariableList.getSelection();
        this.doEdit((Map.Entry)iStructuredSelection.getFirstElement());
    }

    protected void doEdit(Map.Entry entry) {
        EntryDialog entryDialog = new EntryDialog(entry.getKey().toString(), entry.getValue().toString(), true);
        if (entryDialog.open() == 0) {
            this.fElements.remove(entry.getKey());
            this.fElements.setProperty(entryDialog.getName(), entryDialog.getValue());
            this.fVariableList.refresh();
        }
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    protected void remove() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fVariableList.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            this.fElements.remove(((Map.Entry)objectArray[n]).getKey());
            ++n;
        }
        this.fVariableList.refresh();
        this.updateButtons();
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        try {
            Map map = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
            if (map != null) {
                this.fElements.clear();
                this.fElements.putAll((Map<?, ?>)map);
                this.fVariableList.refresh();
                this.updateButtons();
            }
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", (Map)this.fElements.clone());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
    }

    public String getName() {
        return LaunchUIPlugin.getResourceString("CEnvironmentTab.Environment");
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_ENVIRONMENT_TAB);
    }

    class SimpleSorter
    extends ViewerSorter {
        SimpleSorter() {
        }

        public boolean isSorterProperty(Object object, Object object2) {
            return true;
        }
    }

    class ElementsContentProvider
    implements IStructuredContentProvider {
        Object input = null;

        ElementsContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return CEnvironmentTab.this.fElements.entrySet().toArray();
        }
    }

    class ElementsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ElementsLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object != null && object instanceof Map.Entry) {
                return n == 0 ? ((Map.Entry)object).getKey().toString() : ((Map.Entry)object).getValue().toString();
            }
            return null;
        }
    }

    class EntryDialog
    extends Dialog {
        private String fName;
        private String fValue;
        private boolean fEdit = false;
        private Button fBtnOk = null;
        private Text fTextName = null;
        private Text fTextValue = null;

        public EntryDialog(String string, String string2, boolean bl) {
            super(CEnvironmentTab.this.getControl().getShell());
            this.fName = string;
            this.fValue = string2;
            this.fEdit = bl;
        }

        protected Control createContents(Composite composite) {
            Control control = super.createContents(composite);
            this.updateButtonsState();
            return control;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            String string = this.fEdit ? LaunchUIPlugin.getResourceString("CEnvironmentTab.Edit_Variable") : LaunchUIPlugin.getResourceString("CEnvironmentTab.New_Variable");
            shell.setText(string);
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 5;
            gridLayout.numColumns = 2;
            composite2.setLayout((Layout)gridLayout);
            GC gC = new GC((Drawable)composite2);
            gC.setFont(composite2.getFont());
            FontMetrics fontMetrics = gC.getFontMetrics();
            gC.dispose();
            int n = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)50);
            Label label = new Label(composite2, 0);
            label.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.NameColon"));
            this.fTextName = new Text(composite2, 2052);
            GridData gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = n;
            this.fTextName.setLayoutData((Object)gridData);
            label = new Label(composite2, 0);
            label.setText(LaunchUIPlugin.getResourceString("CEnvironmentTab.ValueColon"));
            this.fTextValue = new Text(composite2, 2052);
            gridData = new GridData(1808);
            gridData.grabExcessHorizontalSpace = true;
            gridData.widthHint = n;
            this.fTextValue.setLayoutData((Object)gridData);
            this.fTextName.addModifyListener(new ModifyListener(this){
                final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = entryDialog;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextValue.addModifyListener(new ModifyListener(this){
                final /* synthetic */ EntryDialog this$1;
                {
                    this.this$1 = entryDialog;
                }

                public void modifyText(ModifyEvent modifyEvent) {
                    this.this$1.updateButtonsState();
                }
            });
            this.fTextName.setText(this.fName);
            this.fTextValue.setText(this.fValue);
            return composite2;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            this.fBtnOk = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        }

        protected void updateButtonsState() {
            if (this.fBtnOk != null) {
                this.fBtnOk.setEnabled(this.fTextName.getText().trim().length() > 0);
            }
        }

        protected String getName() {
            return this.fName;
        }

        protected String getValue() {
            return this.fValue;
        }

        protected void okPressed() {
            this.fName = this.fTextName.getText().trim();
            this.fValue = this.fTextValue.getText().trim();
            this.setReturnCode(0);
            this.close();
        }
    }
}

