/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.CElementImageProvider;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.launch.internal.ui.LaunchImages;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.launch.ui.CLaunchConfigurationTab;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CMainTab
extends CLaunchConfigurationTab {
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Label fProgLabel;
    protected Text fProgText;
    protected Button fSearchButton;
    protected static final String EMPTY_STRING = "";
    private String filterPlatform = "";

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_main_tab");
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.createVerticalSpacer(composite2, 1);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(768);
        composite3.setLayoutData((Object)gridData);
        this.fProjLabel = new Label(composite3, 0);
        this.fProjLabel.setText(LaunchUIPlugin.getResourceString("CMainTab.&ProjectColon"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gridData);
        this.fProjText = new Text(composite3, 2052);
        gridData = new GridData(768);
        this.fProjText.setLayoutData((Object)gridData);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(composite3, LaunchUIPlugin.getResourceString("Launch.common.Browse_1"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CMainTab.this.handleProjectButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createVerticalSpacer(composite2, 1);
        Composite composite4 = new Composite(composite2, 0);
        GridLayout gridLayout3 = new GridLayout();
        gridLayout3.numColumns = 3;
        gridLayout3.marginHeight = 0;
        gridLayout3.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout3);
        gridData = new GridData(768);
        composite4.setLayoutData((Object)gridData);
        this.fProgLabel = new Label(composite4, 0);
        this.fProgLabel.setText(LaunchUIPlugin.getResourceString("CMainTab.C/C++_Application"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.fProgLabel.setLayoutData((Object)gridData);
        this.fProgText = new Text(composite4, 2052);
        gridData = new GridData(768);
        this.fProgText.setLayoutData((Object)gridData);
        this.fProgText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(composite4, LaunchUIPlugin.getResourceString("CMainTab.Search..."), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CMainTab.this.handleSearchButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button button = this.createPushButton(composite4, LaunchUIPlugin.getResourceString("Launch.common.Browse_2"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CMainTab.this.handleBinaryBrowseButtonSelected();
                CMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        LaunchUIPlugin.setDialogShell(composite.getShell());
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.filterPlatform = this.getPlatform(iLaunchConfiguration);
        this.updateProjectFromConfig(iLaunchConfiguration);
        this.updateProgramFromConfig(iLaunchConfiguration);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        }
        catch (CoreException coreException) {
            LaunchUIPlugin.log(coreException);
        }
        this.fProjText.setText(string);
    }

    protected void updateProgramFromConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string = EMPTY_STRING;
        try {
            string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", EMPTY_STRING);
        }
        catch (CoreException coreException) {
            LaunchUIPlugin.log(coreException);
        }
        this.fProgText.setText(string);
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.fProjText.getText());
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.fProgText.getText());
    }

    protected void handleSearchButtonSelected() {
        if (this.getCProject() == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CMainTab.Project_required"), (String)LaunchUIPlugin.getResourceString("CMainTab.Enter_project_before_searching_for_program"));
            return;
        }
        CElementLabelProvider cElementLabelProvider = new CElementLabelProvider(){
            CElementImageProvider imageProvider = new CElementImageProvider();

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(iBinary.getPath().lastSegment());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                IBinary iBinary;
                if (!(object instanceof ICElement)) {
                    return super.getImage(object);
                }
                ICElement iCElement = (ICElement)object;
                if (iCElement.getElementType() == 14 && (iBinary = (IBinary)iCElement).isExecutable()) {
                    Image image = super.getImage(object);
                    Point point = new Point(image.getBounds().width, image.getBounds().height);
                    return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)new CElementImageDescriptor(CPluginImages.DESC_OBJS_CEXEC, 0, point));
                }
                return super.getImage(object);
            }
        };
        CElementLabelProvider cElementLabelProvider2 = new CElementLabelProvider(){

            public String getText(Object object) {
                if (object instanceof IBinary) {
                    IBinary iBinary = (IBinary)object;
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(String.valueOf(iBinary.getCPU()) + (iBinary.isLittleEndian() ? "le" : "be"));
                    stringBuffer.append(" - ");
                    stringBuffer.append(iBinary.getPath().toString());
                    return stringBuffer.toString();
                }
                return super.getText(object);
            }
        };
        TwoPaneElementSelector twoPaneElementSelector = new TwoPaneElementSelector(this.getShell(), (ILabelProvider)cElementLabelProvider, (ILabelProvider)cElementLabelProvider2);
        twoPaneElementSelector.setElements((Object[])this.getBinaryFiles(this.getCProject()));
        twoPaneElementSelector.setMessage(LaunchUIPlugin.getResourceString("CMainTab.Choose_program_to_run"));
        twoPaneElementSelector.setTitle(LaunchUIPlugin.getResourceString("CMainTab.Program_Selection"));
        twoPaneElementSelector.setUpperListLabel(LaunchUIPlugin.getResourceString("Launch.common.BinariesColon"));
        twoPaneElementSelector.setLowerListLabel(LaunchUIPlugin.getResourceString("Launch.common.QualifierColon"));
        twoPaneElementSelector.setMultipleSelection(false);
        if (twoPaneElementSelector.open() == 0) {
            IBinary iBinary = (IBinary)twoPaneElementSelector.getFirstResult();
            this.fProgText.setText(iBinary.getResource().getProjectRelativePath().toString());
        }
    }

    protected void handleBinaryBrowseButtonSelected() {
        final ICProject iCProject = this.getCProject();
        if (iCProject == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)LaunchUIPlugin.getResourceString("CMainTab.Project_required"), (String)LaunchUIPlugin.getResourceString("CMainTab.Enter_project_before_browsing_for_program"));
            return;
        }
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider workbenchContentProvider = new WorkbenchContentProvider();
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)workbenchLabelProvider, (ITreeContentProvider)workbenchContentProvider);
        elementTreeSelectionDialog.setTitle(LaunchUIPlugin.getResourceString("CMainTab.Program_selection"));
        elementTreeSelectionDialog.setMessage(LaunchUIPlugin.getFormattedResourceString("CMainTab.Choose_program_to_run_from_NAME", iCProject.getResource().getName()));
        elementTreeSelectionDialog.setBlockOnOpen(true);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setInput((Object)iCProject.getResource());
        elementTreeSelectionDialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] objectArray) {
                if (objectArray.length == 0 || !(objectArray[0] instanceof IFile)) {
                    return new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, LaunchUIPlugin.getResourceString("CMainTab.Selection_must_be_file"), null);
                }
                try {
                    ICElement iCElement = iCProject.findElement(((IFile)objectArray[0]).getProjectRelativePath());
                    if (iCElement == null || iCElement.getElementType() != 14 && iCElement.getElementType() != 18) {
                        return new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, LaunchUIPlugin.getResourceString("CMainTab.Selection_must_be_binary_file"), null);
                    }
                    return new Status(0, LaunchUIPlugin.getUniqueIdentifier(), 0, iCElement.getResource().getName(), null);
                }
                catch (Exception exception) {
                    return new Status(4, "org.eclipse.cdt.launch", 1, LaunchUIPlugin.getResourceString("CMainTab.Selection_must_be_binary_file"), null);
                }
            }
        });
        if (elementTreeSelectionDialog.open() == 1) {
            return;
        }
        Object[] objectArray = elementTreeSelectionDialog.getResult();
        try {
            this.fProgText.setText(((IResource)objectArray[0]).getProjectRelativePath().toString());
        }
        catch (Exception exception) {}
    }

    protected IBinary[] getBinaryFiles(final ICProject iCProject) {
        if (iCProject == null || !iCProject.exists()) {
            return null;
        }
        Display display = this.getShell() == null ? LaunchUIPlugin.getShell().getDisplay() : this.getShell().getDisplay();
        final Object[] objectArray = new Object[1];
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                try {
                    objectArray[0] = iCProject.getBinaryContainer().getBinaries();
                }
                catch (CModelException cModelException) {
                    LaunchUIPlugin.errorDialog("Launch UI internal error", cModelException);
                }
            }
        });
        return (IBinary[])objectArray[0];
    }

    protected void handleProjectButtonSelected() {
        ICProject iCProject = this.chooseCProject();
        if (iCProject == null) {
            return;
        }
        String string = iCProject.getElementName();
        this.fProjText.setText(string);
    }

    protected ICProject chooseCProject() {
        try {
            Object[] objectArray = this.getCProjects();
            CElementLabelProvider cElementLabelProvider = new CElementLabelProvider();
            ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)cElementLabelProvider);
            elementListSelectionDialog.setTitle(LaunchUIPlugin.getResourceString("CMainTab.Project_Selection"));
            elementListSelectionDialog.setMessage(LaunchUIPlugin.getResourceString("CMainTab.Choose_project_to_constrain_search_for_program"));
            elementListSelectionDialog.setElements(objectArray);
            ICProject iCProject = this.getCProject();
            if (iCProject != null) {
                elementListSelectionDialog.setInitialSelections(new Object[]{iCProject});
            }
            if (elementListSelectionDialog.open() == 0) {
                return (ICProject)elementListSelectionDialog.getFirstResult();
            }
        }
        catch (CModelException cModelException) {
            LaunchUIPlugin.errorDialog("Launch UI internal error", cModelException);
        }
        return null;
    }

    protected ICProject[] getCProjects() throws CModelException {
        ICProject[] iCProjectArray = CoreModel.getDefault().getCModel().getCProjects();
        ArrayList<ICProject> arrayList = new ArrayList<ICProject>(iCProjectArray.length);
        int n = 0;
        while (n < iCProjectArray.length) {
            ICDescriptor iCDescriptor = null;
            try {
                iCDescriptor = CCorePlugin.getDefault().getCProjectDescription((IProject)iCProjectArray[n].getResource(), false);
                if (iCDescriptor != null) {
                    String string = iCDescriptor.getPlatform();
                    if (this.filterPlatform.equals("*") || string.equals("*") || this.filterPlatform.equalsIgnoreCase(string)) {
                        arrayList.add(iCProjectArray[n]);
                    }
                } else {
                    arrayList.add(iCProjectArray[n]);
                }
            }
            catch (CoreException coreException) {
                arrayList.add(iCProjectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new ICProject[arrayList.size()]);
    }

    protected ICProject getCProject() {
        String string = this.fProjText.getText().trim();
        if (string.length() < 1) {
            return null;
        }
        return CoreModel.getDefault().getCModel().getCProject(string);
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String string = this.fProjText.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CMainTab.Project_not_specified"));
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().getRoot().getProject(string).exists()) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("Launch.common.Project_does_not_exist"));
            return false;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        string = this.fProgText.getText().trim();
        if (string.length() == 0) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CMainTab.Program_not_specified"));
            return false;
        }
        if (string.equals(".") || string.equals("..")) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CMainTab.Program_does_not_exist"));
            return false;
        }
        if (!iProject.isOpen()) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CMainTab.Project_must_be_opened"));
            return false;
        }
        if (!iProject.getFile(string).exists()) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CMainTab.Program_does_not_exist"));
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", EMPTY_STRING);
        ICElement iCElement = null;
        iCElement = this.getContext((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, this.getPlatform((ILaunchConfiguration)iLaunchConfigurationWorkingCopy));
        if (iCElement != null) {
            this.initializeCProject(iCElement, iLaunchConfigurationWorkingCopy);
            this.initializeProgramName(iCElement, iLaunchConfigurationWorkingCopy);
        }
    }

    protected void initializeProgramName(ICElement iCElement, ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        Object object;
        IBinary iBinary = null;
        if (iCElement instanceof ICProject && (object = this.getBinaryFiles((ICProject)iCElement)) != null && ((IBinary[])object).length == 1) {
            iBinary = object[0];
        }
        if (iBinary != null) {
            object = iBinary.getResource().getProjectRelativePath().toOSString();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", (String)object);
            String string = iBinary.getElementName();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            string = this.getLaunchConfigurationDialog().generateName(string);
            iLaunchConfigurationWorkingCopy.rename(string);
        } else {
            object = this.getLaunchConfigurationDialog().generateName(iCElement.getCProject().getElementName());
            iLaunchConfigurationWorkingCopy.rename((String)object);
        }
    }

    public String getName() {
        return LaunchUIPlugin.getResourceString("CMainTab.Main");
    }

    public Image getImage() {
        return LaunchImages.get(LaunchImages.IMG_VIEW_MAIN_TAB);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }
}

