/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.ui;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.ICDebugConfiguration;
import org.eclipse.cdt.launch.internal.ui.AbstractCDebuggerTab;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class CorefileDebuggerTab
extends AbstractCDebuggerTab {
    protected Combo fDCombo;
    private boolean initializingComboBox = false;

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        this.setControl((Control)composite2);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.launch.launch_configuration_dialog_debugger_tab");
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText(LaunchUIPlugin.getResourceString("Launch.common.DebuggerColon"));
        this.fDCombo = new Combo(composite2, 12);
        this.fDCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                CorefileDebuggerTab.this.handleDebuggerChanged();
            }
        });
        Group group = new Group(composite2, 16);
        group.setText(LaunchUIPlugin.getResourceString("CorefileDebuggerTab.Debugger_Options"));
        this.setDynamicTabHolder((Composite)group);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        gridLayout2.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)gridLayout2);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.getDynamicTabHolder().setLayoutData((Object)gridData);
    }

    protected void loadDebuggerComboBox(ILaunchConfiguration iLaunchConfiguration, String string) {
        if (this.initializingComboBox) {
            return;
        }
        this.initializingComboBox = true;
        String string2 = this.getPlatform(iLaunchConfiguration);
        ICElement iCElement = this.getContext(iLaunchConfiguration, null);
        String string3 = "*";
        String string4 = "*";
        if (iCElement != null) {
            try {
                ICDescriptor iCDescriptor = CCorePlugin.getDefault().getCProjectDescription(iCElement.getCProject().getProject(), false);
                if (iCDescriptor != null) {
                    string3 = iCDescriptor.getPlatform();
                }
                IBinary iBinary = (IBinary)iCElement;
                string4 = iBinary.getCPU();
            }
            catch (Exception exception) {}
        }
        this.fDCombo.removeAll();
        ICDebugConfiguration[] iCDebugConfigurationArray = CDebugCorePlugin.getDefault().getDebugConfigurations();
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < iCDebugConfigurationArray.length) {
            if (iCDebugConfigurationArray[n3].supportsMode("core")) {
                String string5 = iCDebugConfigurationArray[n3].getPlatform();
                boolean bl = string2.equals(string3);
                if ((string5.equalsIgnoreCase(string3) || bl && string3.equals("*")) && iCDebugConfigurationArray[n3].supportsCPU(string4)) {
                    this.fDCombo.add(iCDebugConfigurationArray[n3].getName());
                    this.fDCombo.setData(Integer.toString(n), (Object)iCDebugConfigurationArray[n3]);
                    if (n2 == -1 && string5.equalsIgnoreCase(string3) || string.equals(iCDebugConfigurationArray[n3].getID())) {
                        n2 = n;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        this.setInitializeDefault(string.equals(""));
        this.fDCombo.select(n2 == -1 ? 0 : n2);
        this.handleDebuggerChanged();
        this.getControl().getParent().layout(true);
        this.initializingComboBox = false;
    }

    public void activated(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.activated(iLaunchConfigurationWorkingCopy);
        try {
            String string = iLaunchConfigurationWorkingCopy.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            if (this.getDebugConfig() == null || !this.getDebugConfig().getID().equals(string) || !this.validateDebuggerConfig((ILaunchConfiguration)iLaunchConfigurationWorkingCopy)) {
                this.loadDebuggerComboBox((ILaunchConfiguration)iLaunchConfigurationWorkingCopy, string);
            }
        }
        catch (CoreException coreException) {}
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        super.initializeFrom(iLaunchConfiguration);
        try {
            String string = iLaunchConfiguration.getAttribute("org.eclipse.cdt.launch.DEBUGGER_ID", "");
            this.loadDebuggerComboBox(iLaunchConfiguration, string);
        }
        catch (CoreException coreException) {
            return;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        super.setDefaults(iLaunchConfigurationWorkingCopy);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "core");
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        if (!this.validateDebuggerConfig(iLaunchConfiguration)) {
            this.setErrorMessage(LaunchUIPlugin.getResourceString("CorefileDebuggerTab.No_debugger_available"));
            return false;
        }
        return super.isValid(iLaunchConfiguration);
    }

    private boolean validateDebuggerConfig(ILaunchConfiguration iLaunchConfiguration) {
        String string;
        ICDebugConfiguration iCDebugConfiguration;
        String string2 = this.getPlatform(iLaunchConfiguration);
        ICElement iCElement = this.getContext(iLaunchConfiguration, null);
        String string3 = "*";
        String string4 = "*";
        if (iCElement != null) {
            try {
                iCDebugConfiguration = CCorePlugin.getDefault().getCProjectDescription(iCElement.getCProject().getProject(), false);
                if (iCDebugConfiguration != null) {
                    string3 = iCDebugConfiguration.getPlatform();
                }
                string = (IBinary)iCElement;
                string4 = string.getCPU();
            }
            catch (Exception exception) {}
        }
        if ((iCDebugConfiguration = this.getDebugConfig()) == null) {
            return false;
        }
        string = iCDebugConfiguration.getPlatform();
        boolean bl = string2.equals(string3);
        return (string.equalsIgnoreCase(string3) || bl && string3.equals("*")) && iCDebugConfiguration.supportsCPU(string4);
    }

    protected ICDebugConfiguration getConfigForCurrentDebugger() {
        int n = this.fDCombo.getSelectionIndex();
        return (ICDebugConfiguration)this.fDCombo.getData(Integer.toString(n));
    }

    protected void handleDebuggerChanged() {
        super.handleDebuggerChanged();
    }
}

