/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewerImpl;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableViewer
extends StructuredViewer {
    private TableViewerImpl tableViewerImpl;
    private Table table;
    private TableEditor tableEditor;

    public TableViewer(Composite parent) {
        this(parent, 2818);
    }

    public TableViewer(Composite parent, int style) {
        this(new Table(parent, style));
    }

    public TableViewer(Table table) {
        this.table = table;
        this.hookControl((Control)table);
        this.tableEditor = new TableEditor(table);
        this.initTableViewerImpl();
    }

    public void add(Object[] elements) {
        this.assertElementsNotNull(elements);
        Object[] filtered = this.filter(elements);
        int i = 0;
        while (i < filtered.length) {
            Object element = filtered[i];
            int index = this.indexForElement(element);
            this.updateItem((Widget)new TableItem(this.getTable(), 0, index), element);
            ++i;
        }
    }

    public void add(Object element) {
        this.add(new Object[]{element});
    }

    public void cancelEditing() {
        this.tableViewerImpl.cancelEditing();
    }

    protected Widget doFindInputItem(Object element) {
        if (this.equals(element, this.getRoot())) {
            return this.getTable();
        }
        return null;
    }

    protected Widget doFindItem(Object element) {
        TableItem[] children = this.table.getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            Object data = item.getData();
            if (data != null && this.equals(data, element)) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof TableItem) {
            TableItem item = (TableItem)widget;
            if (fullMap) {
                this.associate(element, (Item)item);
            } else {
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            IBaseLabelProvider prov = this.getLabelProvider();
            ITableLabelProvider tprov = null;
            ILabelProvider lprov = null;
            if (prov instanceof ITableLabelProvider) {
                tprov = (ITableLabelProvider)prov;
            } else {
                lprov = (ILabelProvider)prov;
            }
            int columnCount = this.table.getColumnCount();
            TableItem ti = item;
            int column = 0;
            while (column < columnCount || column == 0) {
                String text = "";
                Image image = null;
                if (tprov != null) {
                    text = tprov.getColumnText(element, column);
                    image = tprov.getColumnImage(element, column);
                } else if (column == 0) {
                    if (lprov instanceof IViewerLabelProvider) {
                        IViewerLabelProvider itemProvider = (IViewerLabelProvider)((Object)lprov);
                        ViewerLabel updateLabel = new ViewerLabel(item.getText(), item.getImage());
                        itemProvider.updateLabel(updateLabel, element);
                        text = updateLabel.getText();
                        image = updateLabel.getImage();
                    } else {
                        text = lprov.getText(element);
                        image = lprov.getImage(element);
                    }
                }
                ti.setText(column, text);
                if (ti.getImage(column) != image) {
                    ti.setImage(column, image);
                }
                ++column;
            }
            if (prov instanceof IColorProvider) {
                IColorProvider cprov = (IColorProvider)((Object)prov);
                ti.setForeground(cprov.getForeground(element));
                ti.setBackground(cprov.getBackground(element));
            }
            if (prov instanceof IFontProvider) {
                IFontProvider fprov = (IFontProvider)((Object)prov);
                ti.setFont(fprov.getFont(element));
            }
        }
    }

    public void editElement(Object element, int column) {
        this.tableViewerImpl.editElement(element, column);
    }

    public CellEditor[] getCellEditors() {
        return this.tableViewerImpl.getCellEditors();
    }

    public ICellModifier getCellModifier() {
        return this.tableViewerImpl.getCellModifier();
    }

    public Object[] getColumnProperties() {
        return this.tableViewerImpl.getColumnProperties();
    }

    public Control getControl() {
        return this.table;
    }

    public Object getElementAt(int index) {
        TableItem i;
        if (index >= 0 && index < this.table.getItemCount() && (i = this.table.getItem(index)) != null) {
            return i.getData();
        }
        return null;
    }

    public IBaseLabelProvider getLabelProvider() {
        return super.getLabelProvider();
    }

    protected List getSelectionFromWidget() {
        TableItem[] items = this.table.getSelection();
        ArrayList<Object> list = new ArrayList<Object>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object e = item.getData();
            if (e != null) {
                list.add(e);
            }
            ++i;
        }
        return list;
    }

    public Table getTable() {
        return this.table;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        Table tableControl = (Table)control;
        tableControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TableViewer.this.tableViewerImpl.handleMouseDown(e);
            }
        });
    }

    protected int indexForElement(Object element) {
        ViewerSorter sorter = this.getSorter();
        if (sorter == null) {
            return this.table.getItemCount();
        }
        int count = this.table.getItemCount();
        int min = 0;
        int max = count - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            Object data = this.table.getItem(mid).getData();
            int compare = sorter.compare(this, data, element);
            if (compare == 0) {
                while (compare == 0) {
                    if (++mid >= count) break;
                    data = this.table.getItem(mid).getData();
                    compare = sorter.compare(this, data, element);
                }
                return mid;
            }
            if (compare < 0) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return min;
    }

    private void initTableViewerImpl() {
        this.tableViewerImpl = new TableViewerImpl(this){

            Rectangle getBounds(Item item, int columnNumber) {
                return ((TableItem)item).getBounds(columnNumber);
            }

            int getColumnCount() {
                return TableViewer.this.getTable().getColumnCount();
            }

            Item[] getSelection() {
                return TableViewer.this.getTable().getSelection();
            }

            void setEditor(Control w, Item item, int columnNumber) {
                TableViewer.this.tableEditor.setEditor(w, (TableItem)item, columnNumber);
            }

            void setSelection(StructuredSelection selection, boolean b) {
                TableViewer.this.setSelection(selection, b);
            }

            void showSelection() {
                TableViewer.this.getTable().showSelection();
            }

            void setLayoutData(CellEditor.LayoutData layoutData) {
                ((TableViewer)TableViewer.this).tableEditor.grabHorizontal = layoutData.grabHorizontal;
                ((TableViewer)TableViewer.this).tableEditor.horizontalAlignment = layoutData.horizontalAlignment;
                ((TableViewer)TableViewer.this).tableEditor.minimumWidth = layoutData.minimumWidth;
            }

            void handleDoubleClickEvent() {
                StructuredViewer viewer = this.getViewer();
                TableViewer.this.fireDoubleClick(new DoubleClickEvent(viewer, ((Viewer)viewer).getSelection()));
                TableViewer.this.fireOpen(new OpenEvent(viewer, ((Viewer)viewer).getSelection()));
            }
        };
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void inputChanged(Object input, Object oldInput) {
        this.getControl().setRedraw(false);
        try {
            this.refresh();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.getControl().setRedraw(true);
    }

    public void insert(Object element, int position) {
        this.tableViewerImpl.applyEditorValue();
        if (this.getSorter() != null || this.hasFilters()) {
            this.add(element);
            return;
        }
        if (position == -1) {
            position = this.table.getItemCount();
        }
        this.updateItem((Widget)new TableItem(this.table, 0, position), element);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        this.tableViewerImpl.applyEditorValue();
        if (element == null || this.equals(element, this.getRoot())) {
            Object[] children = this.getSortedChildren(this.getRoot());
            TableItem[] items = this.table.getItems();
            int min = Math.min(children.length, items.length);
            int i = 0;
            while (i < min) {
                if (this.equals(children[i], items[i].getData())) {
                    if (updateLabels) {
                        this.updateItem((Widget)items[i], children[i]);
                    } else {
                        this.associate(children[i], (Item)items[i]);
                    }
                } else {
                    items[i].setText("");
                    items[i].setImage(new Image[0]);
                    this.disassociate((Item)items[i]);
                }
                ++i;
            }
            if (min < items.length) {
                i = items.length;
                while (--i >= min) {
                    this.disassociate((Item)items[i]);
                }
                this.table.remove(min, items.length - 1);
            }
            if (this.table.getItemCount() == 0) {
                this.table.removeAll();
            }
            i = 0;
            while (i < min) {
                if (items[i].getData() == null) {
                    this.updateItem((Widget)items[i], children[i]);
                }
                ++i;
            }
            i = min;
            while (i < children.length) {
                this.updateItem((Widget)new TableItem(this.table, 0, i), children[i]);
                ++i;
            }
        } else {
            Widget w = this.findItem(element);
            if (w != null) {
                this.updateItem(w, element);
            }
        }
    }

    private void internalRemove(Object[] elements) {
        Object input = this.getInput();
        int i = 0;
        while (i < elements.length) {
            if (this.equals(elements[i], input)) {
                this.setInput(null);
                return;
            }
            ++i;
        }
        int[] indices = new int[elements.length];
        int count = 0;
        int i2 = 0;
        while (i2 < elements.length) {
            Widget w = this.findItem(elements[i2]);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                this.disassociate((Item)item);
                indices[count++] = this.table.indexOf(item);
            }
            ++i2;
        }
        if (count < indices.length) {
            int[] nArray = indices;
            indices = new int[count];
            System.arraycopy(nArray, 0, indices, 0, count);
        }
        this.table.remove(indices);
        if (this.table.getItemCount() == 0) {
            this.table.removeAll();
        }
    }

    public boolean isCellEditorActive() {
        return this.tableViewerImpl.isCellEditorActive();
    }

    public void remove(final Object[] elements) {
        this.assertElementsNotNull(elements);
        this.preservingSelection(new Runnable(){

            public void run() {
                TableViewer.this.internalRemove(elements);
            }
        });
    }

    public void remove(Object element) {
        this.remove(new Object[]{element});
    }

    public void reveal(Object element) {
        Assert.isNotNull(element);
        Widget w = this.findItem(element);
        if (w instanceof TableItem) {
            this.getTable().showItem((TableItem)w);
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.tableViewerImpl.setCellEditors(editors);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.tableViewerImpl.setCellModifier(modifier);
    }

    public void setColumnProperties(String[] columnProperties) {
        this.tableViewerImpl.setColumnProperties(columnProperties);
    }

    public void setLabelProvider(IBaseLabelProvider labelProvider) {
        Assert.isTrue(labelProvider instanceof ITableLabelProvider || labelProvider instanceof ILabelProvider);
        super.setLabelProvider(labelProvider);
    }

    protected void setSelectionToWidget(List list, boolean reveal) {
        if (list == null) {
            this.table.deselectAll();
            return;
        }
        int size = list.size();
        TableItem[] items = new TableItem[size];
        TableItem firstItem = null;
        int count = 0;
        int i = 0;
        while (i < size) {
            Object o = list.get(i);
            Widget w = this.findItem(o);
            if (w instanceof TableItem) {
                TableItem item = (TableItem)w;
                items[count++] = item;
                if (firstItem == null) {
                    firstItem = item;
                }
            }
            ++i;
        }
        if (count < size) {
            TableItem[] tableItemArray = items;
            items = new TableItem[count];
            System.arraycopy(tableItemArray, 0, items, 0, count);
        }
        this.table.setSelection(items);
        if (reveal && firstItem != null) {
            this.table.showItem(firstItem);
        }
    }
}

