/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.ResourceVariantCache;

public final class TeamPlugin
extends Plugin {
    public static final String ID = "org.eclipse.team.core";
    public static final String PROVIDER_EXTENSION = "repository-provider-type";
    public static final String FILE_TYPES_EXTENSION = "fileTypes";
    public static final String IGNORE_EXTENSION = "ignore";
    public static final String PROJECT_SET_EXTENSION = "projectSets";
    public static final String REPOSITORY_EXTENSION = "repository";
    private static TeamPlugin plugin;

    public TeamPlugin(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        plugin = this;
    }

    public void startup() throws CoreException {
        Policy.localize("org.eclipse.team.internal.core.messages");
        Team.startup();
    }

    public void shutdown() {
        Team.shutdown();
        ResourceVariantCache.shutdown();
    }

    public static TeamPlugin getPlugin() {
        return plugin;
    }

    public static void log(int severity, String message, Throwable e) {
        plugin.getLog().log((IStatus)new Status(severity, ID, 0, message, e));
    }

    public static void log(CoreException e) {
        TeamPlugin.log(e.getStatus().getSeverity(), e.getMessage(), e);
    }

    public static TeamException wrapException(Exception e) {
        return new TeamException((IStatus)new Status(4, ID, 0, e.getMessage() != null ? e.getMessage() : "", (Throwable)e));
    }

    public static TeamException wrapException(CoreException e) {
        IStatus status = e.getStatus();
        return new TeamException((IStatus)new Status(status.getSeverity(), ID, status.getCode(), status.getMessage(), (Throwable)e));
    }

    public static String getCharset(String name, InputStream stream) throws IOException {
        IContentDescription description = TeamPlugin.getContentDescription(name, stream);
        return description == null ? null : description.getCharset();
    }

    public static IContentDescription getContentDescription(String name, InputStream stream) throws IOException {
        IContentDescription iContentDescription;
        block5: {
            IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
            try {
                iContentDescription = contentTypeManager.getDescriptionFor(stream, name, IContentDescription.ALL);
                Object var3_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (stream == null) break block6;
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return iContentDescription;
    }

    public static RepositoryProviderType getAliasType(String id) {
        IExtensionPoint extension;
        TeamPlugin plugin = TeamPlugin.getPlugin();
        if (plugin != null && (extension = plugin.getDescriptor().getExtensionPoint(REPOSITORY_EXTENSION)) != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String extensionId;
                    String aliasId = configElements[j].getAttribute("canImportId");
                    if (aliasId != null && aliasId.equals(id) && (extensionId = configElements[j].getAttribute("id")) != null) {
                        return RepositoryProviderType.getProviderType(extensionId);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }
}

