/*
 * Decompiled with CFR 0.152.
 */
package com.palmsource.eclipse.reseditor.win32;

import com.palmsource.eclipse.palmoscore.CorePlugin;
import com.palmsource.eclipse.reseditor.win32.ResEditorPlugin;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PartInitException;

public class ResourceEditorLauncher
implements IEditorLauncher {
    public void open(IPath iPath) {
        String string = iPath.toOSString();
        String string2 = this.getPalmOSResourceEditorPath();
        try {
            Runtime.getRuntime().exec(new String[]{string2, string});
        }
        catch (Exception exception) {
            String string3 = this.format("ResourceEditorLauncher.errorMessage", new Object[]{string2});
            CoreException coreException = new CoreException((IStatus)new Status(4, ResEditorPlugin.getDefault().getBundle().getSymbolicName(), 0, string3, (Throwable)exception));
            String string4 = this.format("ResourceEditorLauncher.errorOpeningExternalEditor", new Object[]{string});
            PartInitException partInitException = new PartInitException(string4, (Throwable)coreException);
            this.openError(null, this.getString("ResourceEditorLauncher.openFileShellTitle"), partInitException.getMessage(), (CoreException)partInitException);
        }
    }

    private String getPalmOSResourceEditorPath() {
        Path path = new Path("");
        String string = CorePlugin.findProperty((String)"com.palmsource.eclipse.reseditor.win32", (String)"PATH");
        if (string != null) {
            path = new Path(string);
        }
        if (!(path = path.append(ResEditorPlugin.getResourceString("ResourceEditor.command"))).toFile().exists()) {
            ResEditorPlugin.getResourceString("ResourceEditor.old_command");
            path = path.removeLastSegments(1);
            path = path.append("ResourceEditor.old_command");
        }
        return path.toString();
    }

    private void openError(Shell shell, String string, String string2, CoreException coreException) {
        CoreException coreException2 = null;
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null && iStatus.getException() instanceof CoreException) {
            coreException2 = (CoreException)iStatus.getException();
        }
        if (coreException2 != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)coreException2.getStatus());
        } else {
            MessageDialog.openError((Shell)shell, (String)string, (String)string2);
        }
    }

    private String format(String string, Object[] objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    private String getString(String string) {
        return ResEditorPlugin.getResourceString(string);
    }
}

