/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.CConventions;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.ui.util.Resources;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static RefactoringStatus checkFieldName(String string) {
        return Checks.checkName(string, CConventions.validateFieldName((String)string));
    }

    public static RefactoringStatus checkIdentifier(String string) {
        return Checks.checkName(string, CConventions.validateIdentifier((String)string));
    }

    public static RefactoringStatus checkMethodName(String string) {
        RefactoringStatus refactoringStatus = Checks.checkName(string, CConventions.validateMethodName((String)string));
        if (refactoringStatus.isOK() && Checks.startsWithUpperCase(string)) {
            return RefactoringStatus.createWarningStatus(RefactoringCoreMessages.getString("Checks.method_names_lowercase"));
        }
        return refactoringStatus;
    }

    public static RefactoringStatus checkClassName(String string) {
        if (string.indexOf(".") != -1) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.no_dot"));
        }
        RefactoringStatus refactoringStatus = Checks.checkName(string, CConventions.validateClassName((String)string));
        if (refactoringStatus.hasFatalError()) {
            String string2 = RefactoringCoreMessages.getFormattedString("Checks.error.InvalidClassName", refactoringStatus.getFirstMessage(4));
            return RefactoringStatus.createFatalErrorStatus(string2);
        }
        if (refactoringStatus.hasError()) {
            String string3 = RefactoringCoreMessages.getFormattedString("Checks.error.InvalidClassName", refactoringStatus.getFirstMessage(3));
            return RefactoringStatus.createErrorStatus(string3);
        }
        if (refactoringStatus.hasWarning()) {
            String string4 = RefactoringCoreMessages.getFormattedString("Checks.warning.ClassNameDiscouraged", refactoringStatus.getFirstMessage(1));
            return RefactoringStatus.createWarningStatus(string4);
        }
        return refactoringStatus;
    }

    private static boolean startsWithUpperCase(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.charAt(0) == Character.toUpperCase(string.charAt(0));
    }

    public static boolean startsWithLowerCase(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.charAt(0) == Character.toLowerCase(string.charAt(0));
    }

    public static boolean resourceExists(IPath iPath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(iPath) != null;
    }

    public static boolean isAlreadyNamed(ICElement iCElement, String string) {
        return string.equals(iCElement.getElementName());
    }

    private static RefactoringStatus checkName(String string, IStatus iStatus) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if ("".equals(string)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.Choose_name"));
        }
        if (iStatus.isOK()) {
            return refactoringStatus;
        }
        switch (iStatus.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus(iStatus.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus(iStatus.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus(iStatus.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkIfTuBroken(ICElement iCElement) throws CModelException {
        ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iCElement.getUnderlyingResource());
        if (iTranslationUnit == null) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_created"));
        }
        if (!iTranslationUnit.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("Checks.cu_not_parsed"));
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] iFileArray) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IStatus iStatus = Resources.checkInSync((IResource[])iFileArray);
        if (!iStatus.isOK()) {
            refactoringStatus.merge(RefactoringStatus.create(iStatus));
        }
        if (!(iStatus = Resources.makeCommittable((IResource[])iFileArray, null)).isOK()) {
            refactoringStatus.merge(RefactoringStatus.create(iStatus));
        }
        return refactoringStatus;
    }

    public static boolean isAvailable(ICElement iCElement) throws CModelException {
        if (iCElement == null) {
            return false;
        }
        if (!iCElement.exists()) {
            return false;
        }
        return !iCElement.isReadOnly();
    }

    public static SearchResultGroup[] excludeTranslationUnits(SearchResultGroup[] searchResultGroupArray, RefactoringStatus refactoringStatus) throws CModelException {
        ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>();
        boolean bl = searchResultGroupArray.length == 0;
        int n = 0;
        while (n < searchResultGroupArray.length) {
            IResource iResource = searchResultGroupArray[n].getResource();
            ICElement iCElement = CoreModel.getDefault().create(iResource);
            if (iCElement instanceof ITranslationUnit) {
                ITranslationUnit iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iResource);
                if (!iTranslationUnit.isStructureKnown()) {
                    String string = iTranslationUnit.getResource().getFullPath().toOSString();
                    refactoringStatus.addError(RefactoringCoreMessages.getFormattedString("Checks.cannot_be_parsed", string));
                } else {
                    arrayList.add(searchResultGroupArray[n]);
                }
            }
            ++n;
        }
        if (!bl && arrayList.isEmpty()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.getString("Checks.all_excluded"));
        } else if (arrayList.isEmpty()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.getString("Checks.no_files"));
        }
        return arrayList.toArray(new SearchResultGroup[arrayList.size()]);
    }

    public static RefactoringStatus checkCompileErrorsInAffectedFiles(SearchResultGroup[] searchResultGroupArray) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            IResource iResource = searchResultGroupArray[n].getResource();
            if (Checks.hasCompileErrors(iResource)) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.getFormattedString("Checks.cu_has_compile_errors", iResource.getFullPath().makeRelative()));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private static boolean hasCompileErrors(IResource iResource) throws CModelException {
        try {
            IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.cdt.core.problem", true, 2);
            int n = 0;
            while (n < iMarkerArray.length) {
                if (iMarkerArray[n].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        catch (CModelException cModelException) {
            throw cModelException;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }
}

