/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.NullChange;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.base.Change;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class CompositeChange
extends Change
implements ICompositeChange {
    private List fChanges;
    private IChange fUndoChange;
    private String fName;

    public CompositeChange() {
        this(RefactoringCoreMessages.getString("CompositeChange.CompositeChange"));
    }

    public CompositeChange(String string, IChange[] iChangeArray) {
        this(string, new ArrayList(iChangeArray.length));
        this.addAll(iChangeArray);
    }

    public CompositeChange(String string) {
        this(string, new ArrayList(5));
    }

    public CompositeChange(String string, int n) {
        this(string, new ArrayList(n));
    }

    private CompositeChange(String string, List list) {
        this.fChanges = list;
        this.fName = string;
    }

    public final RefactoringStatus aboutToPerform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        iProgressMonitor.beginTask("", this.fChanges.size() + 1);
        refactoringStatus.merge(super.aboutToPerform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            refactoringStatus.merge(((IChange)iterator.next()).aboutToPerform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        }
        return refactoringStatus;
    }

    public final void performed() {
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            ((IChange)iterator.next()).performed();
        }
    }

    public final IChange getUndoChange() {
        return this.fUndoChange;
    }

    public void addAll(IChange[] iChangeArray) {
        int n = 0;
        while (n < iChangeArray.length) {
            this.add(iChangeArray[n]);
            ++n;
        }
    }

    public void add(IChange iChange) {
        if (iChange != null) {
            this.fChanges.add(iChange);
        }
    }

    public IChange[] getChildren() {
        if (this.fChanges == null) {
            return null;
        }
        return this.fChanges.toArray(new IChange[this.fChanges.size()]);
    }

    final List getChanges() {
        return this.fChanges;
    }

    private List createUndoList(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException {
        ArrayList<IChange> arrayList = null;
        try {
            arrayList = new ArrayList<IChange>(this.fChanges.size());
            iProgressMonitor.beginTask("", this.fChanges.size());
            Iterator iterator = this.fChanges.iterator();
            while (iterator.hasNext()) {
                try {
                    IChange iChange = (IChange)iterator.next();
                    iChange.perform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    arrayList.add(iChange.getUndoChange());
                    changeContext.addPerformedChange(iChange);
                }
                catch (Exception exception) {
                    this.handleException(changeContext, exception);
                }
            }
            iProgressMonitor.done();
            Collections.reverse(arrayList);
            return arrayList;
        }
        catch (Exception exception) {
            this.handleException(changeContext, exception);
            if (arrayList == null) {
                arrayList = new ArrayList(0);
            }
            return arrayList;
        }
    }

    public final void perform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException {
        iProgressMonitor.beginTask("", 1);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.getString("CompositeChange.performingChangesTask.name"));
        this.fUndoChange = !this.isActive() ? new NullChange() : new CompositeChange(this.fName, this.createUndoList(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        iProgressMonitor.done();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CompositeChange\n");
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("<").append(iterator.next().toString()).append("/>\n");
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.fName;
    }

    public Object getModifiedLanguageElement() {
        return null;
    }

    public void setActive(boolean bl) {
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            ((IChange)iterator.next()).setActive(bl);
        }
    }

    public boolean isUndoable() {
        Iterator iterator = this.fChanges.iterator();
        while (iterator.hasNext()) {
            IChange iChange = (IChange)iterator.next();
            if (iChange.isUndoable()) continue;
            return false;
        }
        return true;
    }
}

