/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.BasicSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;

public class RefactoringSearchEngine {
    private RefactoringSearchEngine() {
    }

    public static ITranslationUnit[] findAffectedTranslationUnits(IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern) throws CModelException {
        HashSet hashSet = new HashSet(5);
        BasicSearchResultCollector basicSearchResultCollector = new BasicSearchResultCollector();
        try {
            new SearchEngine().search(ResourcesPlugin.getWorkspace(), iCSearchPattern, iCSearchScope, (ICSearchResultCollector)basicSearchResultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
        ArrayList<ITranslationUnit> arrayList = new ArrayList<ITranslationUnit>(hashSet.size());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            ICElement iCElement = CoreModel.getDefault().create(iResource);
            if (!(iCElement instanceof ITranslationUnit)) continue;
            ITranslationUnit iTranslationUnit = (ITranslationUnit)iCElement;
            arrayList.add(CModelUtil.toWorkingCopy(iTranslationUnit));
        }
        return arrayList.toArray(new ITranslationUnit[arrayList.size()]);
    }

    public static SearchResultGroup[] search(IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern) throws CModelException {
        return RefactoringSearchEngine.search(iCSearchScope, iCSearchPattern, new BasicSearchResultCollector(iProgressMonitor));
    }

    public static SearchResultGroup[] search(ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern, BasicSearchResultCollector basicSearchResultCollector) throws CModelException {
        return RefactoringSearchEngine.search(iCSearchScope, iCSearchPattern, basicSearchResultCollector, null);
    }

    public static SearchResultGroup[] search(IProgressMonitor iProgressMonitor, ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern, ITranslationUnit[] iTranslationUnitArray) throws CModelException {
        return RefactoringSearchEngine.search(iCSearchScope, iCSearchPattern, new BasicSearchResultCollector(iProgressMonitor), iTranslationUnitArray);
    }

    public static SearchResultGroup[] search(ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern, BasicSearchResultCollector basicSearchResultCollector, ITranslationUnit[] iTranslationUnitArray) throws CModelException {
        RefactoringSearchEngine.internalSearch(iCSearchScope, iCSearchPattern, (ICSearchResultCollector)basicSearchResultCollector, iTranslationUnitArray);
        Set set = basicSearchResultCollector.getSearchResults();
        ArrayList arrayList = new ArrayList(set);
        return RefactoringSearchEngine.groupByResource(RefactoringSearchEngine.createSearchResultArray(arrayList));
    }

    public static SearchResultGroup[] groupByResource(BasicSearchMatch[] basicSearchMatchArray) {
        Map map = RefactoringSearchEngine.groupByResource(Arrays.asList(basicSearchMatchArray));
        SearchResultGroup[] searchResultGroupArray = new SearchResultGroup[map.keySet().size()];
        int n = 0;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            List list = (List)map.get(iResource);
            searchResultGroupArray[n] = new SearchResultGroup(iResource, RefactoringSearchEngine.createSearchResultArray(list));
            ++n;
        }
        return searchResultGroupArray;
    }

    private static BasicSearchMatch[] createSearchResultArray(List list) {
        return list.toArray(new BasicSearchMatch[list.size()]);
    }

    private static Map groupByResource(List list) {
        HashMap hashMap = new HashMap();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BasicSearchMatch basicSearchMatch = (BasicSearchMatch)iterator.next();
            if (!hashMap.containsKey(basicSearchMatch.getResource())) {
                hashMap.put(basicSearchMatch.getResource(), new ArrayList(1));
            }
            ((List)hashMap.get(basicSearchMatch.getResource())).add(basicSearchMatch);
        }
        return hashMap;
    }

    private static void internalSearch(ICSearchScope iCSearchScope, ICSearchPattern iCSearchPattern, ICSearchResultCollector iCSearchResultCollector, ITranslationUnit[] iTranslationUnitArray) throws CModelException {
        if (iCSearchPattern == null) {
            return;
        }
        Assert.isNotNull(iCSearchScope, "scope");
        try {
            RefactoringSearchEngine.createSearchEngine(iTranslationUnitArray).search(ResourcesPlugin.getWorkspace(), iCSearchPattern, iCSearchScope, iCSearchResultCollector, false);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static SearchEngine createSearchEngine(ITranslationUnit[] iTranslationUnitArray) {
        return new SearchEngine();
    }
}

