/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.IProcessorBasedRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.IRefactoringProcessor;
import org.eclipse.cdt.internal.corext.refactoring.IRenameProcessor;
import org.eclipse.cdt.internal.corext.refactoring.IRenameRefactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.rename.RenameElementProcessor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class RenameRefactoring
extends Refactoring
implements IProcessorBasedRefactoring,
IRenameRefactoring {
    private Object fElement;
    private IRenameProcessor fProcessor;

    public RenameRefactoring(Object object) throws CoreException {
        Assert.isNotNull(object);
        this.fElement = object;
        this.fProcessor = new RenameElementProcessor();
        this.fProcessor.initialize(new Object[]{this.fElement});
    }

    public boolean isAvailable() {
        return this.fProcessor != null;
    }

    public Object getAdapter(Class clazz) {
        if (clazz.isInstance(this.fProcessor)) {
            return this.fProcessor;
        }
        return super.getAdapter(clazz);
    }

    public IRefactoringProcessor getProcessor() {
        return this.fProcessor;
    }

    public int getStyle() {
        return this.fProcessor.getStyle();
    }

    public String getNewName() {
        return this.fProcessor.getNewElementName();
    }

    public void setNewName(String string) {
        this.fProcessor.setNewElementName(string);
    }

    public String getCurrentName() {
        return this.fProcessor.getCurrentElementName();
    }

    public RefactoringStatus checkNewName(String string) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            refactoringStatus.merge(this.fProcessor.checkNewElementName(string));
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        return refactoringStatus;
    }

    public String getName() {
        return this.fProcessor.getProcessorName();
    }

    public RefactoringStatus checkActivation(IProgressMonitor iProgressMonitor) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            refactoringStatus.merge(this.fProcessor.checkActivation());
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        return refactoringStatus;
    }

    public RefactoringStatus checkInput(IProgressMonitor iProgressMonitor) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            iProgressMonitor.beginTask("", 2);
            refactoringStatus.merge(this.fProcessor.checkInput((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
        }
        catch (CModelException cModelException) {
            throw cModelException;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        return refactoringStatus;
    }

    public IChange createChange(IProgressMonitor iProgressMonitor) throws CModelException {
        iProgressMonitor.beginTask("", 1);
        CompositeChange compositeChange = new CompositeChange();
        try {
            compositeChange.add(this.fProcessor.createChange((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        }
        catch (CModelException cModelException) {
            throw cModelException;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
        return compositeChange;
    }

    public String toString() {
        if (this.isAvailable()) {
            return this.getName();
        }
        return "No refactoring available to process: " + this.fElement;
    }
}

