/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ITranslationUnit[] iTranslationUnitArray) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iTranslationUnitArray.length);
        int n = 0;
        while (n < iTranslationUnitArray.length) {
            IResource iResource = ResourceUtil.getResource(iTranslationUnitArray[n]);
            if (iResource.getType() == 1) {
                arrayList.add(iResource);
            }
            ++n;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    public static IFile getFile(ITranslationUnit iTranslationUnit) {
        IResource iResource = ResourceUtil.getResource(iTranslationUnit);
        if (iResource.getType() == 1) {
            return (IFile)iResource;
        }
        return null;
    }

    public static IResource getResource(ITranslationUnit iTranslationUnit) {
        return iTranslationUnit.getResource();
    }

    public static IResource getResource(IMember iMember) {
        return ResourceUtil.getResource(iMember.getTranslationUnit());
    }

    public static IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof ICElement) {
            return ResourceUtil.getResource((ICElement)object);
        }
        return null;
    }

    private static IResource getResource(ICElement iCElement) {
        if (iCElement.getElementType() == 60) {
            return ResourceUtil.getResource((ITranslationUnit)iCElement);
        }
        if (iCElement instanceof IOpenable) {
            return iCElement.getResource();
        }
        return null;
    }
}

