/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.core.resources.IResource;

public class SearchResultGroup {
    private final IResource fResouce;
    private final List fSearchResults;

    public SearchResultGroup(IResource iResource, BasicSearchMatch[] basicSearchMatchArray) {
        Assert.isNotNull(basicSearchMatchArray);
        this.fResouce = iResource;
        this.fSearchResults = new ArrayList<BasicSearchMatch>(Arrays.asList(basicSearchMatchArray));
    }

    public void add(BasicSearchMatch basicSearchMatch) {
        Assert.isNotNull(basicSearchMatch);
        this.fSearchResults.add(basicSearchMatch);
    }

    public IResource getResource() {
        return this.fResouce;
    }

    public BasicSearchMatch[] getSearchResults() {
        return this.fSearchResults.toArray(new BasicSearchMatch[this.fSearchResults.size()]);
    }

    public static IResource[] getResources(SearchResultGroup[] searchResultGroupArray) {
        HashSet<IResource> hashSet = new HashSet<IResource>(searchResultGroupArray.length);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            hashSet.add(searchResultGroupArray[n].getResource());
            ++n;
        }
        return hashSet.toArray(new IResource[hashSet.size()]);
    }

    public IResource getResultGroupResource() {
        if (this.getSearchResults() == null || this.getSearchResults().length == 0) {
            return null;
        }
        return this.getSearchResults()[0].getResource();
    }
}

