/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TranslationUnitChange;
import org.eclipse.core.runtime.CoreException;

public class TextChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextChangeManager() {
        this(false);
    }

    public TextChangeManager(boolean bl) {
        this.fKeepExecutedTextEdits = bl;
    }

    public void manage(ITranslationUnit iTranslationUnit, TextChange textChange) {
        this.fMap.put(iTranslationUnit, textChange);
    }

    public TextChange get(ITranslationUnit iTranslationUnit) throws CoreException {
        TextChange textChange = (TextChange)this.fMap.get(iTranslationUnit);
        if (textChange == null) {
            textChange = new TranslationUnitChange(iTranslationUnit.getElementName(), iTranslationUnit);
            textChange.setKeepExecutedTextEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(iTranslationUnit, textChange);
        }
        return textChange;
    }

    public TextChange remove(ITranslationUnit iTranslationUnit) {
        return (TextChange)this.fMap.remove(iTranslationUnit);
    }

    public TextChange[] getAllChanges() {
        return this.fMap.values().toArray(new TextChange[this.fMap.values().size()]);
    }

    public ITranslationUnit[] getAllTranslationUnits() {
        return this.fMap.keySet().toArray(new ITranslationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ITranslationUnit iTranslationUnit) {
        return this.fMap.containsKey(iTranslationUnit);
    }
}

