/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.Stack;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.ListenerList;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManagerListener;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class UndoManager
implements IUndoManager {
    private Stack fUndoChanges;
    private Stack fRedoChanges;
    private Stack fUndoNames;
    private Stack fRedoNames;
    private ListenerList fListeners;
    private FlushListener fFlushListener;
    private SaveListener fSaveListener;

    public UndoManager() {
        this.flush();
    }

    public void addListener(IUndoManagerListener iUndoManagerListener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList();
        }
        this.fListeners.add(iUndoManagerListener);
    }

    public void removeListener(IUndoManagerListener iUndoManagerListener) {
        if (this.fListeners == null) {
            return;
        }
        this.fListeners.remove(iUndoManagerListener);
    }

    public void aboutToPerformRefactoring() {
        if (this.fFlushListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
    }

    public void refactoringPerformed(boolean bl) {
        if (bl) {
            if (this.fFlushListener != null) {
                CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fFlushListener);
            }
            if (this.fSaveListener != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
            }
        } else {
            this.flush();
        }
    }

    public void shutdown() {
        if (this.fFlushListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
    }

    public void flush() {
        this.flushUndo();
        this.flushRedo();
        if (this.fFlushListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        this.fFlushListener = null;
        this.fSaveListener = null;
    }

    private void flushUndo() {
        this.fUndoChanges = new Stack();
        this.fUndoNames = new Stack();
        this.fireUndoStackChanged();
    }

    private void flushRedo() {
        this.fRedoChanges = new Stack();
        this.fRedoNames = new Stack();
        this.fireRedoStackChanged();
    }

    public void addUndo(String string, IChange iChange) {
        Assert.isNotNull(string, "refactoring");
        Assert.isNotNull(iChange, "change");
        this.fUndoNames.push(string);
        this.fUndoChanges.push(iChange);
        this.flushRedo();
        if (this.fFlushListener == null) {
            this.fFlushListener = new FlushListener();
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener == null) {
            this.fSaveListener = new SaveListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        this.fireUndoStackChanged();
    }

    public RefactoringStatus performUndo(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fUndoChanges.empty()) {
            return refactoringStatus;
        }
        IChange iChange = (IChange)this.fUndoChanges.peek();
        this.executeChange(refactoringStatus, changeContext, iChange, iProgressMonitor);
        if (!refactoringStatus.hasError()) {
            this.fUndoChanges.pop();
            this.fRedoNames.push(this.fUndoNames.pop());
            this.fRedoChanges.push(iChange.getUndoChange());
            this.fireUndoStackChanged();
            this.fireRedoStackChanged();
        }
        return refactoringStatus;
    }

    public RefactoringStatus performRedo(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fRedoChanges.empty()) {
            return refactoringStatus;
        }
        IChange iChange = (IChange)this.fRedoChanges.peek();
        this.executeChange(refactoringStatus, changeContext, iChange, iProgressMonitor);
        if (!refactoringStatus.hasError()) {
            this.fRedoChanges.pop();
            this.fUndoNames.push(this.fRedoNames.pop());
            this.fUndoChanges.push(iChange.getUndoChange());
            this.fireRedoStackChanged();
            this.fireUndoStackChanged();
        }
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeChange(RefactoringStatus refactoringStatus, final ChangeContext changeContext, final IChange iChange, IProgressMonitor iProgressMonitor) throws CModelException {
        block16: {
            block14: {
                block15: {
                    if (this.fFlushListener != null) {
                        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fFlushListener);
                    }
                    if (this.fSaveListener != null) {
                        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fSaveListener);
                    }
                    try {
                        try {
                            iProgressMonitor.beginTask("", 10);
                            refactoringStatus.merge(iChange.aboutToPerform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2)));
                            if (refactoringStatus.hasError()) {
                                Object var6_5 = null;
                                iChange.performed();
                                if (this.fFlushListener == null) break block14;
                                break block15;
                            }
                            CoreModel.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                                    iChange.perform(changeContext, iProgressMonitor);
                                }
                            }, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 8));
                            break block16;
                        }
                        catch (CModelException cModelException) {
                            throw cModelException;
                        }
                        catch (CoreException coreException) {
                            throw new CModelException(coreException);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        iChange.performed();
                        if (this.fFlushListener != null) {
                            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fFlushListener);
                        }
                        if (this.fSaveListener != null) {
                            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
                        }
                        iProgressMonitor.done();
                        throw throwable;
                    }
                }
                CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fFlushListener);
            }
            if (this.fSaveListener != null) {
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
            }
            iProgressMonitor.done();
            return;
        }
        Object var6_7 = null;
        iChange.performed();
        if (this.fFlushListener != null) {
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fFlushListener);
        }
        if (this.fSaveListener != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fSaveListener);
        }
        iProgressMonitor.done();
    }

    public boolean anythingToRedo() {
        return !this.fRedoChanges.empty();
    }

    public boolean anythingToUndo() {
        return !this.fUndoChanges.empty();
    }

    public String peekUndoName() {
        if (this.fUndoNames.size() > 0) {
            return (String)this.fUndoNames.peek();
        }
        return null;
    }

    public String peekRedoName() {
        if (this.fRedoNames.size() > 0) {
            return (String)this.fRedoNames.peek();
        }
        return null;
    }

    private void fireUndoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IUndoManagerListener)objectArray[n]).undoStackChanged(this);
            ++n;
        }
    }

    private void fireRedoStackChanged() {
        if (this.fListeners == null) {
            return;
        }
        Object[] objectArray = this.fListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            ((IUndoManagerListener)objectArray[n]).redoStackChanged(this);
            ++n;
        }
    }

    private class FlushListener
    implements IElementChangedListener {
        FlushListener() {
        }

        public void elementChanged(ElementChangedEvent elementChangedEvent) {
            if (UndoManager.this.fUndoChanges.isEmpty() && UndoManager.this.fRedoChanges.isEmpty()) {
                return;
            }
            this.processDelta(elementChangedEvent.getDelta());
        }

        private boolean processDelta(ICElementDelta iCElementDelta) {
            int n = iCElementDelta.getKind();
            int n2 = iCElementDelta.getFlags();
            int n3 = iCElementDelta.getElement().getElementType();
            ICElementDelta[] iCElementDeltaArray = iCElementDelta.getAffectedChildren();
            if (iCElementDeltaArray == null) {
                return true;
            }
            switch (n3) {
                case 10: 
                case 11: 
                case 12: {
                    if (n == 4 || (n2 & 8) != 0) break;
                    UndoManager.this.flush();
                    return false;
                }
                case 60: {
                    ITranslationUnit iTranslationUnit = (ITranslationUnit)iCElementDelta.getElement();
                    if (iTranslationUnit.isWorkingCopy()) {
                        return true;
                    }
                    UndoManager.this.flush();
                    return false;
                }
            }
            int n4 = 0;
            while (n4 < iCElementDeltaArray.length) {
                if (!this.processDelta(iCElementDeltaArray[n4])) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
    }

    private class SaveListener
    implements IResourceChangeListener {
        SaveListener() {
        }

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDeltaVisitor iResourceDeltaVisitor = new IResourceDeltaVisitor(this){
                final /* synthetic */ SaveListener this$1;
                {
                    this.this$1 = saveListener;
                }

                public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                    ITranslationUnit iTranslationUnit;
                    IResource iResource = iResourceDelta.getResource();
                    if (iResource.getType() == 1 && iResourceDelta.getKind() == 4 && (iResourceDelta.getFlags() & 0x100) != 0 && CoreModel.isValidTranslationUnitName((IProject)iResource.getProject(), (String)iResource.getName()) && (iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create((IFile)iResource)) != null && iTranslationUnit.exists()) {
                        SaveListener.access$0(this.this$1).flush();
                        return false;
                    }
                    return true;
                }
            };
            try {
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta != null) {
                    iResourceDelta.accept(iResourceDeltaVisitor);
                }
            }
            catch (CoreException coreException) {
                CUIPlugin.getDefault().log(coreException.getStatus());
            }
        }

        static /* synthetic */ UndoManager access$0(SaveListener saveListener) {
            return saveListener.UndoManager.this;
        }
    }
}

