/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.base;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public abstract class Change
implements IChange {
    private boolean fIsActive = true;
    static /* synthetic */ Class class$0;

    public RefactoringStatus aboutToPerform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", 1);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IResource iResource = Change.getResource(this.getModifiedLanguageElement());
        if (iResource != null) {
            iProgressMonitor.subTask(RefactoringCoreMessages.getFormattedString("Change.checking_for", iResource.getName()));
            Change.checkIfModifiable(iResource, refactoringStatus, changeContext);
        }
        iProgressMonitor.worked(1);
        return refactoringStatus;
    }

    public void performed() {
    }

    public void setActive(boolean bl) {
        this.fIsActive = bl;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public boolean isUndoable() {
        return true;
    }

    public String toString() {
        return this.getName();
    }

    protected void handleException(ChangeContext changeContext, Exception exception) throws ChangeAbortException {
        if (exception instanceof ChangeAbortException) {
            throw (ChangeAbortException)exception;
        }
        if (exception instanceof OperationCanceledException) {
            throw (OperationCanceledException)exception;
        }
        changeContext.getExceptionHandler().handle(changeContext, this, exception);
    }

    protected static void checkIfModifiable(Object object, RefactoringStatus refactoringStatus, ChangeContext changeContext) {
        IResource iResource = Change.getResource(object);
        if (iResource != null) {
            Change.checkIfModifiable(iResource, refactoringStatus, changeContext);
        }
    }

    protected static void checkIfModifiable(IResource iResource, RefactoringStatus refactoringStatus, ChangeContext changeContext) {
        if (iResource.isReadOnly()) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_read_only", iResource.getFullPath().toString()));
        }
        if (iResource instanceof IFile) {
            changeContext.checkUnsavedFile(refactoringStatus, (IFile)iResource);
        }
    }

    private static IResource getResource(Object object) {
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof ITranslationUnit) {
            return CModelUtil.toOriginal((ITranslationUnit)object).getResource();
        }
        if (object instanceof ICElement) {
            return ((ICElement)object).getUnderlyingResource();
        }
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (IResource)iAdaptable.getAdapter((Class)clazz);
        }
        return null;
    }
}

