/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.IChangeExceptionHandler;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.core.resources.IFile;

public class ChangeContext {
    private IFile[] fUnsavedFiles;
    private List fHandledUnsavedFiles;
    private IChangeExceptionHandler fExceptionHandler;
    private IChange fFailedChange;
    private boolean fTryToUndo;
    private List fPerformedChanges = new ArrayList();

    public ChangeContext(IChangeExceptionHandler iChangeExceptionHandler) {
        this(iChangeExceptionHandler, new IFile[0]);
    }

    public ChangeContext(IChangeExceptionHandler iChangeExceptionHandler, IFile[] iFileArray) {
        this.fExceptionHandler = iChangeExceptionHandler;
        Assert.isNotNull(this.fExceptionHandler);
        this.fUnsavedFiles = iFileArray;
        Assert.isNotNull(this.fUnsavedFiles);
        this.fHandledUnsavedFiles = new ArrayList(this.fUnsavedFiles.length);
    }

    public IFile[] getUnsavedFiles() {
        return this.fUnsavedFiles;
    }

    public void checkUnsavedFile(RefactoringStatus refactoringStatus, IFile iFile) {
        if (this.fHandledUnsavedFiles.contains(iFile)) {
            return;
        }
        int n = 0;
        while (n < this.fUnsavedFiles.length) {
            if (this.fUnsavedFiles[n].equals((Object)iFile)) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.getFormattedString("Change.is_unsaved", iFile.getFullPath().toString()));
                this.fHandledUnsavedFiles.add(iFile);
                return;
            }
            ++n;
        }
    }

    public IChangeExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void setFailedChange(IChange iChange) {
        this.fFailedChange = iChange;
    }

    public IChange getFailedChange() {
        return this.fFailedChange;
    }

    public void setTryToUndo() {
        this.fTryToUndo = true;
    }

    public boolean getTryToUndo() {
        return this.fTryToUndo;
    }

    public void addPerformedChange(IChange iChange) {
        this.fPerformedChanges.add(iChange);
    }

    public IChange[] getPerformedChanges() {
        return this.fPerformedChanges.toArray(new IChange[this.fPerformedChanges.size()]);
    }

    public void clearPerformedChanges() {
        this.fPerformedChanges = new ArrayList(1);
    }
}

