/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.base.Context;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatusEntry;
import org.eclipse.core.runtime.IStatus;

public class RefactoringStatus {
    public static final int OK = 0;
    public static final int INFO = 1;
    public static final int WARNING = 2;
    public static final int ERROR = 3;
    public static final int FATAL = 4;
    private List fEntries = new ArrayList(0);
    private int fSeverity = 0;

    public static RefactoringStatus createInfoStatus(String string) {
        return RefactoringStatus.createStatus(1, string);
    }

    public static RefactoringStatus createInfoStatus(String string, Context context) {
        return RefactoringStatus.createStatus(1, string, context);
    }

    public static RefactoringStatus createWarningStatus(String string) {
        return RefactoringStatus.createStatus(2, string);
    }

    public static RefactoringStatus createWarningStatus(String string, Context context) {
        return RefactoringStatus.createStatus(2, string, context);
    }

    public static RefactoringStatus createErrorStatus(String string) {
        return RefactoringStatus.createStatus(3, string);
    }

    public static RefactoringStatus createErrorStatus(String string, Context context) {
        return RefactoringStatus.createStatus(3, string, context);
    }

    public static RefactoringStatus createFatalErrorStatus(String string) {
        return RefactoringStatus.createStatus(4, string);
    }

    public static RefactoringStatus createFatalErrorStatus(String string, Context context) {
        return RefactoringStatus.createStatus(4, string, context);
    }

    public static RefactoringStatus create(IStatus iStatus) {
        if (iStatus.isOK()) {
            return new RefactoringStatus();
        }
        if (!iStatus.isMultiStatus()) {
            switch (iStatus.getSeverity()) {
                case 1: {
                    return RefactoringStatus.createWarningStatus(iStatus.getMessage());
                }
                case 2: {
                    return RefactoringStatus.createErrorStatus(iStatus.getMessage());
                }
                case 4: {
                    return RefactoringStatus.createFatalErrorStatus(iStatus.getMessage());
                }
            }
            return new RefactoringStatus();
        }
        IStatus[] iStatusArray = iStatus.getChildren();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < iStatusArray.length) {
            refactoringStatus.merge(RefactoringStatus.create(iStatusArray[n]));
            ++n;
        }
        return refactoringStatus;
    }

    public static RefactoringStatus createStatus(int n, String string, Context context, Object object, int n2) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.fEntries.add(new RefactoringStatusEntry(string, n, context, object, n2));
        refactoringStatus.fSeverity = n;
        return refactoringStatus;
    }

    public static RefactoringStatus createStatus(int n, String string, Context context) {
        return RefactoringStatus.createStatus(n, string, context, null, 0);
    }

    public static RefactoringStatus createStatus(int n, String string) {
        return RefactoringStatus.createStatus(n, string, null);
    }

    public void addInfo(String string) {
        this.addInfo(string, null);
    }

    public void addInfo(String string, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createInfo(string, context));
        this.fSeverity = Math.max(this.fSeverity, 1);
    }

    public void addWarning(String string) {
        this.addWarning(string, null);
    }

    public void addWarning(String string, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createWarning(string, context));
        this.fSeverity = Math.max(this.fSeverity, 2);
    }

    public void addError(String string) {
        this.addError(string, null);
    }

    public void addError(String string, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createError(string, context));
        this.fSeverity = Math.max(this.fSeverity, 3);
    }

    public void addFatalError(String string) {
        this.addFatalError(string, null);
    }

    public void addFatalError(String string, Context context) {
        this.fEntries.add(RefactoringStatusEntry.createFatal(string, context));
        this.fSeverity = Math.max(this.fSeverity, 4);
    }

    public void addEntry(RefactoringStatusEntry refactoringStatusEntry) {
        Assert.isNotNull(refactoringStatusEntry);
        this.fEntries.add(refactoringStatusEntry);
        this.fSeverity = Math.max(this.fSeverity, refactoringStatusEntry.getSeverity());
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean hasFatalError() {
        return this.fSeverity == 4;
    }

    public boolean hasError() {
        return this.fSeverity == 4 || this.fSeverity == 3;
    }

    public boolean hasWarning() {
        return this.fSeverity == 4 || this.fSeverity == 3 || this.fSeverity == 2;
    }

    public boolean hasEntryWithCode(int n) {
        Iterator iterator = this.fEntries.iterator();
        while (iterator.hasNext()) {
            RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)iterator.next();
            if (refactoringStatusEntry.getCode() != n) continue;
            return true;
        }
        return false;
    }

    public void merge(RefactoringStatus refactoringStatus) {
        if (refactoringStatus == null) {
            return;
        }
        this.fEntries.addAll(refactoringStatus.getEntries());
        this.fSeverity = Math.max(this.fSeverity, refactoringStatus.getSeverity());
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public List getEntries() {
        return this.fEntries;
    }

    public RefactoringStatusEntry getEntry(int n) {
        return (RefactoringStatusEntry)this.fEntries.get(n);
    }

    public RefactoringStatusEntry getFirstEntry(int n) {
        Assert.isTrue(n >= 0 && n <= 4);
        if (n > this.fSeverity) {
            return null;
        }
        Iterator iterator = this.fEntries.iterator();
        while (iterator.hasNext()) {
            RefactoringStatusEntry refactoringStatusEntry = (RefactoringStatusEntry)iterator.next();
            if (refactoringStatusEntry.getSeverity() < n) continue;
            return refactoringStatusEntry;
        }
        return null;
    }

    public String getFirstMessage(int n) {
        RefactoringStatusEntry refactoringStatusEntry = this.getFirstEntry(n);
        if (refactoringStatusEntry == null) {
            return null;
        }
        return refactoringStatusEntry.getMessage();
    }

    static String getSeverityString(int n) {
        Assert.isTrue(n >= 0 && n <= 4);
        if (n == 0) {
            return "OK";
        }
        if (n == 1) {
            return "INFO";
        }
        if (n == 2) {
            return "WARNING";
        }
        if (n == 3) {
            return "ERROR";
        }
        if (n == 4) {
            return "FATALERROR";
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<").append(RefactoringStatus.getSeverityString(this.fSeverity)).append("\n");
        if (!this.isOK()) {
            Iterator iterator = this.fEntries.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t").append(iterator.next()).append("\n");
            }
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

