/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.base;

import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.base.Context;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RefactoringStatusEntry {
    private final String fMessage;
    private final int fSeverity;
    private final Context fContext;
    private final Object fData;
    private final int fCode;

    public RefactoringStatusEntry(String string, int n, Context context, Object object, int n2) {
        Assert.isTrue(n == 1 || n == 2 || n == 3 || n == 4);
        Assert.isNotNull(string);
        this.fMessage = string;
        this.fSeverity = n;
        this.fContext = context;
        this.fData = object;
        this.fCode = n2;
    }

    public RefactoringStatusEntry(String string, int n, Context context) {
        this(string, n, context, null, 0);
    }

    public RefactoringStatusEntry(String string, int n) {
        this(string, n, null);
    }

    public static RefactoringStatusEntry createInfo(String string) {
        return new RefactoringStatusEntry(string, 1);
    }

    public static RefactoringStatusEntry createInfo(String string, Context context) {
        return new RefactoringStatusEntry(string, 1, context);
    }

    public static RefactoringStatusEntry createWarning(String string) {
        return new RefactoringStatusEntry(string, 2);
    }

    public static RefactoringStatusEntry createWarning(String string, Context context) {
        return new RefactoringStatusEntry(string, 2, context);
    }

    public static RefactoringStatusEntry createError(String string) {
        return new RefactoringStatusEntry(string, 3);
    }

    public static RefactoringStatusEntry createError(String string, Context context) {
        return new RefactoringStatusEntry(string, 3, context);
    }

    public static RefactoringStatusEntry createFatal(String string) {
        return new RefactoringStatusEntry(string, 4);
    }

    public static RefactoringStatusEntry createFatal(String string, Context context) {
        return new RefactoringStatusEntry(string, 4, context);
    }

    public boolean isFatalError() {
        return this.fSeverity == 4;
    }

    public boolean isError() {
        return this.fSeverity == 3;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public Context getContext() {
        return this.fContext;
    }

    public Object getData() {
        return this.fData;
    }

    public int getCode() {
        return this.fCode;
    }

    public IStatus asStatus() {
        int n = 4;
        switch (this.fSeverity) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: 
            case 3: {
                n = 2;
            }
        }
        return new Status(n, CUIPlugin.getPluginId(), this.fCode, this.fMessage, null);
    }

    public String toString() {
        String string = this.fContext == null ? "<Unspecified context>" : this.fContext.toString();
        return "\n" + RefactoringStatus.getSeverityString(this.fSeverity) + ": " + this.fMessage + "\nContext: " + string + "\nData: " + this.getData() + "\ncode: " + this.fCode + "\n";
    }
}

