/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.changes;

import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public class TextBufferEditor
extends TextEditProcessor {
    private TextBuffer fBuffer;
    private TextEditProcessor fUndoProcessor;

    public TextBufferEditor(TextBuffer textBuffer) {
        super(textBuffer.getDocument(), (TextEdit)new MultiTextEdit(0, textBuffer.getDocument().getLength()), 3);
        this.fBuffer = textBuffer;
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit textEdit) throws MalformedTreeException {
        this.getRoot().addChild(textEdit);
    }

    public void add(UndoEdit undoEdit) {
        Assert.isTrue(!this.getRoot().hasChildren());
        this.fUndoProcessor = new TextEditProcessor(this.getDocument(), (TextEdit)undoEdit, 3);
    }

    public boolean canPerformEdits() {
        if (this.fUndoProcessor != null) {
            return this.fUndoProcessor.canPerformEdits();
        }
        return super.canPerformEdits();
    }

    public UndoEdit performEdits(IProgressMonitor iProgressMonitor) throws CoreException {
        try {
            if (this.fUndoProcessor != null) {
                return this.fUndoProcessor.performEdits();
            }
            return super.performEdits();
        }
        catch (BadLocationException badLocationException) {
            String string = badLocationException != null ? badLocationException.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 4, string, (Throwable)badLocationException));
        }
        catch (MalformedTreeException malformedTreeException) {
            String string = malformedTreeException != null ? malformedTreeException.getMessage() : "";
            throw new CoreException((IStatus)new Status(4, CUIPlugin.getPluginId(), 4, string, (Throwable)malformedTreeException));
        }
    }
}

