/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.changes.AbstractTextChange;
import org.eclipse.cdt.internal.corext.textmanipulation.GroupDescription;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRegion;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;

public abstract class TextChange
extends AbstractTextChange {
    private List fTextEditChanges = new ArrayList(5);
    private TextEditCopier fCopier;
    private TextEdit fEdit;
    private boolean fKeepExecutedTextEdits;
    private boolean fAutoMode;
    private String fTextType = "txt";

    protected TextChange(String string) {
        super(string, 0);
    }

    protected void setTextType(String string) {
        if (string == null) {
            this.fTextType = "txt";
        }
        this.fTextType = string;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public void addTextEdit(String string, TextEdit textEdit) {
        this.addTextEdit(string, new TextEdit[]{textEdit});
    }

    public void addTextEdit(String string, TextEdit[] textEditArray) {
        Assert.isNotNull(string);
        Assert.isNotNull(textEditArray);
        GroupDescription groupDescription = new GroupDescription(string, textEditArray);
        this.fTextEditChanges.add(new EditChange(groupDescription, this));
        if (this.fEdit == null) {
            this.fEdit = new MultiTextEdit();
            this.fAutoMode = true;
        } else {
            Assert.isTrue(this.fAutoMode, "Can only add edits when in auto organizing mode");
        }
        int n = 0;
        while (n < textEditArray.length) {
            TextChange.insert(this.fEdit, textEditArray[n]);
            ++n;
        }
    }

    public void setEdit(TextEdit textEdit) {
        Assert.isTrue(this.fEdit == null, "Root edit can only be set once");
        Assert.isTrue(textEdit != null);
        this.fEdit = textEdit;
        this.fTextEditChanges = new ArrayList(5);
        this.fAutoMode = false;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addGroupDescription(GroupDescription groupDescription) {
        Assert.isTrue(this.fEdit != null, "Can only add a description if a root edit exists");
        Assert.isTrue(!this.fAutoMode, "Group descriptions are only supported if root edit has been set by setEdit");
        Assert.isTrue(groupDescription != null);
        this.fTextEditChanges.add(new EditChange(groupDescription, this));
    }

    public void addGroupDescriptions(GroupDescription[] groupDescriptionArray) {
        int n = 0;
        while (n < groupDescriptionArray.length) {
            this.addGroupDescription(groupDescriptionArray[n]);
            ++n;
        }
    }

    public GroupDescription[] getGroupDescriptions() {
        GroupDescription[] groupDescriptionArray = new GroupDescription[this.fTextEditChanges.size()];
        int n = 0;
        while (n < groupDescriptionArray.length) {
            EditChange editChange = (EditChange)this.fTextEditChanges.get(n);
            groupDescriptionArray[n] = editChange.getGroupDescription();
            ++n;
        }
        return groupDescriptionArray;
    }

    public GroupDescription getGroupDescription(String string) {
        int n = 0;
        while (n < this.fTextEditChanges.size()) {
            EditChange editChange = (EditChange)this.fTextEditChanges.get(n);
            GroupDescription groupDescription = editChange.getGroupDescription();
            if (string.equals(groupDescription.getName())) {
                return groupDescription;
            }
            ++n;
        }
        return null;
    }

    public EditChange[] getTextEditChanges() {
        return this.fTextEditChanges.toArray(new EditChange[this.fTextEditChanges.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCurrentContent() throws CModelException {
        String string;
        TextBuffer textBuffer = null;
        try {
            try {
                textBuffer = this.acquireTextBuffer();
                string = textBuffer.getContent();
                Object var3_3 = null;
                if (textBuffer == null) return string;
            }
            catch (CModelException cModelException) {
                throw cModelException;
            }
            catch (CoreException coreException) {
                throw new CModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (textBuffer == null) throw throwable;
            this.releaseTextBuffer(textBuffer);
            throw throwable;
        }
        this.releaseTextBuffer(textBuffer);
        return string;
    }

    public String getPreviewContent() throws CModelException {
        return this.getPreviewTextBuffer().getContent();
    }

    public TextBuffer getPreviewTextBuffer() throws CModelException {
        try {
            AbstractTextChange.LocalTextEditProcessor localTextEditProcessor = new AbstractTextChange.LocalTextEditProcessor(this.createTextBuffer());
            this.addTextEdits(localTextEditProcessor);
            localTextEditProcessor.performEdits((IProgressMonitor)new NullProgressMonitor());
            return localTextEditProcessor.getTextBuffer();
        }
        catch (CModelException cModelException) {
            throw cModelException;
        }
        catch (CoreException coreException) {
            throw new CModelException(coreException);
        }
    }

    public String getCurrentContent(EditChange editChange, int n) throws CoreException {
        return this.getContent(editChange, n, false);
    }

    public String getPreviewContent(EditChange editChange, int n) throws CoreException {
        return this.getContent(editChange, n, true);
    }

    public String getCurrentContent(IRegion iRegion) throws CoreException {
        String string;
        block2: {
            TextBuffer textBuffer = null;
            try {
                textBuffer = this.acquireTextBuffer();
                int n = textBuffer.getLineInformationOfOffset(iRegion.getOffset()).getOffset();
                int n2 = iRegion.getLength() + iRegion.getOffset() - n;
                string = textBuffer.getContent(n, n2);
                Object var5_6 = null;
                if (textBuffer == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var5_7 = null;
                    if (textBuffer == null) break block3;
                    this.releaseTextBuffer(textBuffer);
                }
                throw throwable;
            }
            this.releaseTextBuffer(textBuffer);
        }
        return string;
    }

    public String getPreviewContent(EditChange[] editChangeArray, IRegion iRegion) throws CoreException {
        TextBuffer textBuffer = this.createTextBuffer();
        AbstractTextChange.LocalTextEditProcessor localTextEditProcessor = new AbstractTextChange.LocalTextEditProcessor(textBuffer);
        this.addTextEdits(localTextEditProcessor, editChangeArray);
        int n = textBuffer.getLength();
        localTextEditProcessor.performEdits((IProgressMonitor)new NullProgressMonitor());
        int n2 = textBuffer.getLength() - n;
        int n3 = textBuffer.getLineInformationOfOffset(iRegion.getOffset()).getOffset();
        int n4 = iRegion.getLength() + iRegion.getOffset() - n3 + n2;
        if (n4 > 0) {
            return textBuffer.getContent(n3, n4);
        }
        return "";
    }

    public void setKeepExecutedTextEdits(boolean bl) {
        this.fKeepExecutedTextEdits = bl;
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    private TextEdit getExecutedTextEdit(TextEdit textEdit) {
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        return this.fCopier.getCopy(textEdit);
    }

    public IRegion getNewTextRange(TextEdit textEdit) {
        Assert.isNotNull(textEdit);
        TextEdit textEdit2 = this.getExecutedTextEdit(textEdit);
        if (textEdit2 == null) {
            return null;
        }
        return textEdit2.getRegion();
    }

    public IRegion getNewTextRange(TextEdit[] textEditArray) {
        Assert.isTrue(textEditArray != null && textEditArray.length > 0);
        if (!this.fKeepExecutedTextEdits || this.fCopier == null) {
            return null;
        }
        TextEdit[] textEditArray2 = new TextEdit[textEditArray.length];
        int n = 0;
        while (n < textEditArray.length) {
            TextEdit textEdit = this.fCopier.getCopy(textEditArray[n]);
            if (textEdit == null) {
                return null;
            }
            textEditArray2[n] = textEdit;
            ++n;
        }
        return TextEdit.getCoverage((TextEdit[])textEditArray2);
    }

    public IRegion getNewTextRange(EditChange editChange) {
        return this.getNewTextRange(editChange.getGroupDescription().getTextEdits());
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        Iterator iterator = this.fTextEditChanges.iterator();
        while (iterator.hasNext()) {
            EditChange editChange = (EditChange)iterator.next();
            editChange.setActive(bl);
        }
    }

    protected void addTextEdits(AbstractTextChange.LocalTextEditProcessor localTextEditProcessor) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        ArrayList<TextEdit> arrayList = new ArrayList<TextEdit>(0);
        TextEdit textEdit = this.fTextEditChanges.iterator();
        while (textEdit.hasNext()) {
            EditChange editChange = (EditChange)textEdit.next();
            if (editChange.isActive()) continue;
            arrayList.addAll(Arrays.asList(editChange.getGroupDescription().getTextEdits()));
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        textEdit = this.fCopier.perform();
        if (textEdit != null) {
            localTextEditProcessor.add(textEdit);
            localTextEditProcessor.setExcludes(this.mapEdits(arrayList.toArray(new TextEdit[arrayList.size()]), this.fCopier));
        }
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    protected void addTextEdits(AbstractTextChange.LocalTextEditProcessor localTextEditProcessor, EditChange[] editChangeArray) throws CoreException {
        if (this.fEdit == null) {
            return;
        }
        ArrayList<TextEdit> arrayList = new ArrayList<TextEdit>(0);
        int n = 0;
        while (n < editChangeArray.length) {
            EditChange editChange = editChangeArray[n];
            Assert.isTrue(editChange.getTextChange() == this);
            if (editChange.isActive()) {
                arrayList.addAll(Arrays.asList(editChange.getGroupDescription().getTextEdits()));
            }
            ++n;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit textEdit = this.fCopier.perform();
        if (textEdit != null) {
            localTextEditProcessor.add(textEdit);
            localTextEditProcessor.setIncludes(this.mapEdits(arrayList.toArray(new TextEdit[arrayList.size()]), this.fCopier));
        }
        if (!this.fKeepExecutedTextEdits) {
            this.fCopier = null;
        }
    }

    private TextEdit[] mapEdits(TextEdit[] textEditArray, TextEditCopier textEditCopier) {
        if (textEditArray == null) {
            return null;
        }
        int n = 0;
        while (n < textEditArray.length) {
            textEditArray[n] = textEditCopier.getCopy(textEditArray[n]);
            ++n;
        }
        return textEditArray;
    }

    private String getContent(EditChange editChange, int n, boolean bl) throws CoreException {
        int n2;
        Assert.isTrue(editChange.getTextChange() == this);
        TextBuffer textBuffer = this.createTextBuffer();
        IRegion iRegion = null;
        if (bl) {
            AbstractTextChange.LocalTextEditProcessor localTextEditProcessor = new AbstractTextChange.LocalTextEditProcessor(textBuffer);
            n2 = this.fKeepExecutedTextEdits;
            this.setKeepExecutedTextEdits(true);
            this.addTextEdits(localTextEditProcessor, new EditChange[]{editChange});
            localTextEditProcessor.performEdits((IProgressMonitor)new NullProgressMonitor());
            iRegion = this.getNewTextRange(editChange);
            this.setKeepExecutedTextEdits(n2 != 0);
        } else {
            iRegion = editChange.getTextRange();
        }
        int n3 = Math.max(textBuffer.getLineOfOffset(iRegion.getOffset()) - n, 0);
        n2 = Math.min(textBuffer.getLineOfOffset(iRegion.getOffset() + iRegion.getLength() - 1) + n, textBuffer.getNumberOfLines() - 1);
        int n4 = textBuffer.getLineInformation(n3).getOffset();
        TextRegion textRegion = textBuffer.getLineInformation(n2);
        int n5 = textRegion.getOffset() + textRegion.getLength() - n4;
        return textBuffer.getContent(n4, n5);
    }

    private static void insert(TextEdit textEdit, TextEdit textEdit2) {
        TextEdit textEdit3;
        if (!textEdit.hasChildren()) {
            textEdit.addChild(textEdit2);
            return;
        }
        TextEdit[] textEditArray = textEdit.getChildren();
        int n = 0;
        while (n < textEditArray.length) {
            textEdit3 = textEditArray[n];
            if (TextChange.covers(textEdit3, textEdit2)) {
                TextChange.insert(textEdit3, textEdit2);
                return;
            }
            ++n;
        }
        n = textEditArray.length - 1;
        while (n >= 0) {
            textEdit3 = textEditArray[n];
            if (TextChange.covers(textEdit2, textEdit3)) {
                textEdit.removeChild(n);
                textEdit2.addChild(textEdit3);
            }
            --n;
        }
        textEdit.addChild(textEdit2);
    }

    private static boolean covers(TextEdit textEdit, TextEdit textEdit2) {
        if (textEdit.getLength() == 0) {
            return false;
        }
        int n = textEdit.getOffset();
        int n2 = textEdit.getExclusiveEnd();
        if (textEdit2.getLength() == 0) {
            int n3 = textEdit2.getOffset();
            return n < n3 && n3 < n2;
        }
        int n4 = textEdit2.getOffset();
        int n5 = textEdit2.getExclusiveEnd();
        return n <= n4 && n5 <= n2;
    }

    public static class EditChange {
        private boolean fIsActive;
        private TextChange fTextChange;
        private GroupDescription fDescription;

        EditChange(GroupDescription groupDescription, TextChange textChange) {
            this.fTextChange = textChange;
            this.fIsActive = true;
            this.fDescription = groupDescription;
        }

        public String getName() {
            return this.fDescription.getName();
        }

        public void setActive(boolean bl) {
            this.fIsActive = bl;
        }

        public boolean isActive() {
            return this.fIsActive;
        }

        public TextChange getTextChange() {
            return this.fTextChange;
        }

        public IRegion getTextRange() {
            return this.fDescription.getTextRange();
        }

        public boolean isEmpty() {
            return this.fDescription.hasTextEdits();
        }

        GroupDescription getGroupDescription() {
            return this.fDescription;
        }

        public boolean coveredBy(IRegion iRegion) {
            int n = iRegion.getLength();
            if (n == 0) {
                return false;
            }
            int n2 = iRegion.getOffset();
            int n3 = n2 + n - 1;
            TextEdit[] textEditArray = this.fDescription.getTextEdits();
            int n4 = 0;
            while (n4 < textEditArray.length) {
                TextEdit textEdit = textEditArray[n4];
                if (textEdit.isDeleted()) {
                    return false;
                }
                int n5 = textEdit.getOffset();
                int n6 = textEdit.getLength();
                int n7 = n5 + n6 - 1;
                if (n6 == 0 ? n2 >= n5 || n5 > n3 : n2 > n5 || n7 > n3) {
                    return false;
                }
                ++n4;
            }
            return true;
        }
    }
}

