/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.changes;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.Checks;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.UndoTextChange;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.text.edits.UndoEdit;

public class TextFileChange
extends TextChange {
    private IFile fFile;
    private TextBuffer fAcquiredTextBuffer;
    private int fAcquireCounter;
    private boolean fSave = true;

    public TextFileChange(String string, IFile iFile) {
        super(string);
        this.fFile = iFile;
        Assert.isNotNull(this.fFile);
    }

    public void setSave(boolean bl) {
        this.fSave = bl;
    }

    public IFile getFile() {
        return this.fFile;
    }

    protected TextBuffer acquireTextBuffer() throws CoreException {
        TextBuffer textBuffer = TextBuffer.acquire(this.fFile);
        if (this.fAcquiredTextBuffer == null || textBuffer == this.fAcquiredTextBuffer) {
            this.fAcquiredTextBuffer = textBuffer;
            ++this.fAcquireCounter;
        }
        return textBuffer;
    }

    protected void releaseTextBuffer(TextBuffer textBuffer) {
        TextBuffer.release(textBuffer);
        if (textBuffer == this.fAcquiredTextBuffer && --this.fAcquireCounter == 0) {
            this.fAcquiredTextBuffer = null;
        }
    }

    protected TextBuffer createTextBuffer() throws CoreException {
        return TextBuffer.create(this.fFile);
    }

    protected IChange createReverseChange(UndoEdit undoEdit, int n) {
        return new UndoTextFileChange(this.getName(), this.fFile, n, undoEdit);
    }

    public Object getModifiedLanguageElement() {
        return this.fFile;
    }

    public RefactoringStatus aboutToPerform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) {
        if (this.fSave) {
            return Checks.validateModifiesFiles(new IFile[]{this.fFile});
        }
        return new RefactoringStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException, ChangeAbortException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (!this.isActive()) {
            super.perform(changeContext, iProgressMonitor);
            return;
        }
        try {
            try {
                this.acquireTextBuffer();
                iProgressMonitor.beginTask("", 10);
                super.perform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 8));
                if (this.fSave) {
                    TextBuffer.aboutToChange(this.fAcquiredTextBuffer);
                    TextBuffer.save(this.fAcquiredTextBuffer, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                }
            }
            catch (Exception exception) {
                this.handleException(changeContext, exception);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        iProgressMonitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performed() {
        block6: {
            if (this.fAcquiredTextBuffer == null) break block6;
            try {
                try {
                    if (this.fSave) {
                        TextBuffer.changed(this.fAcquiredTextBuffer);
                    }
                }
                catch (CoreException coreException) {
                    Assert.isTrue(false, "Should not happen since the buffer is acquired through a text buffer manager");
                }
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.releaseTextBuffer(this.fAcquiredTextBuffer);
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.releaseTextBuffer(this.fAcquiredTextBuffer);
            }
        }
        super.performed();
    }

    protected static class UndoTextFileChange
    extends UndoTextChange {
        private IFile fFile;
        private TextBuffer fAcquiredTextBuffer;
        private int fAcquireCounter;

        public UndoTextFileChange(String string, IFile iFile, int n, UndoEdit undoEdit) {
            super(string, n, undoEdit);
            this.fFile = iFile;
        }

        public Object getModifiedLanguageElement() {
            return this.fFile;
        }

        protected TextBuffer acquireTextBuffer() throws CoreException {
            TextBuffer textBuffer = TextBuffer.acquire(this.fFile);
            if (this.fAcquiredTextBuffer == null || textBuffer == this.fAcquiredTextBuffer) {
                this.fAcquiredTextBuffer = textBuffer;
                ++this.fAcquireCounter;
            }
            return textBuffer;
        }

        protected void releaseTextBuffer(TextBuffer textBuffer) {
            TextBuffer.release(textBuffer);
            if (textBuffer == this.fAcquiredTextBuffer && --this.fAcquireCounter == 0) {
                this.fAcquiredTextBuffer = null;
            }
        }

        protected TextBuffer createTextBuffer() throws CoreException {
            return TextBuffer.create(this.fFile);
        }

        protected IChange createReverseChange(UndoEdit undoEdit, int n) {
            return new UndoTextFileChange(this.getName(), this.fFile, n, undoEdit);
        }

        public RefactoringStatus aboutToPerform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) {
            RefactoringStatus refactoringStatus = Checks.validateModifiesFiles(new IFile[]{this.fFile});
            if (refactoringStatus.hasFatalError()) {
                return refactoringStatus;
            }
            changeContext.checkUnsavedFile(refactoringStatus, this.fFile);
            return refactoringStatus;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform(ChangeContext changeContext, IProgressMonitor iProgressMonitor) throws CModelException, ChangeAbortException {
            if (!this.isActive()) {
                super.perform(changeContext, iProgressMonitor);
                return;
            }
            try {
                try {
                    this.acquireTextBuffer();
                    iProgressMonitor.beginTask("", 10);
                    super.perform(changeContext, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 8));
                    TextBuffer.aboutToChange(this.fAcquiredTextBuffer);
                    TextBuffer.save(this.fAcquiredTextBuffer, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                }
                catch (Exception exception) {
                    this.handleException(changeContext, exception);
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            iProgressMonitor.done();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void performed() {
            if (this.fAcquiredTextBuffer != null) {
                try {
                    try {
                        TextBuffer.changed(this.fAcquiredTextBuffer);
                    }
                    catch (CoreException coreException) {
                        Assert.isTrue(false, "Should not happen since the buffer is acquired through a text buffer manager");
                    }
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    this.releaseTextBuffer(this.fAcquiredTextBuffer);
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    this.releaseTextBuffer(this.fAcquiredTextBuffer);
                }
            }
            super.performed();
        }
    }
}

