/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceManipulation;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructure;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IVariable;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.OrPattern;
import org.eclipse.cdt.core.search.SearchEngine;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.cdt.internal.corext.refactoring.Checks;
import org.eclipse.cdt.internal.corext.refactoring.CompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.IReferenceUpdating;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.cdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.cdt.internal.corext.refactoring.RenameProcessor;
import org.eclipse.cdt.internal.corext.refactoring.ResourceUtil;
import org.eclipse.cdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.cdt.internal.corext.refactoring.TextChangeManager;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.RefactoringStatus;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameElementProcessor
extends RenameProcessor
implements IReferenceUpdating {
    private ICElement fCElement = null;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private final String QUALIFIER = "::";
    private final String TELTA = "~";
    private boolean fUpdateReferences;

    public ICElement getCElement() {
        return this.fCElement;
    }

    public void initialize(Object[] objectArray) throws CoreException {
        Assert.isTrue(objectArray != null && objectArray.length == 1);
        Object object = objectArray[0];
        if (object == null) {
            return;
        }
        if (!(object instanceof ISourceReference)) {
            return;
        }
        this.fCElement = (ICElement)object;
        this.setNewElementName(this.fCElement.getElementName());
        this.fUpdateReferences = true;
    }

    public boolean isAvailable() throws CoreException {
        if (this.fCElement == null) {
            return false;
        }
        if (!(this.fCElement instanceof ISourceReference)) {
            return false;
        }
        return Checks.isAvailable(this.fCElement);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name", new String[]{this.fCElement.getElementName(), this.fNewElementName});
    }

    public Object[] getElements() {
        return new Object[]{this.fCElement};
    }

    public String getCurrentElementName() {
        if (this.fCElement == null) {
            return "";
        }
        String string = this.fCElement.getElementName();
        if (string.indexOf("::") != -1) {
            return string.substring(string.lastIndexOf("::") + 2, string.length());
        }
        return string;
    }

    private int getCurrentElementNameLength() {
        if (this.fCElement == null) {
            return 0;
        }
        String string = this.fCElement.getElementName();
        if (string.indexOf("::") != -1) {
            String string2 = string.substring(string.lastIndexOf("::") + 2, string.length());
            return string2.length();
        }
        return string.length();
    }

    private int getCurrentElementNameStartPos() {
        if (this.fCElement == null) {
            return 0;
        }
        String string = this.fCElement.getElementName();
        if (string.indexOf("::") != -1) {
            return ((CElement)this.fCElement).getIdStartPos() + string.lastIndexOf("::") + 2;
        }
        return ((CElement)this.fCElement).getIdStartPos();
    }

    private String getElementQualifiedName(ICElement iCElement) throws CModelException {
        if (!this.eligibleForRefactoring(iCElement)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (iCElement instanceof IFunctionDeclaration) {
            IFunctionDeclaration iFunctionDeclaration = (IFunctionDeclaration)iCElement;
            if (iCElement instanceof IMethodDeclaration && ((IMethodDeclaration)iCElement).isFriend()) {
                ICElement iCElement2 = iCElement.getParent();
                while (!(iCElement2 instanceof INamespace) && !(iCElement2 instanceof ITranslationUnit)) {
                    iCElement2 = iCElement2.getParent();
                }
                stringBuffer.append(this.getElementQualifiedName(iCElement2));
            } else {
                stringBuffer.append(this.getElementQualifiedName(iCElement.getParent()));
            }
            stringBuffer.append("::");
            stringBuffer.append(iFunctionDeclaration.getSignature());
        } else {
            if (iCElement instanceof IEnumerator) {
                IEnumeration iEnumeration = (IEnumeration)iCElement.getParent();
                stringBuffer.append(this.getElementQualifiedName(iEnumeration.getParent()));
            } else {
                stringBuffer.append(this.getElementQualifiedName(iCElement.getParent()));
            }
            stringBuffer.append("::");
            stringBuffer.append(iCElement.getElementName());
        }
        return stringBuffer.toString();
    }

    public RefactoringStatus checkNewElementName(String string) throws CModelException {
        Object object;
        if (!this.eligibleForRefactoring(this.fCElement)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTypeRefactoring.wrong_element"));
        }
        Assert.isNotNull(string, "new name");
        RefactoringStatus refactoringStatus = null;
        refactoringStatus = this.fCElement instanceof IStructure ? Checks.checkClassName(string) : (this.fCElement instanceof IMethodDeclaration || this.fCElement instanceof IFunctionDeclaration ? Checks.checkMethodName(string) : (this.fCElement instanceof IField ? Checks.checkFieldName(string) : Checks.checkIdentifier(string)));
        if (!(this.fCElement instanceof IFunctionDeclaration) && this.checkSiblingsCollision(true).hasError()) {
            object = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
            refactoringStatus.addFatalError((String)object);
        }
        if (this.fCElement instanceof IMethodDeclaration && (object = (IMethodDeclaration)this.fCElement).isVirtual()) {
            String string2 = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.virtual_method", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
            refactoringStatus.addWarning(string2);
        }
        if (Checks.isAlreadyNamed(this.fCElement, string)) {
            refactoringStatus.addFatalError(RefactoringCoreMessages.getString("RenameTypeRefactoring.choose_another_name"));
        }
        return refactoringStatus;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean canEnableTextUpdating() {
        return false;
    }

    public RefactoringStatus checkActivation() throws CoreException {
        if (!this.eligibleForRefactoring(this.fCElement)) {
            return RefactoringStatus.createFatalErrorStatus(RefactoringCoreMessages.getString("RenameTypeRefactoring.wrong_element"));
        }
        return Checks.checkIfTuBroken(this.fCElement);
    }

    public RefactoringStatus checkInput(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block10: {
            block9: {
                block8: {
                    block7: {
                        RefactoringStatus refactoringStatus2;
                        Assert.isNotNull(this.fCElement, "type");
                        Assert.isNotNull(this.fNewElementName, "newName");
                        refactoringStatus = new RefactoringStatus();
                        try {
                            iProgressMonitor.beginTask("", 20);
                            iProgressMonitor.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
                            refactoringStatus.merge(this.checkNewElementName(this.fNewElementName));
                            if (!refactoringStatus.hasFatalError()) break block7;
                            refactoringStatus2 = refactoringStatus;
                            Object var3_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var3_13 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        iProgressMonitor.done();
                        return refactoringStatus2;
                    }
                    iProgressMonitor.worked(5);
                    refactoringStatus.merge(Checks.checkIfTuBroken(this.fCElement));
                    if (!refactoringStatus.hasFatalError()) break block8;
                    RefactoringStatus refactoringStatus3 = refactoringStatus;
                    Object var3_9 = null;
                    iProgressMonitor.done();
                    return refactoringStatus3;
                }
                iProgressMonitor.worked(1);
                refactoringStatus.merge(this.checkEnclosingElements());
                iProgressMonitor.worked(1);
                refactoringStatus.merge(this.checkEnclosedElements());
                iProgressMonitor.worked(1);
                refactoringStatus.merge(this.checkSiblingsCollision(false));
                iProgressMonitor.worked(1);
                if (!refactoringStatus.hasFatalError()) break block9;
                RefactoringStatus refactoringStatus4 = refactoringStatus;
                Object var3_10 = null;
                iProgressMonitor.done();
                return refactoringStatus4;
            }
            this.fReferences = null;
            iProgressMonitor.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching"));
            this.fReferences = this.getReferences(this.getElementQualifiedName(this.fCElement), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 35), this.fUpdateReferences);
            iProgressMonitor.worked(6);
            refactoringStatus.merge(this.analyzeAffectedTranslationUnits());
            iProgressMonitor.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (!refactoringStatus.hasFatalError()) break block10;
            RefactoringStatus refactoringStatus5 = refactoringStatus;
            Object var3_11 = null;
            iProgressMonitor.done();
            return refactoringStatus5;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 35));
        iProgressMonitor.worked(5);
        RefactoringStatus refactoringStatus6 = refactoringStatus;
        Object var3_12 = null;
        iProgressMonitor.done();
        return refactoringStatus6;
    }

    public IChange createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.creating_change"), 4);
        CompositeChange compositeChange = new CompositeChange(RefactoringCoreMessages.getString("Change.javaChanges"));
        compositeChange.addAll(this.fChangeManager.getAllChanges());
        iProgressMonitor.worked(1);
        return compositeChange;
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> arrayList = new ArrayList<IFile>();
        arrayList.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllTranslationUnits())));
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private TextChangeManager createChangeManager(IProgressMonitor iProgressMonitor) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            iProgressMonitor.beginTask("", 7);
            TextChangeManager textChangeManager2 = new TextChangeManager();
            this.addReferenceUpdates(textChangeManager2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3));
            iProgressMonitor.worked(1);
            iProgressMonitor.worked(1);
            textChangeManager = textChangeManager2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return textChangeManager;
    }

    private void addReferenceUpdates(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("", this.fReferences.length);
        int n = 0;
        while (n < this.fReferences.length) {
            ITranslationUnit iTranslationUnit;
            IResource iResource = this.fReferences[n].getResultGroupResource();
            if (iResource != null && (iTranslationUnit = (ITranslationUnit)CoreModel.getDefault().create(iResource)) != null) {
                ITranslationUnit iTranslationUnit2 = CModelUtil.toWorkingCopy(iTranslationUnit);
                if (iTranslationUnit2 == null) {
                    return;
                }
                ITranslationUnit iTranslationUnit3 = iTranslationUnit2;
                String string = RefactoringCoreMessages.getString("RenameTypeRefactoring.update_reference");
                BasicSearchMatch[] basicSearchMatchArray = this.fReferences[n].getSearchResults();
                int n2 = 0;
                while (n2 < basicSearchMatchArray.length) {
                    BasicSearchMatch basicSearchMatch = basicSearchMatchArray[n2];
                    int n3 = this.getCurrentElementNameLength();
                    int n4 = basicSearchMatch.getEndOffset() - n3;
                    textChangeManager.get(iTranslationUnit3).addTextEdit(string, (TextEdit)new ReplaceEdit(n4, n3, this.fNewElementName));
                    ++n2;
                }
                iProgressMonitor.worked(1);
            }
            ++n;
        }
    }

    private void addTypeDeclarationUpdate(TextChangeManager textChangeManager) throws CoreException {
        String string = RefactoringCoreMessages.getString("RenameTypeRefactoring.update");
        if (this.fCElement instanceof ISourceReference) {
            ITranslationUnit iTranslationUnit = ((ISourceReference)this.fCElement).getTranslationUnit();
            textChangeManager.get(iTranslationUnit).addTextEdit(string, (TextEdit)new ReplaceEdit(this.getCurrentElementNameStartPos(), this.getCurrentElementNameLength(), this.fNewElementName));
        }
    }

    private SearchResultGroup[] getReferences(String string, IProgressMonitor iProgressMonitor, boolean bl) throws CoreException {
        return RefactoringSearchEngine.search(iProgressMonitor, this.createRefactoringScope(), (ICSearchPattern)this.createSearchPattern(string, bl));
    }

    private ICSearchScope createRefactoringScope() throws CoreException {
        ICElement[] iCElementArray = new ICElement[]{this.fCElement.getCProject()};
        ICSearchScope iCSearchScope = SearchEngine.createCSearchScope((ICElement[])iCElementArray, (boolean)true);
        return iCSearchScope;
    }

    private OrPattern createSearchPattern(String string, boolean bl) throws CoreException {
        OrPattern orPattern = new OrPattern();
        if (this.fCElement instanceof IStructure) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.TYPE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
            IStructure iStructure = (IStructure)this.fCElement;
            orPattern.addPattern(SearchEngine.createSearchPattern((String)(String.valueOf(string) + "::" + iStructure.getElementName()), (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            orPattern.addPattern(SearchEngine.createSearchPattern((String)(String.valueOf(string) + "::" + "~" + iStructure.getElementName()), (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
        } else if (this.fCElement instanceof IMethod) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IMethodDeclaration) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IFunction) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.METHOD, (ICSearchConstants.LimitTo)ICSearchConstants.DEFINITIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IFunctionDeclaration) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FUNCTION, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IEnumeration) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.ENUM, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IEnumerator) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.ENUMTOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IField) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.FIELD, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof IVariable) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.VAR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (this.fCElement instanceof INamespace) {
            if (bl) {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
            } else {
                orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.NAMESPACE, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
            }
        } else if (bl) {
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.UNKNOWN_SEARCH_FOR, (ICSearchConstants.LimitTo)ICSearchConstants.ALL_OCCURRENCES, (boolean)false));
        } else {
            orPattern.addPattern(SearchEngine.createSearchPattern((String)string, (ICSearchConstants.SearchFor)ICSearchConstants.UNKNOWN_SEARCH_FOR, (ICSearchConstants.LimitTo)ICSearchConstants.DECLARATIONS, (boolean)false));
        }
        return orPattern;
    }

    private RefactoringStatus checkEnclosedElements() throws CoreException {
        ICElement iCElement = RenameElementProcessor.findEnclosedElements(this.fCElement, this.fNewElementName);
        if (iCElement == null) {
            return null;
        }
        String string = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.encloses", new String[]{this.fCElement.getElementName(), this.fNewElementName});
        return RefactoringStatus.createErrorStatus(string);
    }

    private RefactoringStatus checkEnclosingElements() throws CoreException {
        ICElement iCElement = RenameElementProcessor.findEnclosingElements(this.fCElement, this.fNewElementName);
        if (iCElement == null) {
            return null;
        }
        String string = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed", new String[]{this.fCElement.getElementName(), this.fNewElementName});
        return RefactoringStatus.createErrorStatus(string);
    }

    private static ICElement findEnclosedElements(ICElement iCElement, String string) throws CoreException {
        if (iCElement instanceof IParent) {
            ICElement[] iCElementArray = ((IParent)iCElement).getChildren();
            int n = 0;
            while (n < iCElementArray.length) {
                if (string.equals(iCElementArray[n].getElementName()) || RenameElementProcessor.findEnclosedElements(iCElementArray[n], string) != null) {
                    return iCElementArray[n];
                }
                ++n;
            }
        }
        return null;
    }

    private static ICElement findEnclosingElements(ICElement iCElement, String string) {
        ICElement iCElement2 = iCElement.getParent();
        while (iCElement2 != null && !(iCElement2 instanceof ITranslationUnit)) {
            if (string.equals(iCElement2.getElementName())) {
                return iCElement2;
            }
            iCElement2 = iCElement2.getParent();
        }
        return null;
    }

    private boolean isTopLevelStructure(ICElement iCElement) {
        if (iCElement instanceof IStructure) {
            ICElement iCElement2 = iCElement.getParent();
            while (!(iCElement2 instanceof ITranslationUnit)) {
                if (iCElement2 instanceof IStructure) {
                    return false;
                }
                iCElement2 = iCElement2.getParent();
            }
            return true;
        }
        return false;
    }

    private ICElement[] getSiblings(ICElement iCElement, boolean bl) throws CModelException {
        if (bl || !this.isTopLevelStructure(iCElement)) {
            ICElement[] iCElementArray = ((IParent)this.fCElement.getParent()).getChildren();
            return iCElementArray;
        }
        new HashSet();
        ICElement iCElement2 = iCElement.getParent();
        int n = 1;
        boolean bl2 = false;
        while (!bl2) {
            if (iCElement2 instanceof ICContainer) {
                bl2 = true;
                break;
            }
            iCElement2 = iCElement2.getParent();
            ++n;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<ICElement> hashSet2 = new HashSet<ICElement>();
        ICElement[] iCElementArray = ((IParent)iCElement2).getChildren();
        int n2 = 0;
        while (n2 < iCElementArray.length) {
            if (!(iCElementArray[n2] instanceof ICContainer)) {
                hashSet.add(iCElementArray[n2]);
            }
            ++n2;
        }
        n2 = 1;
        while (n2 < n) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ICElement iCElement3;
                Object e = iterator.next();
                if (!(e instanceof ISourceManipulation) || !((iCElement3 = (ICElement)e) instanceof IParent)) continue;
                ICElement[] iCElementArray2 = ((IParent)iCElement3).getChildren();
                int n3 = 0;
                while (n3 < iCElementArray2.length) {
                    hashSet2.add(iCElementArray2[n3]);
                    ++n3;
                }
            }
            if (++n2 >= n) continue;
            hashSet.clear();
            hashSet.addAll(hashSet2);
            hashSet2.clear();
        }
        return hashSet2.toArray(new ICElement[hashSet2.size()]);
    }

    private RefactoringStatus checkSiblingsCollision(boolean bl) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        try {
            ICElement[] iCElementArray = this.getSiblings(this.fCElement, bl);
            int n = 0;
            while (n < iCElementArray.length) {
                ICElement iCElement = iCElementArray[n];
                if (iCElement.getElementName().equals(this.fNewElementName) && iCElement.getElementType() == this.fCElement.getElementType()) {
                    String string;
                    if (bl) {
                        string = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
                        refactoringStatus.addFatalError(string);
                    } else {
                        string = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.global_member_type_exists", new String[]{this.fNewElementName, this.fCElement.getParent().getElementName()});
                        refactoringStatus.addFatalError(string);
                    }
                }
                ++n;
            }
        }
        catch (CModelException cModelException) {
            refactoringStatus.addFatalError(cModelException.getMessage());
        }
        return refactoringStatus;
    }

    private RefactoringStatus analyzeAffectedTranslationUnits() throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fReferences = Checks.excludeTranslationUnits(this.fReferences, refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        return refactoringStatus;
    }

    private boolean isConstructorOrDestructor(IFunctionDeclaration iFunctionDeclaration) throws CModelException {
        Object object;
        if (iFunctionDeclaration instanceof IMethodDeclaration && ((object = (IMethodDeclaration)iFunctionDeclaration).isConstructor() || object.isDestructor())) {
            return true;
        }
        object = iFunctionDeclaration.getReturnType();
        if (object == null || ((String)object).length() == 0) {
            return true;
        }
        return this.getCurrentElementName().startsWith("~");
    }

    private boolean eligibleForRefactoring(ICElement iCElement) throws CModelException {
        if (iCElement == null || !(iCElement instanceof ISourceReference) || iCElement instanceof ITranslationUnit || iCElement instanceof IMacro || iCElement instanceof IInclude) {
            return false;
        }
        if (iCElement instanceof IFunctionDeclaration) {
            IFunctionDeclaration iFunctionDeclaration = (IFunctionDeclaration)iCElement;
            return !this.isConstructorOrDestructor(iFunctionDeclaration);
        }
        return true;
    }
}

