/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.cdt.internal.corext.template.ITemplateEditor;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateContext;
import org.eclipse.cdt.internal.corext.template.TemplatePosition;
import org.eclipse.cdt.internal.corext.template.TemplateVariable;
import org.eclipse.cdt.internal.corext.template.Templates;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.NopTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.SimpleTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBufferEditor;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.core.runtime.CoreException;

public abstract class ContextType
implements ITemplateEditor {
    private final String fName;
    private final Map fVariables = new HashMap();

    public ContextType(String string) {
        this.fName = string;
    }

    public String getName() {
        return this.fName;
    }

    public void addVariable(TemplateVariable templateVariable) {
        this.fVariables.put(templateVariable.getName(), templateVariable);
    }

    public void removeVariable(TemplateVariable templateVariable) {
        this.fVariables.remove(templateVariable.getName());
    }

    public void removeAllVariables() {
        this.fVariables.clear();
    }

    public Iterator variableIterator() {
        return this.fVariables.values().iterator();
    }

    public abstract TemplateContext createContext();

    public void edit(TemplateBuffer templateBuffer, TemplateContext templateContext) throws CoreException {
        TextBuffer textBuffer = TextBuffer.create(templateBuffer.getString());
        TemplatePosition[] templatePositionArray = templateBuffer.getVariables();
        MultiTextEdit multiTextEdit = ContextType.variablesToPositions(templatePositionArray);
        MultiTextEdit multiTextEdit2 = new MultiTextEdit();
        int n = 0;
        while (n != templatePositionArray.length) {
            TemplatePosition templatePosition = templatePositionArray[n];
            if (!templatePosition.isResolved()) {
                String string;
                String string2 = templatePosition.getName();
                int[] nArray = templatePosition.getOffsets();
                int n2 = templatePosition.getLength();
                TemplateVariable templateVariable = (TemplateVariable)this.fVariables.get(string2);
                String string3 = string = templateVariable == null ? null : templateVariable.evaluate(templateContext);
                if (string != null) {
                    templatePosition.setLength(string.length());
                    templatePosition.setResolved(templateVariable.isResolved(templateContext));
                    int n3 = 0;
                    while (n3 != nArray.length) {
                        multiTextEdit2.add(SimpleTextEdit.createReplace(nArray[n3], n2, string));
                        ++n3;
                    }
                }
            }
            ++n;
        }
        TextBufferEditor textBufferEditor = new TextBufferEditor(textBuffer);
        textBufferEditor.add(multiTextEdit);
        textBufferEditor.add(multiTextEdit2);
        textBufferEditor.performEdits(null);
        ContextType.positionsToVariables(multiTextEdit, templatePositionArray);
        templateBuffer.setContent(textBuffer.getContent(), templatePositionArray);
    }

    private static MultiTextEdit variablesToPositions(TemplatePosition[] templatePositionArray) {
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        int n = 0;
        while (n != templatePositionArray.length) {
            int[] nArray = templatePositionArray[n].getOffsets();
            int n2 = 0;
            while (n2 != nArray.length) {
                multiTextEdit.add(new NopTextEdit(nArray[n2], 0));
                ++n2;
            }
            ++n;
        }
        return multiTextEdit;
    }

    private static void positionsToVariables(MultiTextEdit multiTextEdit, TemplatePosition[] templatePositionArray) {
        Iterator iterator = multiTextEdit.iterator();
        int n = 0;
        while (n != templatePositionArray.length) {
            TemplatePosition templatePosition = templatePositionArray[n];
            int[] nArray = new int[templatePosition.getOffsets().length];
            int n2 = 0;
            while (n2 != nArray.length) {
                nArray[n2] = ((TextEdit)iterator.next()).getTextRange().getOffset();
                ++n2;
            }
            templatePosition.setOffsets(nArray);
            ++n;
        }
    }

    public Template[] getTemplates() {
        Template[] templateArray = Templates.getInstance().getTemplates();
        Vector<Template> vector = new Vector<Template>();
        int n = 0;
        while (n != templateArray.length) {
            if (templateArray[n].getContextTypeName().equals(this.fName)) {
                vector.add(templateArray[n]);
            }
            ++n;
        }
        return vector.toArray(new Template[vector.size()]);
    }
}

