/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateMessages;
import org.eclipse.cdt.internal.ui.CUIException;
import org.eclipse.cdt.internal.ui.CUIStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String TEMPLATE_TAG = "template";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private List fTemplates = new ArrayList();
    private Comparator fTemplateComparator = new TemplateComparator();
    private Template[] fSortedTemplates = new Template[0];

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFromFile(File file) throws CoreException {
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                this.addFromStream(fileInputStream);
            }
            catch (IOException iOException) {
                TemplateSet.throwReadException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fileInputStream == null) throw throwable;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileInputStream == null) return;
        ((InputStream)fileInputStream).close();
    }

    public void addFromStream(InputStream inputStream) throws CoreException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(inputStream));
            NodeList nodeList = document.getElementsByTagName(TEMPLATE_TAG);
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    Object object;
                    String string = this.getAttributeValue(namedNodeMap, NAME_ATTRIBUTE);
                    String string2 = this.getAttributeValue(namedNodeMap, DESCRIPTION_ATTRIBUTE);
                    String string3 = this.getAttributeValue(namedNodeMap, CONTEXT_ATTRIBUTE);
                    Node node2 = namedNodeMap.getNamedItem(ENABLED_ATTRIBUTE);
                    if (string == null || string2 == null || string3 == null) {
                        throw new SAXException(TemplateMessages.getString("TemplateSet.error.missingAttribute"));
                    }
                    boolean bl = node2 == null || node2.getNodeValue().equals("true");
                    StringBuffer stringBuffer = new StringBuffer();
                    NodeList nodeList2 = node.getChildNodes();
                    int n3 = 0;
                    while (n3 != nodeList2.getLength()) {
                        object = nodeList2.item(n3).getNodeValue();
                        if (object != null) {
                            stringBuffer.append((String)object);
                        }
                        ++n3;
                    }
                    String string4 = stringBuffer.toString().trim();
                    object = new Template(string, string2, string3, string4);
                    ((Template)object).setEnabled(bl);
                    this.add((Template)object);
                }
                ++n2;
            }
            this.sort();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TemplateSet.throwReadException(parserConfigurationException);
        }
        catch (IOException iOException) {
            TemplateSet.throwReadException(iOException);
        }
        catch (SAXException sAXException) {
            TemplateSet.throwReadException(sAXException);
        }
    }

    private String getAttributeValue(NamedNodeMap namedNodeMap, String string) {
        Node node = namedNodeMap.getNamedItem(string);
        return node == null ? null : node.getNodeValue();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile(File file) throws CoreException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                this.saveToStream(fileOutputStream);
            }
            catch (IOException iOException) {
                TemplateSet.throwWriteException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (fileOutputStream == null) throw throwable;
                ((OutputStream)fileOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (fileOutputStream == null) return;
        ((OutputStream)fileOutputStream).close();
    }

    public void saveToStream(OutputStream outputStream) throws CoreException {
        try {
            Object object;
            Object object2;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("templates");
            document.appendChild(element);
            int n = 0;
            while (n != this.fTemplates.size()) {
                object2 = (Template)this.fTemplates.get(n);
                object = document.createElement(TEMPLATE_TAG);
                element.appendChild((Node)object);
                NamedNodeMap namedNodeMap = object.getAttributes();
                Attr attr = document.createAttribute(NAME_ATTRIBUTE);
                attr.setValue(((Template)object2).getName());
                namedNodeMap.setNamedItem(attr);
                Attr attr2 = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                attr2.setValue(((Template)object2).getDescription());
                namedNodeMap.setNamedItem(attr2);
                Attr attr3 = document.createAttribute(CONTEXT_ATTRIBUTE);
                attr3.setValue(((Template)object2).getContextTypeName());
                namedNodeMap.setNamedItem(attr3);
                Attr attr4 = document.createAttribute(ENABLED_ATTRIBUTE);
                attr4.setValue(((Template)object2).isEnabled() ? "true" : "false");
                namedNodeMap.setNamedItem(attr4);
                Text text = document.createTextNode(((Template)object2).getPattern());
                object.appendChild(text);
                ++n;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            object2 = new DOMSource(document);
            object = new StreamResult(outputStream);
            transformer.transform((Source)object2, (Result)object);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            TemplateSet.throwWriteException(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            TemplateSet.throwWriteException(transformerException);
        }
    }

    private static void throwReadException(Throwable throwable) throws CoreException {
        CUIStatus cUIStatus = new CUIStatus(2, TemplateMessages.getString("TemplateSet.error.read"), throwable);
        throw new CUIException((IStatus)cUIStatus);
    }

    private static void throwWriteException(Throwable throwable) throws CoreException {
        CUIStatus cUIStatus = new CUIStatus(2, TemplateMessages.getString("TemplateSet.error.write"), throwable);
        throw new CUIException((IStatus)cUIStatus);
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
        this.sort();
    }

    private boolean exists(Template template) {
        Iterator iterator = this.fTemplates.iterator();
        while (iterator.hasNext()) {
            Template template2 = (Template)iterator.next();
            if (!template.equals(template2)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
        this.sort();
    }

    public void clear() {
        this.fTemplates.clear();
        this.sort();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    private void sort() {
        this.fSortedTemplates = this.fTemplates.toArray(new Template[this.fTemplates.size()]);
        Arrays.sort(this.fSortedTemplates, this.fTemplateComparator);
    }

    private static class TemplateComparator
    implements Comparator {
        TemplateComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            Template template = (Template)object;
            Template template2 = (Template)object2;
            return template.getName().compareTo(template2.getName());
        }
    }
}

