/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.template.c;

import org.eclipse.cdt.internal.corext.template.ContextType;
import org.eclipse.cdt.internal.corext.template.Template;
import org.eclipse.cdt.internal.corext.template.TemplateBuffer;
import org.eclipse.cdt.internal.corext.template.TemplateTranslator;
import org.eclipse.cdt.internal.corext.template.c.CFormatter;
import org.eclipse.cdt.internal.corext.template.c.CompilationUnitContext;
import org.eclipse.cdt.internal.corext.template.c.ICompilationUnit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.CoreException;

public class CContext
extends CompilationUnitContext {
    public CContext(ContextType contextType, String string, int n, ICompilationUnit iCompilationUnit) {
        super(contextType, string, n, iCompilationUnit);
    }

    public int getStart() {
        String string = this.getString();
        int n = this.getCompletionPosition();
        while (n != 0 && Character.isUnicodeIdentifierPart(string.charAt(n - 1))) {
            --n;
        }
        if (n != 0 && Character.isUnicodeIdentifierStart(string.charAt(n - 1))) {
            --n;
        }
        return n;
    }

    public int getIndentationLevel() {
        String string = this.getString();
        int n = this.getStart();
        try {
            TextBuffer textBuffer = TextBuffer.create(string);
            String string2 = textBuffer.getLineContentOfOffset(n);
            return TextUtil.getIndent(string2, CUIPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.cdt.editor.tab.width"));
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public boolean canEvaluate(Template template) {
        return template.matches(this.getKey(), this.getContextType().getName());
    }

    public TemplateBuffer evaluate(Template template) throws CoreException {
        if (!this.canEvaluate(template)) {
            return null;
        }
        TemplateTranslator templateTranslator = new TemplateTranslator();
        TemplateBuffer templateBuffer = templateTranslator.translate(template.getPattern());
        this.getContextType().edit(templateBuffer, this);
        CFormatter cFormatter = new CFormatter();
        cFormatter.edit(templateBuffer, this);
        return templateBuffer;
    }
}

