/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.corext.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.edits.TextEdit;

public class GroupDescription {
    private String fDescription;
    private List fEdits;

    public GroupDescription() {
        this("NO_DESCRIPTION");
    }

    public GroupDescription(String string) {
        Assert.isNotNull(string);
        this.fDescription = string;
        this.fEdits = new ArrayList(3);
    }

    public GroupDescription(String string, TextEdit[] textEditArray) {
        Assert.isNotNull(string);
        Assert.isNotNull(textEditArray);
        this.fDescription = string;
        this.fEdits = new ArrayList<TextEdit>(Arrays.asList(textEditArray));
    }

    public void addTextEdit(TextEdit textEdit) {
        this.fEdits.add(textEdit);
    }

    public boolean hasTextEdits() {
        return this.fEdits.isEmpty();
    }

    public TextEdit[] getTextEdits() {
        return this.fEdits.toArray(new TextEdit[this.fEdits.size()]);
    }

    public IRegion getTextRange() {
        int n = this.fEdits.size();
        if (n == 1) {
            return ((TextEdit)this.fEdits.get(0)).getRegion();
        }
        return TextEdit.getCoverage((TextEdit[])this.fEdits.toArray(new TextEdit[this.fEdits.size()]));
    }

    public String getName() {
        return this.fDescription;
    }
}

