/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;

public abstract class SimpleTextEdit
extends TextEdit {
    private TextRange fRange;
    private String fText;

    public static SimpleTextEdit createReplace(int n, int n2, String string) {
        return new SimpleTextEditImpl(n, n2, string);
    }

    public static SimpleTextEdit createInsert(int n, String string) {
        return new SimpleTextEditImpl(n, 0, string);
    }

    public static SimpleTextEdit createDelete(int n, int n2) {
        return new SimpleTextEditImpl(n, n2, "");
    }

    protected SimpleTextEdit() {
        this(TextRange.UNDEFINED, "");
    }

    protected SimpleTextEdit(int n, int n2, String string) {
        this(new TextRange(n, n2), string);
    }

    protected SimpleTextEdit(TextRange textRange, String string) {
        Assert.isNotNull((Object)textRange);
        Assert.isNotNull((Object)string);
        this.fRange = textRange;
        this.fText = string;
    }

    public String getText() {
        return this.fText;
    }

    protected final void setText(String string) {
        this.fText = string;
        Assert.isNotNull((Object)this.fText);
    }

    protected void setTextRange(TextRange textRange) {
        this.fRange = textRange;
        Assert.isNotNull((Object)this.fRange);
    }

    public TextRange getTextRange() {
        return this.fRange;
    }

    public final TextEdit perform(TextBuffer textBuffer) throws CoreException {
        String string = textBuffer.getContent(this.fRange.fOffset, this.fRange.fLength);
        textBuffer.replace(this.fRange, this.fText);
        return new SimpleTextEditImpl(this.fRange, string);
    }

    private static final class SimpleTextEditImpl
    extends SimpleTextEdit {
        protected SimpleTextEditImpl(TextRange textRange, String string) {
            super(textRange, string);
        }

        protected SimpleTextEditImpl(int n, int n2, String string) {
            super(n, n2, string);
        }

        public TextEdit copy() {
            return new SimpleTextEditImpl(this.getTextRange().copy(), this.getText());
        }
    }
}

