/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.corext.textmanipulation.MultiTextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEdit;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEditNode;
import org.eclipse.cdt.internal.corext.textmanipulation.TextEditNodeComparator;
import org.eclipse.cdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.cdt.internal.corext.textmanipulation.UndoMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Assert;

public class TextBufferEditor {
    private TextBuffer fBuffer;
    private List fEdits;
    private TextEditNode.RootNode fRootNode;
    private int fNumberOfNodes;
    private int fConnectCount;
    private int fMode;
    static final int UNDEFINED = 0;
    static final int REDO = 1;
    static final int UNDO = 2;

    public TextBufferEditor(TextBuffer textBuffer) {
        this.fBuffer = textBuffer;
        Assert.isNotNull((Object)this.fBuffer);
        this.fEdits = new ArrayList();
    }

    public TextBuffer getTextBuffer() {
        return this.fBuffer;
    }

    public void add(TextEdit textEdit) throws CoreException {
        Assert.isTrue((this.fMode == 0 || this.fMode == 1 ? 1 : 0) != 0);
        this.internalAdd(textEdit);
        this.fMode = 1;
    }

    public void add(MultiTextEdit multiTextEdit) throws CoreException {
        Assert.isTrue((this.fMode == 0 || this.fMode == 1 ? 1 : 0) != 0);
        multiTextEdit.connect(this);
        this.fMode = 1;
    }

    public void add(UndoMemento undoMemento) throws CoreException {
        Assert.isTrue((this.fMode == 0 ? 1 : 0) != 0);
        List list = undoMemento.fEdits;
        int n = list.size() - 1;
        while (n >= 0) {
            this.internalAdd((TextEdit)list.get(n));
            --n;
        }
        this.fMode = undoMemento.fMode;
    }

    public boolean canPerformEdits() {
        if (this.fRootNode != null) {
            return true;
        }
        this.fRootNode = this.buildTree();
        if (this.fRootNode == null) {
            return false;
        }
        if (this.fRootNode.validate(this.fBuffer.getLength())) {
            return true;
        }
        this.fRootNode = null;
        return false;
    }

    public void clear() {
        this.fRootNode = null;
        this.fMode = 0;
        this.fEdits.clear();
    }

    public UndoMemento performEdits(IProgressMonitor iProgressMonitor) throws CoreException {
        UndoMemento undoMemento;
        int n;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if ((n = this.fEdits.size()) == 0) {
            return new UndoMemento(this.fMode == 2 ? 1 : 2);
        }
        if (this.fRootNode == null) {
            this.fRootNode = this.buildTree();
            if (this.fRootNode == null || !this.fRootNode.validate(this.fBuffer.getLength())) {
                Status status = new Status(4, "org.eclipse.cdt.ui", 1, TextManipulationMessages.getString("TextBufferEditor.rootNodeEmpty"), null);
                throw new CoreException((IStatus)status);
            }
        }
        try {
            iProgressMonitor.beginTask("", this.fNumberOfNodes + 10);
            UndoMemento undoMemento2 = null;
            if (this.fMode == 1) {
                undoMemento2 = this.fRootNode.performDo(this.fBuffer, iProgressMonitor);
                this.fRootNode.performedDo();
            } else {
                undoMemento2 = this.fRootNode.performUndo(this.fBuffer, iProgressMonitor);
                this.fRootNode.performedUndo();
            }
            iProgressMonitor.worked(10);
            undoMemento = undoMemento2;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            iProgressMonitor.done();
            this.clear();
            throw throwable;
        }
        iProgressMonitor.done();
        this.clear();
        return undoMemento;
    }

    private TextEditNode.RootNode buildTree() {
        TextEditNode[] textEditNodeArray = new TextEditNode[this.fEdits.size()];
        int n = this.fEdits.size() - 1;
        while (n >= 0) {
            textEditNodeArray[n] = TextEditNode.create((TextEdit)this.fEdits.get(n));
            --n;
        }
        this.fNumberOfNodes = textEditNodeArray.length;
        Arrays.sort(textEditNodeArray, new TextEditNodeComparator());
        TextEditNode.RootNode rootNode = new TextEditNode.RootNode(this.fBuffer.getLength());
        int n2 = 0;
        while (n2 < textEditNodeArray.length) {
            rootNode.add(textEditNodeArray[n2]);
            ++n2;
        }
        return rootNode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void internalAdd(TextEdit textEdit) throws CoreException {
        textEdit.index = this.fEdits.size();
        textEdit.isSynthetic = this.fConnectCount > 0;
        try {
            ++this.fConnectCount;
            textEdit.connect(this);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            --this.fConnectCount;
            throw throwable;
        }
        {
            Object var2_4 = null;
            --this.fConnectCount;
            this.fEdits.add(textEdit);
        }
    }
}

