/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.corext.textmanipulation.TextBuffer;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

class TextBufferFactory {
    protected IDocumentProvider fDocumentProvider;
    private Map fFileValueMap;
    private Map fBufferValueMap;

    public TextBufferFactory() {
        this((IDocumentProvider)CUIPlugin.getDefault().getDocumentProvider());
    }

    public TextBufferFactory(IDocumentProvider iDocumentProvider) {
        this.fDocumentProvider = iDocumentProvider;
        Assert.isNotNull((Object)this.fDocumentProvider);
        this.fFileValueMap = new HashMap(5);
        this.fBufferValueMap = new HashMap(5);
    }

    public TextBuffer acquire(IFile iFile) throws CoreException {
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        Value value = (Value)this.fFileValueMap.get(fileEditorInput);
        if (value != null) {
            ++value.references;
            return value.buffer;
        }
        this.fDocumentProvider.connect((Object)fileEditorInput);
        IDocument iDocument = this.fDocumentProvider.getDocument((Object)fileEditorInput);
        IAnnotationModel iAnnotationModel = this.fDocumentProvider.getAnnotationModel((Object)fileEditorInput);
        iAnnotationModel.connect(iDocument);
        value = new Value(new TextBuffer(iDocument), fileEditorInput, iDocument, iAnnotationModel);
        this.fFileValueMap.put(fileEditorInput, value);
        this.fBufferValueMap.put(value.buffer, value);
        ++value.references;
        return value.buffer;
    }

    public void release(TextBuffer textBuffer) {
        Value value = (Value)this.fBufferValueMap.get(textBuffer);
        if (value == null) {
            return;
        }
        --value.references;
        if (value.references == 0) {
            textBuffer.release();
            value.annotationModel.disconnect(value.document);
            this.fDocumentProvider.disconnect((Object)value.input);
            this.fFileValueMap.remove(value.input);
            this.fBufferValueMap.remove(textBuffer);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commitChanges(TextBuffer textBuffer, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        final Value value = (Value)this.fBufferValueMap.get(textBuffer);
        if (value == null) {
            return;
        }
        boolean bl2 = bl || this.fDocumentProvider.mustSaveDocument((Object)value.input);
        if (!bl2) return;
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                TextBufferFactory.this.fDocumentProvider.aboutToChange((Object)value.input);
                TextBufferFactory.this.fDocumentProvider.saveDocument(iProgressMonitor, (Object)value.input, value.document, true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, iProgressMonitor);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fDocumentProvider.changed((Object)value.input);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.fDocumentProvider.changed((Object)value.input);
    }

    public TextBuffer create(IFile iFile) throws CoreException {
        FileEditorInput fileEditorInput = new FileEditorInput(iFile);
        IDocument iDocument = this.fDocumentProvider.getDocument((Object)fileEditorInput);
        if (iDocument != null) {
            return new TextBuffer((IDocument)new Document(iDocument.get()));
        }
        return this.createFromFile(iFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextBuffer createFromFile(IFile iFile) throws CoreException {
        TextBuffer textBuffer;
        InputStreamReader inputStreamReader = null;
        try {
            try {
                Document document = new Document();
                inputStreamReader = new InputStreamReader(new BufferedInputStream(iFile.getContents()));
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[2048];
                int n = inputStreamReader.read(cArray);
                while (true) {
                    if (n <= 0) {
                        document.set(stringBuffer.toString());
                        textBuffer = new TextBuffer((IDocument)document);
                        Object var7_10 = null;
                        if (inputStreamReader == null) return textBuffer;
                        break;
                    }
                    stringBuffer.append(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
            }
            catch (IOException iOException) {
                Status status = new Status(4, "org.eclipse.cdt.ui", 1, iOException.getMessage(), (Throwable)iOException);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (inputStreamReader == null) throw throwable;
            try {
                inputStreamReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw throwable;
            }
        }
        try {}
        catch (IOException iOException) {}
        inputStreamReader.close();
        return textBuffer;
    }

    public TextBuffer create(String string) throws CoreException {
        return new TextBuffer((IDocument)new Document(string));
    }

    public void save(TextBuffer textBuffer, IProgressMonitor iProgressMonitor) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(textBuffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.saveDocument(iProgressMonitor, (Object)value.input, value.document, true);
    }

    public void aboutToChange(TextBuffer textBuffer) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(textBuffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.aboutToChange((Object)value.input);
    }

    public void changed(TextBuffer textBuffer) throws CoreException {
        Value value = (Value)this.fBufferValueMap.get(textBuffer);
        if (value == null) {
            this.throwNotManaged();
        }
        this.fDocumentProvider.changed((Object)value.input);
    }

    private void throwNotManaged() throws CoreException {
        Status status = new Status(4, "org.eclipse.cdt.ui", 1, "TextBufferFactory.bufferNotManaged", null);
        throw new CoreException((IStatus)status);
    }

    private static class Value {
        TextBuffer buffer;
        FileEditorInput input;
        IDocument document;
        IAnnotationModel annotationModel;
        int references;

        public Value(TextBuffer textBuffer, FileEditorInput fileEditorInput, IDocument iDocument, IAnnotationModel iAnnotationModel) {
            this.buffer = textBuffer;
            this.input = fileEditorInput;
            this.document = iDocument;
            this.annotationModel = iAnnotationModel;
        }
    }
}

