/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.textmanipulation;

import org.eclipse.cdt.internal.corext.textmanipulation.ISourceRange;
import org.eclipse.cdt.internal.corext.textmanipulation.TextManipulationMessages;
import org.eclipse.jface.util.Assert;

public final class TextRange {
    int fOffset;
    int fLength;
    public static final TextRange UNDEFINED = new TextRange(null);

    public TextRange(int n) {
        this(n, 0);
    }

    public TextRange(int n, int n2) {
        this.fOffset = n;
        Assert.isTrue((this.fOffset >= 0 ? 1 : 0) != 0);
        this.fLength = n2;
        Assert.isTrue((this.fLength >= 0 ? 1 : 0) != 0);
    }

    private TextRange(TextRange textRange) {
        this.fOffset = -1;
        this.fLength = -1;
    }

    public static TextRange createFromStartAndLength(int n, int n2) {
        return new TextRange(n, n2);
    }

    public static TextRange createFromStartAndInclusiveEnd(int n, int n2) {
        return new TextRange(n, n2 - n + 1);
    }

    public static TextRange createFromStartAndExclusiveEnd(int n, int n2) {
        return new TextRange(n, n2 - n);
    }

    public TextRange(ISourceRange iSourceRange) {
        this(iSourceRange.getOffset(), iSourceRange.getLength());
    }

    public int getOffset() {
        return this.fOffset;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getInclusiveEnd() {
        return this.fOffset + this.fLength - 1;
    }

    public int getExclusiveEnd() {
        return this.fOffset + this.fLength;
    }

    public TextRange copy() {
        if (this.isUndefined()) {
            return this;
        }
        return new TextRange(this.fOffset, this.fLength);
    }

    public boolean isUndefined() {
        return UNDEFINED == this;
    }

    public boolean isValid() {
        return this.fOffset >= 0 && this.fLength >= 0;
    }

    boolean isInsertionPoint() {
        return this.fLength == 0;
    }

    boolean equals(TextRange textRange) {
        return this.fOffset == textRange.fOffset && this.fLength == textRange.fLength;
    }

    boolean isEqualInsertionPoint(TextRange textRange) {
        return this.fLength == 0 && textRange.fLength == 0 && this.fOffset == textRange.fOffset;
    }

    boolean liesBehind(TextRange textRange) {
        return this.fOffset >= textRange.fOffset + textRange.fLength;
    }

    boolean isInsertionPointAt(int n) {
        return this.fOffset == n && this.fLength == 0;
    }

    boolean covers(TextRange textRange) {
        if (this.fLength == 0) {
            return false;
        }
        if (textRange.fLength == 0) {
            int n = textRange.fOffset;
            return this.fOffset < n && n < this.fOffset + this.fLength;
        }
        int n = textRange.fOffset;
        return this.fOffset <= n && n + textRange.fLength <= this.fOffset + this.fLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextManipulationMessages.getString("TextRange.offset"));
        stringBuffer.append(this.fOffset);
        stringBuffer.append(TextManipulationMessages.getString("TextRange.length"));
        stringBuffer.append(this.fLength);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TextRange)) {
            return false;
        }
        TextRange textRange = (TextRange)object;
        return this.fOffset == textRange.getOffset() && this.fLength == textRange.getLength();
    }

    public int hashCode() {
        return this.fOffset ^ this.fLength;
    }
}

