/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IArchiveContainer;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryContainer;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class BaseCElementContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected boolean fProvideMembers = false;
    protected boolean fProvideWorkingCopy = false;

    public BaseCElementContentProvider() {
    }

    public BaseCElementContentProvider(boolean bl, boolean bl2) {
        this.fProvideMembers = bl;
        this.fProvideWorkingCopy = bl2;
    }

    public boolean getProvideMembers() {
        return this.fProvideMembers;
    }

    public void setProvideMembers(boolean bl) {
        this.fProvideMembers = bl;
    }

    public void setProvideWorkingCopy(boolean bl) {
        this.fProvideWorkingCopy = bl;
    }

    public boolean getProvideWorkingCopy() {
        return this.fProvideWorkingCopy;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    public void dispose() {
    }

    public Object[] getChildren(Object object) {
        if (!this.exists(object)) {
            return NO_CHILDREN;
        }
        try {
            if (object instanceof ICModel) {
                return this.getCProjects((ICModel)object);
            }
            if (object instanceof ICProject) {
                return this.getSourceRoots((ICProject)object);
            }
            if (object instanceof ICContainer) {
                return this.getCResources((ICContainer)object);
            }
            if (object instanceof IBinaryContainer) {
                return NO_CHILDREN;
            }
            if (object instanceof IArchiveContainer) {
                return NO_CHILDREN;
            }
            if (object instanceof ITranslationUnit) {
                if (this.fProvideMembers) {
                    ITranslationUnit iTranslationUnit;
                    IWorkingCopy iWorkingCopy;
                    if (this.fProvideWorkingCopy && !(object instanceof IWorkingCopy) && (iWorkingCopy = (iTranslationUnit = (ITranslationUnit)object).findSharedWorkingCopy(CUIPlugin.getDefault().getBufferFactory())) != null) {
                        return iWorkingCopy.getChildren();
                    }
                    return ((IParent)object).getChildren();
                }
            } else {
                if (object instanceof IParent) {
                    return ((IParent)object).getChildren();
                }
                if (object instanceof IProject) {
                    return this.getResources((IProject)object);
                }
                if (object instanceof IFolder) {
                    return this.getResources((IFolder)object);
                }
            }
        }
        catch (CModelException cModelException) {
            return NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren(Object object) {
        if (this.fProvideMembers) {
            if (object instanceof IBinary || object instanceof ITranslationUnit || object instanceof IArchive) {
                return true;
            }
        } else if (object instanceof ITranslationUnit || object instanceof IBinary || object instanceof IArchive || object instanceof IFile) {
            return false;
        }
        if (object instanceof ICProject) {
            ICProject iCProject = (ICProject)object;
            return iCProject.getProject().isOpen();
        }
        if (object instanceof IBinaryContainer) {
            try {
                IBinaryContainer iBinaryContainer = (IBinaryContainer)object;
                IBinary[] iBinaryArray = this.getExecutables(iBinaryContainer);
                return iBinaryArray != null && iBinaryArray.length > 0;
            }
            catch (CModelException cModelException) {
                return false;
            }
        }
        if (object instanceof IParent && ((IParent)object).hasChildren()) {
            return true;
        }
        Object[] objectArray = this.getChildren(object);
        return objectArray != null && objectArray.length > 0;
    }

    public Object getParent(Object object) {
        if (!this.exists(object)) {
            return null;
        }
        return this.internalGetParent(object);
    }

    public Object internalGetParent(Object object) {
        IResource iResource;
        if (object instanceof IResource) {
            ICElement iCElement;
            IContainer iContainer = ((IResource)object).getParent();
            if (iContainer != null && iContainer.isAccessible() && (iCElement = CoreModel.getDefault().create((IResource)iContainer)) != null && iCElement.exists()) {
                return iCElement;
            }
            return iContainer;
        }
        Object object2 = null;
        if (object instanceof ICElement) {
            object2 = ((ICElement)object).getParent();
        }
        if (object2 instanceof ISourceRoot) {
            if (this.isProjectSourceRoot((ISourceRoot)object2)) {
                object2 = ((ISourceRoot)object2).getCProject();
            }
        } else if ((object2 instanceof IBinaryContainer || object2 instanceof IArchiveContainer) && object instanceof ICElement && (iResource = ((ICElement)object).getResource()) != null) {
            object2 = this.internalGetParent(iResource);
        }
        return object2;
    }

    protected Object[] getCProjects(ICModel iCModel) throws CModelException {
        Object[] objectArray = iCModel.getCProjects();
        try {
            Object[] objectArray2 = iCModel.getNonCResources();
            if (objectArray2.length > 0) {
                objectArray = BaseCElementContentProvider.concatenate(objectArray, objectArray2);
            }
        }
        catch (CModelException cModelException) {}
        return objectArray;
    }

    protected Object[] getSourceRoots(ICProject iCProject) throws CModelException {
        Object[] objectArray;
        if (!iCProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ISourceRoot[] iSourceRootArray = iCProject.getSourceRoots();
        int n = 0;
        while (n < iSourceRootArray.length) {
            objectArray = iSourceRootArray[n];
            if (this.isProjectSourceRoot((ISourceRoot)objectArray)) {
                ICElement[] iCElementArray = objectArray.getChildren();
                int n2 = 0;
                while (n2 < iCElementArray.length) {
                    arrayList.add(iCElementArray[n2]);
                    ++n2;
                }
            } else {
                arrayList.add(objectArray);
            }
            ++n;
        }
        Object[] objectArray2 = arrayList.toArray();
        objectArray = iCProject.getNonCResources();
        if (objectArray != null && objectArray.length > 0) {
            objectArray = this.filterNonCResources(objectArray, iCProject);
            objectArray2 = BaseCElementContentProvider.concatenate(objectArray2, objectArray);
        }
        return objectArray2;
    }

    protected Object[] getCResources(ICContainer iCContainer) throws CModelException {
        Object[] objectArray = null;
        Object[] objectArray2 = iCContainer.getChildren();
        try {
            objectArray = iCContainer.getNonCResources();
            if (objectArray.length > 0) {
                objectArray = this.filterNonCResources(objectArray, iCContainer.getCProject());
            }
        }
        catch (CModelException cModelException) {}
        if (objectArray == null || objectArray.length == 0) {
            return objectArray2;
        }
        return BaseCElementContentProvider.concatenate(objectArray2, objectArray);
    }

    private Object[] getResources(IProject iProject) {
        try {
            return iProject.members();
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] getResources(IFolder iFolder) throws CModelException {
        ICProject iCProject = CoreModel.getDefault().create(iFolder.getProject());
        Object[] objectArray = null;
        try {
            objectArray = iFolder.members();
        }
        catch (CoreException coreException) {}
        if (objectArray == null || objectArray.length == 0) {
            return NO_CHILDREN;
        }
        return this.filterNonCResources(objectArray, iCProject);
    }

    private Object[] filterNonCResources(Object[] objectArray, ICProject iCProject) throws CModelException {
        ICElement[] iCElementArray = null;
        ICElement[] iCElementArray2 = null;
        try {
            iCElementArray = this.getBinaries(iCProject);
            iCElementArray2 = this.getArchives(iCProject);
        }
        catch (CModelException cModelException) {
            iCElementArray2 = iCElementArray = new ICElement[0];
        }
        ISourceRoot[] iSourceRootArray = null;
        try {
            iSourceRootArray = iCProject.getSourceRoots();
        }
        catch (CModelException cModelException) {
            iSourceRootArray = new ISourceRoot[]{};
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            block15: {
                Object object;
                block14: {
                    int n2;
                    block13: {
                        object = objectArray[n];
                        if (!(object instanceof IFolder)) break block13;
                        IFolder iFolder = (IFolder)object;
                        n2 = 0;
                        int n3 = 0;
                        while (n3 < iSourceRootArray.length) {
                            if (iSourceRootArray[n3].getPath().equals((Object)iFolder.getFullPath())) {
                                n2 = 1;
                                break;
                            }
                            ++n3;
                        }
                        if (n2 == 0) break block14;
                        break block15;
                    }
                    if (object instanceof IFile) {
                        boolean bl = false;
                        n2 = 0;
                        while (n2 < iCElementArray.length) {
                            IResource iResource = iCElementArray[n2].getResource();
                            if (object.equals(iResource)) {
                                object = iCElementArray[n2];
                                bl = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!bl) {
                            n2 = 0;
                            while (n2 < iCElementArray2.length) {
                                IResource iResource = iCElementArray2[n2].getResource();
                                if (object.equals(iResource)) {
                                    object = iCElementArray2[n2];
                                    break;
                                }
                                ++n2;
                            }
                        }
                    }
                }
                arrayList.add(object);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    protected boolean isProjectSourceRoot(ISourceRoot iSourceRoot) {
        IResource iResource = iSourceRoot.getResource();
        return iResource instanceof IProject;
    }

    protected boolean exists(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof IResource) {
            return ((IResource)object).exists();
        }
        if (object instanceof ICElement) {
            return ((ICElement)object).exists();
        }
        return true;
    }

    protected IBinary[] getExecutables(ICProject iCProject) throws CModelException {
        IBinaryContainer iBinaryContainer = iCProject.getBinaryContainer();
        return this.getExecutables(iBinaryContainer);
    }

    protected IBinary[] getExecutables(IBinaryContainer iBinaryContainer) throws CModelException {
        ICElement[] iCElementArray = iBinaryContainer.getChildren();
        ArrayList<IBinary> arrayList = new ArrayList<IBinary>(iCElementArray.length);
        int n = 0;
        while (n < iCElementArray.length) {
            IBinary iBinary;
            if (iCElementArray[n] instanceof IBinary && ((iBinary = (IBinary)iCElementArray[n]).isExecutable() || iBinary.isSharedLib())) {
                arrayList.add(iBinary);
            }
            ++n;
        }
        IBinary[] iBinaryArray = new IBinary[arrayList.size()];
        arrayList.toArray(iBinaryArray);
        return iBinaryArray;
    }

    protected IBinary[] getBinaries(ICProject iCProject) throws CModelException {
        IBinaryContainer iBinaryContainer = iCProject.getBinaryContainer();
        return this.getBinaries(iBinaryContainer);
    }

    protected IBinary[] getBinaries(IBinaryContainer iBinaryContainer) throws CModelException {
        ICElement[] iCElementArray = iBinaryContainer.getChildren();
        ArrayList<IBinary> arrayList = new ArrayList<IBinary>(iCElementArray.length);
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n] instanceof IBinary) {
                IBinary iBinary = (IBinary)iCElementArray[n];
                arrayList.add(iBinary);
            }
            ++n;
        }
        IBinary[] iBinaryArray = new IBinary[arrayList.size()];
        arrayList.toArray(iBinaryArray);
        return iBinaryArray;
    }

    protected IArchive[] getArchives(ICProject iCProject) throws CModelException {
        IArchiveContainer iArchiveContainer = iCProject.getArchiveContainer();
        return this.getArchives(iArchiveContainer);
    }

    protected IArchive[] getArchives(IArchiveContainer iArchiveContainer) throws CModelException {
        ICElement[] iCElementArray = iArchiveContainer.getChildren();
        ArrayList<IArchive> arrayList = new ArrayList<IArchive>(iCElementArray.length);
        int n = 0;
        while (n < iCElementArray.length) {
            if (iCElementArray[n] instanceof IArchive) {
                IArchive iArchive = (IArchive)iCElementArray[n];
                arrayList.add(iArchive);
            }
            ++n;
        }
        IArchive[] iArchiveArray = new IArchive[arrayList.size()];
        arrayList.toArray(iArchiveArray);
        return iArchiveArray;
    }

    protected static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = new Object[n + n2];
        System.arraycopy(objectArray, 0, objectArray3, 0, n);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }
}

