/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.internal.ui.ICElementPropertyConstants;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class BinaryPropertySource
extends FilePropertySource
implements IPropertySource {
    private static final String ELF_CPU = "CElementProperties.elf_cpu";
    private static final String ELF_TEXT = "CElementProperties.elf_text";
    private static final String ELF_DATA = "CElementProperties.elf_data";
    private static final String ELF_BSS = "CElementProperties.elf_bss";
    private static final String ELF_TYPE = "CElementProperties.elf_type";
    private static final String ELF_HAS_DEBUG = "CElementProperties.elf_has_debug";
    private static final String ELF_SONAME = "CElementProperties.elf_soname";
    private static final String ELF_NEEDED = "CElementProperties.elf_needed";
    private IBinary binary;
    private static IPropertyDescriptor[] fgPropertyDescriptors;

    private static IPropertyDescriptor[] getInitialPropertyDescriptor() {
        String string = CUIPlugin.getResourceString(ELF_CPU);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor((Object)"elf_cpu", string);
        propertyDescriptor.setAlwaysIncompatible(true);
        propertyDescriptor.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string2 = CUIPlugin.getResourceString(ELF_TEXT);
        PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor((Object)"text", string2);
        propertyDescriptor2.setAlwaysIncompatible(true);
        propertyDescriptor2.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string3 = CUIPlugin.getResourceString(ELF_DATA);
        PropertyDescriptor propertyDescriptor3 = new PropertyDescriptor((Object)"data", string3);
        propertyDescriptor3.setAlwaysIncompatible(true);
        propertyDescriptor3.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string4 = CUIPlugin.getResourceString(ELF_BSS);
        PropertyDescriptor propertyDescriptor4 = new PropertyDescriptor((Object)"bss", string4);
        propertyDescriptor4.setAlwaysIncompatible(true);
        propertyDescriptor4.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string5 = CUIPlugin.getResourceString(ELF_TYPE);
        PropertyDescriptor propertyDescriptor5 = new PropertyDescriptor((Object)"type", string5);
        propertyDescriptor5.setAlwaysIncompatible(true);
        propertyDescriptor5.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string6 = CUIPlugin.getResourceString(ELF_NEEDED);
        PropertyDescriptor propertyDescriptor6 = new PropertyDescriptor((Object)"needed", string6);
        propertyDescriptor6.setAlwaysIncompatible(true);
        propertyDescriptor6.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string7 = CUIPlugin.getResourceString(ELF_SONAME);
        PropertyDescriptor propertyDescriptor7 = new PropertyDescriptor((Object)"soname", string7);
        propertyDescriptor7.setAlwaysIncompatible(true);
        propertyDescriptor7.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        String string8 = CUIPlugin.getResourceString(ELF_HAS_DEBUG);
        PropertyDescriptor propertyDescriptor8 = new PropertyDescriptor((Object)"debug", string8);
        propertyDescriptor8.setAlwaysIncompatible(true);
        propertyDescriptor8.setCategory(ICElementPropertyConstants.P_BINARY_FILE_CATEGORY);
        return new IPropertyDescriptor[]{propertyDescriptor, propertyDescriptor2, propertyDescriptor3, propertyDescriptor4, propertyDescriptor5, propertyDescriptor7, propertyDescriptor8, propertyDescriptor6};
    }

    public BinaryPropertySource(IBinary iBinary) {
        super((IFile)iBinary.getResource());
        this.binary = iBinary;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (fgPropertyDescriptors == null) {
            this.initializeBinaryDescriptors();
        }
        return fgPropertyDescriptors;
    }

    public Object getPropertyValue(Object object) {
        String[] stringArray;
        if (this.element != null && (stringArray = super.getPropertyValue(object)) != null) {
            return stringArray;
        }
        if (object.equals("org.eclipse.jface.text")) {
            return this.binary.getElementName();
        }
        if (object.equals("elf_cpu")) {
            return this.binary.getCPU();
        }
        if (object.equals("text")) {
            return Long.toString(this.binary.getText());
        }
        if (object.equals("data")) {
            return Long.toString(this.binary.getData());
        }
        if (object.equals("bss")) {
            return Long.toString(this.binary.getBSS());
        }
        if (object.equals("soname")) {
            return this.binary.getSoname();
        }
        if (object.equals("debug")) {
            if (this.binary.hasDebug()) {
                return "true";
            }
            return "false";
        }
        if (object.equals("needed")) {
            stringArray = this.binary.getNeededSharedLibs();
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = String.valueOf(string) + " " + stringArray[n];
                ++n;
            }
            return string.trim();
        }
        if (object.equals("type")) {
            if (this.binary.isObject()) {
                return "object";
            }
            if (this.binary.isExecutable()) {
                return "executable";
            }
            if (this.binary.isSharedLib()) {
                return "shared library";
            }
            if (this.binary.isCore()) {
                return "core file";
            }
        }
        return null;
    }

    private void initializeBinaryDescriptors() {
        if (this.element != null) {
            IPropertyDescriptor[] iPropertyDescriptorArray = super.getPropertyDescriptors();
            int n = iPropertyDescriptorArray.length;
            IPropertyDescriptor[] iPropertyDescriptorArray2 = BinaryPropertySource.getInitialPropertyDescriptor();
            int n2 = iPropertyDescriptorArray2.length;
            fgPropertyDescriptors = new IPropertyDescriptor[n + n2];
            System.arraycopy(iPropertyDescriptorArray, 0, fgPropertyDescriptors, 0, n);
            System.arraycopy(iPropertyDescriptorArray2, 0, fgPropertyDescriptors, n, n2);
        } else {
            fgPropertyDescriptors = BinaryPropertySource.getInitialPropertyDescriptor();
        }
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
    }
}

