/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.ui.ICCompletionContributor;
import org.eclipse.cdt.ui.IFunctionSummary;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;

public class CCompletionContributorManager {
    private static List fCompletionContributors;
    static boolean fContributorsLoaded;
    public static final String CONTRIBUTION_EXTENSION = "CCompletionContributor";
    private static CCompletionContributorManager fInstance;

    static {
        fContributorsLoaded = false;
    }

    private CCompletionContributorManager() {
    }

    public static CCompletionContributorManager getDefault() {
        if (fInstance == null) {
            fInstance = new CCompletionContributorManager();
        }
        return fInstance;
    }

    public IFunctionSummary getFunctionInfo(String string) {
        if (!fContributorsLoaded) {
            this.loadExtensions();
        }
        int n = 0;
        while (n < fCompletionContributors.size()) {
            ICCompletionContributor iCCompletionContributor = (ICCompletionContributor)fCompletionContributors.get(n);
            IFunctionSummary iFunctionSummary = iCCompletionContributor.getFunctionInfo(string);
            if (iFunctionSummary != null) {
                return iFunctionSummary;
            }
            ++n;
        }
        return null;
    }

    public IFunctionSummary[] getMatchingFunctions(String string) {
        if (!fContributorsLoaded) {
            this.loadExtensions();
        }
        IFunctionSummary[] iFunctionSummaryArray = null;
        int n = 0;
        while (n < fCompletionContributors.size()) {
            ICCompletionContributor iCCompletionContributor = (ICCompletionContributor)fCompletionContributors.get(n);
            IFunctionSummary[] iFunctionSummaryArray2 = iCCompletionContributor.getMatchingFunctions(string);
            if (iFunctionSummaryArray2 != null) {
                if (iFunctionSummaryArray != null) {
                    int n2 = iFunctionSummaryArray2.length + iFunctionSummaryArray.length;
                    IFunctionSummary[] iFunctionSummaryArray3 = new IFunctionSummary[n2];
                    int n3 = 0;
                    while (n3 < iFunctionSummaryArray.length) {
                        iFunctionSummaryArray3[n3] = iFunctionSummaryArray[n3];
                        ++n3;
                    }
                    n3 = 0;
                    while (n3 < iFunctionSummaryArray2.length) {
                        iFunctionSummaryArray3[n3 + iFunctionSummaryArray.length] = iFunctionSummaryArray2[n3];
                        ++n3;
                    }
                    iFunctionSummaryArray = iFunctionSummaryArray3;
                } else {
                    iFunctionSummaryArray = iFunctionSummaryArray2;
                }
            }
            ++n;
        }
        return iFunctionSummaryArray;
    }

    private void loadExtensions() {
        fContributorsLoaded = true;
        fCompletionContributors = new ArrayList(2);
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui", CONTRIBUTION_EXTENSION);
        if (iExtensionPoint != null) {
            IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
            int n = 0;
            while (n < iConfigurationElementArray.length) {
                if (iConfigurationElementArray[n].getName().equals("provider")) {
                    try {
                        final ICCompletionContributor iCCompletionContributor = (ICCompletionContributor)iConfigurationElementArray[n].createExecutableExtension("class");
                        ISafeRunnable iSafeRunnable = new ISafeRunnable(){

                            public void run() throws Exception {
                                iCCompletionContributor.initialize();
                                fCompletionContributors.add(iCCompletionContributor);
                            }

                            public void handleException(Throwable throwable) {
                            }
                        };
                        Platform.run((ISafeRunnable)iSafeRunnable);
                    }
                    catch (CoreException coreException) {}
                }
                ++n;
            }
        }
    }
}

