/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBinaryModule;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IDeclaration;
import org.eclipse.cdt.core.model.IField;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.core.model.ILibraryReference;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementImageProvider {
    public static final int OVERLAY_ICONS = 1;
    public static final int SMALL_ICONS = 2;
    public static final int LIGHT_TYPE_ICONS = 4;
    public static final int OVERLAY_ERROR = 8;
    public static final int OVERLAY_WARNING = 16;
    public static final int OVERLAY_OVERRIDE = 32;
    public static final int OVERLAY_IMPLEMENTS = 64;
    private static final Point SMALL_SIZE = new Point(16, 16);
    private static final Point BIG_SIZE = new Point(22, 16);
    private static ImageDescriptor DESC_OBJ_PROJECT_CLOSED;
    private static ImageDescriptor DESC_OBJ_PROJECT;
    static /* synthetic */ Class class$0;

    public CElementImageProvider() {
        ISharedImages iSharedImages = CUIPlugin.getDefault().getWorkbench().getSharedImages();
        DESC_OBJ_PROJECT_CLOSED = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT_CLOSED");
        DESC_OBJ_PROJECT = iSharedImages.getImageDescriptor("IMG_OBJ_PROJECT");
    }

    public Image getImageLabel(Object object, int n) {
        IFile iFile;
        Object object2 = null;
        if (object instanceof ICElement) {
            object2 = this.getCImageDescriptor((ICElement)object, n);
        } else if (object instanceof IFile && CoreModel.isValidTranslationUnitName((IProject)(iFile = (IFile)object).getProject(), (String)iFile.getName())) {
            object2 = CPluginImages.DESC_OBJS_TUNIT_RESOURCE;
            Point point = this.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
            object2 = new CElementImageDescriptor((ImageDescriptor)object2, 0, point);
        }
        if (object2 == null && object instanceof IAdaptable) {
            object2 = this.getWorkbenchImageDescriptor((IAdaptable)object, n);
        }
        if (object2 != null) {
            return CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)object2);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(int n) {
        switch (n) {
            case 30: {
                return CPluginImages.DESC_OBJS_CONTAINER;
            }
            case 14: {
                return CPluginImages.DESC_OBJS_BINARY;
            }
            case 18: {
                return CPluginImages.DESC_OBJS_ARCHIVE;
            }
            case 60: {
                return CPluginImages.DESC_OBJS_TUNIT;
            }
            case 12: {
                return CPluginImages.DESC_OBJS_CFOLDER;
            }
            case 11: {
                return DESC_OBJ_PROJECT;
            }
            case 65: 
            case 82: {
                return CPluginImages.DESC_OBJS_STRUCT;
            }
            case 64: 
            case 73: {
                return CPluginImages.DESC_OBJS_CLASS;
            }
            case 66: 
            case 83: {
                return CPluginImages.DESC_OBJS_UNION;
            }
            case 78: {
                return CPluginImages.DESC_OBJS_TYPEDEF;
            }
            case 63: {
                return CPluginImages.DESC_OBJS_ENUMERATION;
            }
            case 79: {
                return CPluginImages.DESC_OBJS_ENUMERATOR;
            }
            case 69: {
                return CPluginImages.DESC_OBJS_PUBLIC_FIELD;
            }
            case 74: 
            case 84: {
                return CPluginImages.DESC_OBJS_VARIABLE;
            }
            case 67: 
            case 68: 
            case 81: {
                return CPluginImages.DESC_OBJS_PUBLIC_METHOD;
            }
            case 71: {
                return CPluginImages.DESC_OBJS_FUNCTION;
            }
            case 75: {
                return CPluginImages.DESC_OBJS_VAR_DECLARARION;
            }
            case 70: 
            case 80: {
                return CPluginImages.DESC_OBJS_DECLARARION;
            }
            case 72: {
                return CPluginImages.DESC_OBJS_INCLUDE;
            }
            case 77: {
                return CPluginImages.DESC_OBJS_MACRO;
            }
            case 61: {
                return CPluginImages.DESC_OBJS_NAMESPACE;
            }
        }
        return null;
    }

    private boolean showOverlayIcons(int n) {
        return (n & 1) != 0;
    }

    private boolean useSmallSize(int n) {
        return (n & 2) != 0;
    }

    public ImageDescriptor getCImageDescriptor(ICElement iCElement, int n) {
        int n2 = this.computeCAdornmentFlags(iCElement, n);
        Point point = this.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        ImageDescriptor imageDescriptor = this.getBaseImageDescriptor(iCElement, n);
        if (imageDescriptor != null) {
            return new CElementImageDescriptor(imageDescriptor, n2, point);
        }
        return null;
    }

    public ImageDescriptor getWorkbenchImageDescriptor(IAdaptable iAdaptable, int n) {
        IWorkbenchAdapter iWorkbenchAdapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iWorkbenchAdapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iAdaptable);
        if (imageDescriptor == null) {
            return null;
        }
        int n2 = this.computeBasicAdornmentFlags(iAdaptable, n);
        Point point = this.useSmallSize(n) ? SMALL_SIZE : BIG_SIZE;
        return new CElementImageDescriptor(imageDescriptor, n2, point);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ImageDescriptor getBaseImageDescriptor(ICElement iCElement, int n) {
        int n2 = iCElement.getElementType();
        switch (n2) {
            case 30: {
                if (iCElement instanceof IBinaryModule) {
                    return CPluginImages.DESC_OBJS_BINARY;
                }
                if (iCElement instanceof ILibraryReference) {
                    return CPluginImages.DESC_OBJS_UNKNOWN;
                }
                if (!(iCElement instanceof IIncludeReference)) return CPluginImages.DESC_OBJS_CONTAINER;
                return CPluginImages.DESC_OBJS_INCLUDES_FOLDER;
            }
            case 14: {
                IBinary iBinary = (IBinary)iCElement;
                if (iBinary.isExecutable()) {
                    if (!iBinary.hasDebug()) return CPluginImages.DESC_OBJS_CEXEC;
                    return CPluginImages.DESC_OBJS_CEXEC_DEBUG;
                }
                if (iBinary.isSharedLib()) {
                    return CPluginImages.DESC_OBJS_SHLIB;
                }
                if (!iBinary.isCore()) return CPluginImages.DESC_OBJS_BINARY;
                return CPluginImages.DESC_OBJS_CORE;
            }
            case 18: {
                return CPluginImages.DESC_OBJS_ARCHIVE;
            }
            case 60: {
                ITranslationUnit iTranslationUnit = (ITranslationUnit)iCElement;
                if (iTranslationUnit.isHeaderUnit()) {
                    return CPluginImages.DESC_OBJS_TUNIT_HEADER;
                }
                if (!iTranslationUnit.isSourceUnit() || !iTranslationUnit.isASMLanguage()) return CPluginImages.DESC_OBJS_TUNIT;
                return CPluginImages.DESC_OBJS_TUNIT_ASM;
            }
            case 12: {
                if (!(iCElement instanceof ISourceRoot)) return CPluginImages.DESC_OBJS_CFOLDER;
                return CPluginImages.DESC_OBJS_SOURCE_ROOT;
            }
            case 11: {
                ImageDescriptor imageDescriptor;
                IWorkbenchAdapter iWorkbenchAdapter;
                ICProject iCProject = (ICProject)iCElement;
                if (!iCProject.getProject().isOpen()) return DESC_OBJ_PROJECT_CLOSED;
                IProject iProject = iCProject.getProject();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iWorkbenchAdapter = (IWorkbenchAdapter)iProject.getAdapter((Class)clazz)) == null || (imageDescriptor = iWorkbenchAdapter.getImageDescriptor((Object)iProject)) == null) return DESC_OBJ_PROJECT;
                return imageDescriptor;
            }
            case 65: 
            case 82: {
                return CElementImageProvider.getStructImageDescriptor();
            }
            case 64: 
            case 73: {
                return CElementImageProvider.getClassImageDescriptor();
            }
            case 66: 
            case 83: {
                return CElementImageProvider.getUnionImageDescriptor();
            }
            case 78: {
                return CElementImageProvider.getTypedefImageDescriptor();
            }
            case 63: {
                return CElementImageProvider.getEnumerationImageDescriptor();
            }
            case 79: {
                return CElementImageProvider.getEnumeratorImageDescriptor();
            }
            case 69: {
                try {
                    IField iField = (IField)iCElement;
                    ASTAccessVisibility aSTAccessVisibility = iField.getVisibility();
                    return CElementImageProvider.getFieldImageDescriptor(aSTAccessVisibility);
                }
                catch (CModelException cModelException) {
                    return null;
                }
            }
            case 67: 
            case 68: 
            case 81: {
                try {
                    IMethodDeclaration iMethodDeclaration = (IMethodDeclaration)iCElement;
                    ASTAccessVisibility aSTAccessVisibility = iMethodDeclaration.getVisibility();
                    return CElementImageProvider.getMethodImageDescriptor(aSTAccessVisibility);
                }
                catch (CModelException cModelException) {
                    return null;
                }
            }
            case 74: 
            case 84: {
                return CElementImageProvider.getVariableImageDescriptor();
            }
            case 71: {
                return CElementImageProvider.getFunctionImageDescriptor();
            }
            case 75: {
                return CElementImageProvider.getVariableDeclarationImageDescriptor();
            }
            case 70: 
            case 80: {
                return CElementImageProvider.getFunctionDeclarationImageDescriptor();
            }
            case 72: {
                return CElementImageProvider.getIncludeImageDescriptor();
            }
            case 77: {
                return CElementImageProvider.getMacroImageDescriptor();
            }
            case 61: {
                return CElementImageProvider.getNamespaceImageDescriptor();
            }
        }
        return null;
    }

    private int computeCAdornmentFlags(ICElement iCElement, int n) {
        int n2 = this.computeBasicAdornmentFlags(iCElement, n);
        try {
            if (this.showOverlayIcons(n) && iCElement instanceof IDeclaration) {
                IDeclaration iDeclaration = (IDeclaration)iCElement;
                if (iDeclaration.isStatic()) {
                    n2 |= 8;
                }
                if (iDeclaration.isConst()) {
                    n2 |= 2;
                }
                if (iDeclaration.isVolatile()) {
                    n2 |= 4;
                }
                if (iCElement instanceof ITemplate) {
                    n2 |= 1;
                }
            }
        }
        catch (CModelException cModelException) {}
        return n2;
    }

    private int computeBasicAdornmentFlags(Object object, int n) {
        int n2 = 0;
        if ((n & 8) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x100;
        }
        return n2;
    }

    public void dispose() {
    }

    public static ImageDescriptor getStructImageDescriptor() {
        return CPluginImages.DESC_OBJS_STRUCT;
    }

    public static ImageDescriptor getClassImageDescriptor() {
        return CPluginImages.DESC_OBJS_CLASS;
    }

    public static ImageDescriptor getUnionImageDescriptor() {
        return CPluginImages.DESC_OBJS_UNION;
    }

    public static ImageDescriptor getTypedefImageDescriptor() {
        return CPluginImages.DESC_OBJS_TYPEDEF;
    }

    public static ImageDescriptor getEnumerationImageDescriptor() {
        return CPluginImages.DESC_OBJS_ENUMERATION;
    }

    public static ImageDescriptor getEnumeratorImageDescriptor() {
        return CPluginImages.DESC_OBJS_ENUMERATOR;
    }

    public static ImageDescriptor getFieldImageDescriptor(ASTAccessVisibility aSTAccessVisibility) {
        if (aSTAccessVisibility == ASTAccessVisibility.PUBLIC) {
            return CPluginImages.DESC_OBJS_PUBLIC_FIELD;
        }
        if (aSTAccessVisibility == ASTAccessVisibility.PROTECTED) {
            return CPluginImages.DESC_OBJS_PROTECTED_FIELD;
        }
        return CPluginImages.DESC_OBJS_PRIVATE_FIELD;
    }

    public static ImageDescriptor getMethodImageDescriptor(ASTAccessVisibility aSTAccessVisibility) {
        if (aSTAccessVisibility == ASTAccessVisibility.PUBLIC) {
            return CPluginImages.DESC_OBJS_PUBLIC_METHOD;
        }
        if (aSTAccessVisibility == ASTAccessVisibility.PROTECTED) {
            return CPluginImages.DESC_OBJS_PROTECTED_METHOD;
        }
        return CPluginImages.DESC_OBJS_PRIVATE_METHOD;
    }

    public static ImageDescriptor getVariableImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(74);
    }

    public static ImageDescriptor getLocalVariableImageDescriptor() {
        return CPluginImages.DESC_OBJS_LOCAL_VARIABLE;
    }

    public static ImageDescriptor getFunctionImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(71);
    }

    public static ImageDescriptor getVariableDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(75);
    }

    public static ImageDescriptor getFunctionDeclarationImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(70);
    }

    public static ImageDescriptor getIncludeImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(72);
    }

    public static ImageDescriptor getMacroImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(77);
    }

    public static ImageDescriptor getNamespaceImageDescriptor() {
        return CElementImageProvider.getImageDescriptor(61);
    }

    public static ImageDescriptor getKeywordImageDescriptor() {
        return CPluginImages.DESC_OBJS_KEYWORD;
    }
}

