/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.IAdornmentProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class ErrorTickAdornmentProvider
implements IAdornmentProvider {
    private static final int ERRORTICK_WARNING = 16;
    private static final int ERRORTICK_ERROR = 8;

    public int computeAdornmentFlags(Object object) {
        try {
            if (object instanceof ICElement) {
                ICElement iCElement = (ICElement)object;
                int n = iCElement.getElementType();
                switch (n) {
                    case 11: 
                    case 12: {
                        return this.getErrorTicksFromMarkers(iCElement.getResource(), 2, null);
                    }
                    case 60: {
                        return this.getErrorTicksFromMarkers(iCElement.getResource(), 1, null);
                    }
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 71: 
                    case 74: {
                        ITranslationUnit iTranslationUnit = ((ISourceReference)iCElement).getTranslationUnit();
                        if (iTranslationUnit == null || !iTranslationUnit.exists()) break;
                        ISourceRange iSourceRange = ((ISourceReference)iCElement).getSourceRange();
                        return this.getErrorTicksFromMarkers(iTranslationUnit.getResource(), 1, iSourceRange);
                    }
                }
            } else if (object instanceof IResource) {
                return this.getErrorTicksFromMarkers((IResource)object, 2, null);
            }
        }
        catch (CoreException coreException) {
            CUIPlugin.getDefault().log(coreException);
        }
        return 0;
    }

    public void dispose() {
    }

    private int getErrorTicksFromMarkers(IResource iResource, int n, ISourceRange iSourceRange) throws CoreException {
        if (iResource == null || !iResource.isAccessible()) {
            return 0;
        }
        int n2 = 0;
        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.cdt.core.problem", true, n);
        if (iMarkerArray != null) {
            int n3 = 0;
            while (n3 < iMarkerArray.length && n2 != 8) {
                IMarker iMarker = iMarkerArray[n3];
                if (iSourceRange == null || this.isMarkerInRange(iMarker, iSourceRange)) {
                    int n4 = iMarker.getAttribute("severity", -1);
                    if (n4 == 1) {
                        n2 = 16;
                    } else if (n4 == 2) {
                        n2 = 8;
                    }
                }
                ++n3;
            }
        }
        return n2;
    }

    private boolean isMarkerInRange(IMarker iMarker, ISourceRange iSourceRange) throws CoreException {
        if (iMarker.isSubtypeOf("org.eclipse.core.resources.textmarker")) {
            int n;
            int n2 = iMarker.getAttribute("charStart", -1);
            int n3 = iSourceRange.getStartPos();
            if (n2 == -1 && (n = MarkerUtilities.getLineNumber((IMarker)iMarker)) >= 0) {
                return n >= iSourceRange.getStartLine() && n <= iSourceRange.getEndLine();
            }
            return n3 <= n2 && n3 + iSourceRange.getLength() > n2;
        }
        return false;
    }

    private IMarker isAnnotationInRange(IAnnotationModel iAnnotationModel, Annotation annotation, ISourceRange iSourceRange) throws CoreException {
        Position position;
        IMarker iMarker;
        if (annotation instanceof MarkerAnnotation && (iMarker = ((MarkerAnnotation)annotation).getMarker()).exists() && iMarker.isSubtypeOf("org.eclipse.cdt.core.problem") && (position = iAnnotationModel.getPosition(annotation)).overlapsWith(iSourceRange.getStartPos(), iSourceRange.getLength())) {
            return iMarker;
        }
        return null;
    }
}

