/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.util.Collection;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.IArchive;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.browser.cbrowsing.CBrowsingPart;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class CBrowsingContentProvider
extends BaseCElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected StructuredViewer fViewer;
    protected Object fInput;
    protected CBrowsingPart fBrowsingPart;
    protected int fReadsInDisplayThread;
    protected static final Object[] NO_CHILDREN = new Object[0];

    public CBrowsingContentProvider(CBrowsingPart cBrowsingPart) {
        this.fBrowsingPart = cBrowsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            object2 = !collection.isEmpty() ? collection.iterator().next() : null;
        }
        this.fInput = object2;
    }

    public void dispose() {
        CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (CModelException cModelException) {
            CUIPlugin.getDefault().log(cModelException.getStatus());
        }
    }

    protected boolean isPathEntryChange(ICElementDelta iCElementDelta) {
        int n = iCElementDelta.getFlags();
        return iCElementDelta.getKind() == 4 && ((n & 0x800000) != 0 || (n & 0x1000) != 0 || (n & 0x100) != 0 || (n & 0x2000) != 0 || (n & 0x40000) != 0 || (n & 0x200) != 0 || (n & 0x800) != 0);
    }

    protected void processDelta(ICElementDelta iCElementDelta) throws CModelException {
        ICElementDelta[] iCElementDeltaArray;
        int n = iCElementDelta.getKind();
        int n2 = iCElementDelta.getFlags();
        ICElement iCElement = iCElementDelta.getElement();
        if ((n2 & 0x80) != 0 || (n2 & 0x40) != 0) {
            this.postRefresh(iCElement);
        }
        if (n == 2) {
            this.postRemove(iCElement);
        }
        if (n == 1) {
            iCElementDeltaArray = this.internalGetParent(iCElement);
            this.postAdd(iCElementDeltaArray, iCElement);
        }
        if (n == 4 && (iCElement instanceof ITranslationUnit || iCElement instanceof IBinary || iCElement instanceof IArchive)) {
            this.postRefresh(iCElement);
            return;
        }
        if (this.isPathEntryChange(iCElementDelta)) {
            this.postRefresh(iCElement.getCProject());
        }
        iCElementDeltaArray = iCElementDelta.getAffectedChildren();
        int n3 = 0;
        while (n3 < iCElementDeltaArray.length) {
            this.processDelta(iCElementDeltaArray[n3]);
            ++n3;
        }
    }

    private void postRefresh(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (object instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(object) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(object);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(object);
                    }
                }
            }
        });
    }

    private void postAdd(final Object object, Object object2) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (object instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(object) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(object);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(object);
                    }
                }
            }
        });
    }

    private void postRemove(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = CBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    Object object2 = CBrowsingContentProvider.this.internalGetParent(object);
                    if (object2 instanceof IWorkingCopy) {
                        if (CBrowsingContentProvider.this.fViewer.testFindItem(object2) != null) {
                            CBrowsingContentProvider.this.fViewer.refresh(object2);
                        } else {
                            CBrowsingContentProvider.this.fViewer.refresh((Object)((IWorkingCopy)object2).getOriginalElement());
                        }
                    } else {
                        CBrowsingContentProvider.this.fViewer.refresh(object2);
                    }
                }
            }
        });
    }

    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            control.getDisplay().asyncExec(runnable);
        }
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control control = this.fViewer.getControl();
        if (control == null) {
            return false;
        }
        Display display = Display.getCurrent();
        return display != null && display.equals(control.getDisplay());
    }
}

